/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
public class RestFeeds
extends RestBase {
    @POST
    @Path(value="{tenantId}/{environmentId}/feeds")
    @ApiOperation(value="Registers a feed with the inventory, giving it a unique ID.")
    @ApiResponses(value={@ApiResponse(code=201, message="OK", response=Feed.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response register(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Feed.Blueprint blueprint, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(Feed.class).under(Environment.class, new String[]{tenantId, environmentId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Feed feed = (Feed)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).create(blueprint).entity();
        return ResponseUtil.created((UriInfo)uriInfo, (String)feed.getId()).entity((Object)feed).build();
    }

    @GET
    @Path(value="{tenantId}/{environmentId}/feeds")
    @ApiOperation(value="Return all the feeds registered with the inventory")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Set.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @Context UriInfo uriInfo) {
        Page ret = ((Feeds.Multiple)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @Path(value="{tenantId}/{environmentId}/feeds/{feedId}")
    @ApiOperation(value="Return a single feed by its ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Set.class), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Feed get(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId) {
        return (Feed)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).entity();
    }

    @PUT
    @Path(value="/{tenantId}/{environmentId}/feeds/{feedId}")
    @ApiOperation(value="Updates a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or the feed doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, Feed.Update update) {
        if (!this.security.canUpdate(Feed.class, new String[]{tenantId, environmentId, feedId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).update(feedId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/{environmentId}/feeds/{feedId}")
    @ApiOperation(value="Deletes a feed")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or the feed doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId) {
        if (!this.security.canDelete(Feed.class, new String[]{tenantId, environmentId, feedId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).delete(feedId);
        return Response.noContent().build();
    }
}

