/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Metrics CRUD")
public class RestMetrics
extends RestBase {
    @POST
    @Path(value="/{tenantId}/{environmentId}/metrics")
    @ApiOperation(value="Creates a new metric in given environment")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created"), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=409, message="Metric already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Metric.Blueprint metric, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(Metric.class).under(Environment.class, new String[]{tenantId, environmentId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.createMetric((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics(), metric);
        return ResponseUtil.created((UriInfo)uriInfo, (String)metric.getId()).build();
    }

    @POST
    @Path(value="/{tenantId}/{environmentId}/{feedId}/metrics")
    @ApiOperation(value="Creates a new metric in given feed")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created"), @ApiResponse(code=400, message="Invalid inputs", response=ApiError.class), @ApiResponse(code=409, message="Metric already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response createMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @ApiParam(required=true) Metric.Blueprint metric, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(Metric.class).under(Feed.class, new String[]{tenantId, environmentId, feedId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.createMetric((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).metrics(), metric);
        return ResponseUtil.created((UriInfo)uriInfo, (String)metric.getId()).build();
    }

    private void createMetric(Metrics.ReadWrite accessInterface, Metric.Blueprint metric) {
        if (metric == null) {
            throw new IllegalArgumentException("metric to create not specified");
        }
        if (metric.getId() == null) {
            throw new IllegalArgumentException("metric id not specified");
        }
        if (metric.getMetricTypeId() == null) {
            throw new IllegalArgumentException("metric type id not specified");
        }
        accessInterface.create((Entity.Blueprint)metric);
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single metric")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or metrics doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Metric getMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId) {
        return (Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics()).get(metricId)).entity();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single metric")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Metric getMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId) {
        return (Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).metrics()).get(metricId)).entity();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/metrics")
    @ApiOperation(value="Retrieves all metrics in an environment. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetrics(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        Environments.Single envs = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId);
        Page ret = ((Metrics.Multiple)(feedless ? (ResolvingToMultiple)envs.feedlessMetrics() : envs.allMetrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/metrics")
    @ApiOperation(value="Retrieves all metrics in a feed")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetrics(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        Page ret = ((Metrics.Multiple)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @PUT
    @Path(value="/{tenantId}/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Updates a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId, Metric.Update update) {
        if (!this.security.canUpdate(Metric.class, new String[]{tenantId, environmentId, metricId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics()).update(metricId, (Object)update);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/{tenantId}/{environmentId}/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Updates a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The update failed because of invalid data"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId, Metric.Update update) {
        if (!this.security.canUpdate(Metric.class, new String[]{tenantId, environmentId, feedId, metricId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).metrics()).update(metricId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/{environmentId}/metrics/{metricId}")
    @ApiOperation(value="Deletes a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="metricId") String metricId) {
        if (!this.security.canDelete(Metric.class, new String[]{tenantId, environmentId, metricId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics()).delete(metricId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/{environmentId}/{feedId}/metrics/{metricId}")
    @ApiOperation(value="Deletes a metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or the metric doesn't exist", response=ApiError.class), @ApiResponse(code=400, message="The delete failed because it would make inventory invalid"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteMetric(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="metricId") String metricId) {
        if (!this.security.canDelete(Metric.class, new String[]{tenantId, environmentId, feedId, metricId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).metrics()).delete(metricId);
        return Response.noContent().build();
    }
}

