/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resources CRUD")
public class RestResources
extends RestBase {
    @POST
    @Path(value="/{tenantId}/{environmentId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(Resource.class).under(Environment.class, new String[]{tenantId, environmentId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @POST
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources")
    @ApiOperation(value="Creates a new resource")
    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @ApiParam(required=true) Resource.Blueprint resource, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(Resource.class).under(Feed.class, new String[]{tenantId, environmentId, feedId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).create((Entity.Blueprint)resource);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resource.getId()).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/resources")
    @ApiOperation(value="Retrieves resources in the environment, optionally filtering by resource type. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant or environment doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResourcesByType(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @QueryParam(value="type") String typeId, @QueryParam(value="typeVersion") String typeVersion, @QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        Page rs;
        Environments.Single envs = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId);
        ResolvingToMultiple rr = feedless ? (ResolvingToMultiple)envs.feedlessResources() : envs.allResources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        if (typeId != null && typeVersion != null) {
            ResourceType rt = new ResourceType(tenantId, typeId, typeVersion);
            rs = ((Resources.Multiple)rr.getAll(new Filter[]{Defined.by((ResourceType)rt)})).entities(pager);
        } else {
            rs = ((Resources.Multiple)rr.getAll(new Filter[0])).entities(pager);
        }
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)rs).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources")
    @ApiOperation(value="Retrieves resources in the feed, optionally filtering by resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or feed doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResourcesByType(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @QueryParam(value="type") String typeId, @QueryParam(value="typeVersion") String typeVersion, @Context UriInfo uriInfo) {
        Page rs;
        Resources.ReadWrite rr = (Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources();
        Pager pager = RequestUtil.extractPaging((UriInfo)uriInfo);
        if (typeId != null && typeVersion != null) {
            ResourceType rt = new ResourceType(tenantId, typeId, typeVersion);
            rs = ((Resources.Multiple)rr.getAll(new Filter[]{Defined.by((ResourceType)rt)})).entities(pager);
        } else {
            rs = ((Resources.Multiple)rr.getAll(new Filter[0])).entities(pager);
        }
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)rs).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/resources/{resourceId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="resourceId") String uid) {
        return (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).get(uid)).entity();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources/{resourceId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Resource getResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String uid) {
        return (Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).get(uid)).entity();
    }

    @PUT
    @Path(value="{tenantId}/{environmentId}/resources/{resourceId}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="resourceId") String resourceId, @ApiParam(required=true) Resource.Update update) {
        if (!this.security.canUpdate(Resource.class, new String[]{tenantId, environmentId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).update(resourceId, (Object)update);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{tenantId}/{environmentId}/{feedId}/resources/{resourceId}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String resourceId, @ApiParam(required=true) Resource.Update update) {
        if (!this.security.canUpdate(Resource.class, new String[]{tenantId, environmentId, feedId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).update(resourceId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/{environmentId}/resources/{resourceId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="resourceId") String resourceId) {
        if (!this.security.canDelete(Resource.class, new String[]{tenantId, environmentId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).delete(resourceId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources/{resourceId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response deleteResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String resourceId) {
        if (!this.security.canDelete(Resource.class, new String[]{tenantId, environmentId, feedId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).delete(resourceId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{tenantId}/{environmentId}/resources/{resourceId}/metrics/")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addMetricToResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="resourceId") String resourceId, Collection<String> metricIds) {
        if (!this.security.canAssociateFrom(Resource.class, new String[]{tenantId, environmentId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).get(resourceId)).metrics();
        metricIds.forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources/{resourceId}/metrics/")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addMetricToResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String resourceId, Collection<String> metricIds) {
        if (!this.security.canAssociateFrom(Resource.class, new String[]{tenantId, environmentId, feedId, resourceId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).get(resourceId)).metrics();
        metricIds.forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/resources/{resourceId}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response listMetricsOfResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentID, @PathParam(value="resourceId") String resourceId, @Context UriInfo uriInfo) {
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentID)).feedlessResources()).get(resourceId)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ms).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources/{resourceId}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response listMetricsOfResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String resourceId, @Context UriInfo uriInfo) {
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).get(resourceId)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ms).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/resources/{resourceId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist or if the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetricOfResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="resourceId") String resourceId, @PathParam(value="metricId") String metricId) {
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).get(resourceId)).metrics()).get(metricId)).entity();
        return Response.ok((Object)m).build();
    }

    @GET
    @Path(value="/{tenantId}/{environmentId}/{feedId}/resources/{resourceId}/metrics/{metricId}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric doesn't exist or if the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetricOfResource(@PathParam(value="tenantId") String tenantId, @PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @PathParam(value="resourceId") String resourceId, @PathParam(value="metricId") String metricId) {
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feeds()).get(feedId)).resources()).get(resourceId)).metrics()).get(metricId)).entity();
        return Response.ok((Object)m).build();
    }
}

