/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.cdi.ObservableAutoTenant;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.Security;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class Security {
    private final Map<Class<?>, Map<OperationType, Operation>> operationsByType = new HashMap();
    @Inject
    private PermissionChecker permissions;
    @Inject
    private OperationService operations;
    @Inject
    @ObservableAutoTenant
    private Inventory.Mixin.AutoTenantAndObservable inventory;
    @Resource
    private UserTransaction transaction;

    public static String getStableId(AbstractElement<?, ?> element) {
        if (element instanceof Relationship) {
            return element.getId();
        }
        return (String)((Entity)element).accept((EntityVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    public static String getStableId(Class<? extends AbstractElement<?, ?>> type, String ... ids) {
        if (Tenant.class.isAssignableFrom(type)) {
            return Security.join((String[])new String[]{"tenant", ids[0]});
        }
        if (Environment.class.isAssignableFrom(type)) {
            return Security.join((String[])new String[]{ids[0], "environments", ids[1]});
        }
        if (ResourceType.class.isAssignableFrom(type)) {
            return Security.join((String[])new String[]{ids[0], "resourceTypes", ids[1]});
        }
        if (MetricType.class.isAssignableFrom(type)) {
            return Security.join((String[])new String[]{ids[0], "metricTypes", ids[1]});
        }
        if (Feed.class.isAssignableFrom(type)) {
            return Security.join((String[])new String[]{ids[0], ids[1], "feeds", ids[2]});
        }
        if (org.hawkular.inventory.api.model.Resource.class.isAssignableFrom(type)) {
            if (ids.length == 3) {
                return Security.join((String[])new String[]{ids[0], ids[1], "resources", ids[2]});
            }
            return Security.join((String[])new String[]{ids[0], ids[1], ids[2], "resources", ids[3]});
        }
        if (Metric.class.isAssignableFrom(type)) {
            if (ids.length == 3) {
                return Security.join((String[])new String[]{ids[0], ids[1], "metrics", ids[2]});
            }
            return Security.join((String[])new String[]{ids[0], ids[1], ids[2], "metrics", ids[3]});
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return "relationships/" + ids[0];
        }
        throw new IllegalArgumentException("Unknown entity type: " + type);
    }

    private static String join(String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder bld = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            bld.append('/').append(strings[i]);
        }
        String retString = bld.toString();
        if (retString.length() > 250) {
            StringBuilder bld2 = new StringBuilder(strings[0]);
            bld2.append('/').append(UUID.nameUUIDFromBytes(retString.getBytes()));
            return bld2.toString();
        }
        return retString;
    }

    private Operation create(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.CREATE);
    }

    public CreatePermissionCheckerFinisher canCreate(Class<?> entityType) {
        return new CreatePermissionCheckerFinisher(this, entityType, null);
    }

    private Operation update(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.UPDATE);
    }

    public boolean canUpdate(Class<? extends Entity<?, ?>> entityType, String ... entityPath) {
        return this.safePermissionCheck(entityType, Security.last((String[])entityPath), this.update(entityType), Security.getStableId(entityType, (String[])entityPath));
    }

    private Operation delete(Class<?> entityType) {
        return this.getOperation(entityType, OperationType.DELETE);
    }

    public boolean canDelete(Class<? extends Entity<?, ?>> entityType, String ... entityPath) {
        return this.safePermissionCheck(entityType, Security.last((String[])entityPath), this.delete(entityType), Security.getStableId(entityType, (String[])entityPath));
    }

    private Operation associate() {
        return (Operation)((Map)this.operationsByType.get(Relationship.class)).get(OperationType.ASSOCIATE);
    }

    public boolean canAssociateFrom(Class<? extends Entity<?, ?>> entityType, String ... entityPath) {
        return this.safePermissionCheck(entityType, Security.last((String[])entityPath), this.associate(), Security.getStableId(entityType, (String[])entityPath));
    }

    private Operation copy() {
        return (Operation)((Map)this.operationsByType.get(Environment.class)).get(OperationType.COPY);
    }

    public boolean canCopyEnvironment(String ... environmentPath) {
        return this.safePermissionCheck(Environment.class, Security.last((String[])environmentPath), this.copy(), Security.getStableId(Environment.class, (String[])environmentPath));
    }

    private Operation getOperation(Class<?> cls, OperationType operationType) {
        Map ops = (Map)this.operationsByType.get(cls);
        if (ops == null) {
            throw new IllegalArgumentException("There is no " + operationType + " operation for elements of type " + cls);
        }
        return (Operation)ops.get(operationType);
    }

    private boolean safePermissionCheck(Class<?> entityType, String entityId, Operation operation, String stableId) {
        try {
            if (Tenant.class.equals(entityType) && !((Tenants.Single)this.inventory.tenants().get(entityId)).exists()) {
                this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(entityId)).build());
            }
            return this.permissions.isAllowedTo(operation, stableId);
        }
        catch (Exception e) {
            RestApiLogger.LOGGER.securityCheckFailed(stableId, (Throwable)e);
            return false;
        }
    }

    private static String last(String ... elements) {
        return elements[elements.length - 1];
    }

    @PostConstruct
    public void initOperationsMap() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        this.transaction.begin();
        try {
            this.operations.setup("update-tenant").add("SuperUser").persist();
            this.operations.setup("delete-tenant").add("SuperUser").persist();
            this.operations.setup("create-environment").add("Administrator").persist();
            this.operations.setup("update-environment").add("Administrator").persist();
            this.operations.setup("delete-environment").add("Administrator").persist();
            this.operations.setup("copy-environment").add("Administrator").persist();
            this.operations.setup("create-resourceType").add("Administrator").persist();
            this.operations.setup("update-resourceType").add("Administrator").persist();
            this.operations.setup("delete-resourceType").add("Administrator").persist();
            this.operations.setup("create-metricType").add("Administrator").persist();
            this.operations.setup("update-metricType").add("Administrator").persist();
            this.operations.setup("delete-metricType").add("Administrator").persist();
            this.operations.setup("create-feed").add("Administrator").persist();
            this.operations.setup("update-feed").add("Administrator").persist();
            this.operations.setup("delete-feed").add("Administrator").persist();
            this.operations.setup("create-resource").add("Maintainer").persist();
            this.operations.setup("update-resource").add("Maintainer").persist();
            this.operations.setup("delete-resource").add("Maintainer").persist();
            this.operations.setup("create-metric").add("Maintainer").persist();
            this.operations.setup("update-metric").add("Maintainer").persist();
            this.operations.setup("delete-metric").add("Maintainer").persist();
            this.operations.setup("associate").add("Operator").persist();
            this.transaction.commit();
        }
        catch (Throwable t) {
            this.transaction.rollback();
            throw t;
        }
        Operation updateTenantOperation = this.operations.getByName("update-tenant");
        Operation deleteTenantOperation = this.operations.getByName("delete-tenant");
        Operation createEnvironmentOperation = this.operations.getByName("create-environment");
        Operation updateEnvironmentOperation = this.operations.getByName("update-environment");
        Operation deleteEnvironmentOperation = this.operations.getByName("delete-environment");
        Operation copyEnvironmentOperation = this.operations.getByName("copy-environment");
        Operation createResourceTypeOperation = this.operations.getByName("create-resourceType");
        Operation updateResourceTypeOperation = this.operations.getByName("update-resourceType");
        Operation deleteResourceTypeOperation = this.operations.getByName("delete-resourceType");
        Operation createMetricTypeOperation = this.operations.getByName("create-metricType");
        Operation updateMetricTypeOperation = this.operations.getByName("update-metricType");
        Operation deleteMetricTypeOperation = this.operations.getByName("delete-metricType");
        Operation createFeedOperation = this.operations.getByName("create-feed");
        Operation updateFeedOperation = this.operations.getByName("update-feed");
        Operation deleteFeedOperation = this.operations.getByName("delete-feed");
        Operation createResourceOperation = this.operations.getByName("create-resource");
        Operation updateResourceOperation = this.operations.getByName("update-resource");
        Operation deleteResourceOperation = this.operations.getByName("delete-resource");
        Operation createMetricOperation = this.operations.getByName("create-metric");
        Operation updateMetricOperation = this.operations.getByName("update-metric");
        Operation deleteMetricOperation = this.operations.getByName("delete-metric");
        Operation associate = this.operations.getByName("associate");
        this.operationsByType.put(Tenant.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(Environment.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(ResourceType.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(MetricType.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(Feed.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(org.hawkular.inventory.api.model.Resource.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(Metric.class, new /* Unavailable Anonymous Inner Class!! */);
        this.operationsByType.put(Relationship.class, new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ String access$100(String[] x0) {
        return Security.last((String[])x0);
    }

    static /* synthetic */ Operation access$200(Security x0, Class x1) {
        return x0.create(x1);
    }

    static /* synthetic */ boolean access$300(Security x0, Class x1, String x2, Operation x3, String x4) {
        return x0.safePermissionCheck(x1, x2, x3, x4);
    }
}

