/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.integrated.inventory;

import java.util.IdentityHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.hawkular.integrated.inventory.Log;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.bus.BusIntegration;
import org.hawkular.inventory.bus.Configuration;
import org.hawkular.inventory.cdi.DisposingObservableInventory;
import org.hawkular.inventory.cdi.ObservableInventoryInitialized;

@ApplicationScoped
public class BusIntegrationProducer {
    private final IdentityHashMap<Inventory, BusIntegration> integrations = new IdentityHashMap();

    public void install(@Observes ObservableInventoryInitialized event) throws JMSException, NamingException {
        BusIntegration integration = (BusIntegration)this.integrations.get(event.getInventory());
        if (integration == null) {
            integration = this.newIntegration((Inventory.Mixin.Observable)event.getInventory());
            integration.start();
            this.integrations.put(event.getInventory(), integration);
        }
    }

    public void close(@Observes DisposingObservableInventory event) throws NamingException {
        BusIntegration integration = (BusIntegration)this.integrations.remove(event.getInventory());
        if (integration != null) {
            integration.stop();
        }
    }

    private BusIntegration newIntegration(Inventory.Mixin.Observable inventory) {
        BusIntegration ret = new BusIntegration(inventory);
        ret.configure(Configuration.getDefaultConfiguration());
        try {
            ret.start();
        }
        catch (JMSException | NamingException e) {
            Log.LOGGER.busInitializationFailed(e);
        }
        return ret;
    }
}

