/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;
import org.hawkular.inventory.rest.json.IdJSON;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resource type CRUD")
public class RestResourceTypes
extends RestBase {
    @GET
    @Path(value="/{tenantId}/resourceTypes")
    @ApiOperation(value="Retrieves all resource types. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of resource types"), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@PathParam(value="tenantId") String tenantId, @Context UriInfo uriInfo) {
        Page ret = ((ResourceTypes.Multiple)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Retrieves a single resource type")
    @ApiResponses(value={@ApiResponse(code=200, message="the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public ResourceType get(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId) {
        return (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).entity();
    }

    @GET
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Retrieves all metric types associated with the resource type. Accepts paging query params.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of metric types associated with the resource type"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getMetricTypes(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        Page ret = ((MetricTypes.Multiple)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @GET
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}/resources")
    @ApiOperation(value="Retrieves all resources with given resource types. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="the list of resources"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getResources(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId, @Context UriInfo uriInfo) {
        ResourceTypes.Single single = (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId);
        single.entity();
        Page ret = ((Resources.Multiple)((Resources.Read)single.resources()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return ResponseUtil.pagedResponse((Response.ResponseBuilder)Response.ok(), (UriInfo)uriInfo, (Page)ret).build();
    }

    @POST
    @Path(value="/{tenantId}/resourceTypes")
    @ApiOperation(value="Creates a new resource type")
    @ApiResponses(value={@ApiResponse(code=201, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Resource type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@PathParam(value="tenantId") String tenantId, ResourceType.Blueprint resourceType, @Context UriInfo uriInfo) {
        if (!this.security.canCreate(ResourceType.class).under(Tenant.class, new String[]{tenantId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).create((Entity.Blueprint)resourceType);
        return ResponseUtil.created((UriInfo)uriInfo, (String)resourceType.getId()).build();
    }

    @PUT
    @Path(value="{tenantId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Update a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId, @ApiParam(required=true) ResourceType.Update update) {
        if (!this.security.canUpdate(ResourceType.class, new String[]{tenantId, resourceTypeId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).update(resourceTypeId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}")
    @ApiOperation(value="Deletes a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant or resource type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId) {
        if (!this.security.canDelete(ResourceType.class, new String[]{tenantId, resourceTypeId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).delete(resourceTypeId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}/metricTypes")
    @ApiOperation(value="Associates a pre-existing metric type with a resource type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, resource type or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response addMetricType(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId, IdJSON metricTypeId) {
        if (!this.security.canAssociateFrom(ResourceType.class, new String[]{tenantId, resourceTypeId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).metricTypes()).associate(metricTypeId.getId());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{tenantId}/resourceTypes/{resourceTypeId}/metricTypes/{metricTypeId}")
    @ApiOperation(value="Disassociates the resource type with a metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, resource type or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response removeMetricType(@PathParam(value="tenantId") String tenantId, @PathParam(value="resourceTypeId") String resourceTypeId, @PathParam(value="metricTypeId") String metricTypeId) {
        if (!this.security.canAssociateFrom(ResourceType.class, new String[]{tenantId, resourceTypeId})) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).metricTypes()).disassociate(metricTypeId);
        return Response.noContent().build();
    }
}

