/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hawkular.inventory.api.IdentityHash;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.junit.Assert;
import org.junit.Test;

public class ContentHashTest {
    @Test
    public void testMetricTypeHash() throws Exception {
        MetricType.Blueprint mtb = ((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mt")).withUnit(MetricUnit.NONE).build();
        MetadataPack.Members members = MetadataPack.Members.builder().with(mtb).build();
        String blueprintHash = IdentityHash.of((MetadataPack.Members)members);
        String expectedHash = this.digest(mtb.getId() + mtb.getType() + mtb.getUnit());
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    @Test
    public void testResourceTypeHashWithNoAppendages() throws Exception {
        ResourceType.Blueprint rtb = ((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build();
        MetadataPack.Members members = MetadataPack.Members.builder().with(rtb).done().build();
        String blueprintHash = IdentityHash.of((MetadataPack.Members)members);
        String expectedHash = this.digest(rtb.getId() + "nullnull");
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    @Test
    public void testResourceTypeHashWithAppendages() throws Exception {
        DataEntity.Blueprint configSchema = DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.configurationSchema).withValue(StructuredData.get().integral(Long.valueOf(5L))).build();
        DataEntity.Blueprint connSchema = DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.connectionConfigurationSchema).withValue(((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addUndefined()).build()).build();
        OperationType.Blueprint otb = ((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("op")).build();
        DataEntity.Blueprint returnType = DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.returnType).withValue(StructuredData.get().integral(Long.valueOf(42L))).build();
        DataEntity.Blueprint parameterTypes = DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.parameterTypes).withValue(StructuredData.get().string("answer")).build();
        ResourceType.Blueprint rtb = ((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build();
        MetadataPack.Members members = MetadataPack.Members.builder().with(rtb).with(configSchema).with(connSchema).with(otb).with(returnType).with(parameterTypes).done().done().build();
        String expectedHash = this.digest(rtb.getId() + configSchema.getValue().toJSON() + connSchema.getValue().toJSON() + otb.getId() + returnType.getValue().toJSON() + parameterTypes.getValue().toJSON());
        String blueprintHash = IdentityHash.of((MetadataPack.Members)members);
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    private String digest(String content) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("SHA-1").digest(content.getBytes(Charset.forName("UTF-8")));
        StringBuilder bld = new StringBuilder();
        for (byte b : digest) {
            bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
        }
        return bld.toString();
    }
}

