/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Marker;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.PotentiallyCommittingPayload;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.TransactionFailureException;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;

final class Util {
    private static final Random rand = new Random();

    private Util() {
    }

    public static <R> R commitOrRetry(InventoryBackend.Transaction transaction, InventoryBackend<?> backend, R firstCommitSuccessReturnValue, PotentiallyCommittingPayload<R> payload, int maxRetries) {
        return (R)Util.commitOrRetry(transaction, backend, t -> firstCommitSuccessReturnValue, payload, maxRetries, false);
    }

    public static <R> R runInTransaction(TraversalContext<?, ?> context, boolean readOnly, PotentiallyCommittingPayload<R> payload) {
        InventoryBackend.Transaction transaction = context.backend.startTransaction(!readOnly);
        Log.LOGGER.trace("Starting transaction: " + transaction);
        int maxFailures = context.getTransactionRetriesCount();
        return Util.commitOrRetry(transaction, context.backend, payload, payload, maxFailures, true);
    }

    private static <R> R commitOrRetry(InventoryBackend.Transaction transaction, InventoryBackend<?> backend, PotentiallyCommittingPayload<R> firstPayload, PotentiallyCommittingPayload<R> succeedingPayload, int maxFailures, boolean commitOnlyReadonly) {
        int failures = 0;
        int waitTime = 100;
        while (true) {
            try {
                try {
                    R ret;
                    if (failures == 0) {
                        ret = transaction.execute(firstPayload);
                    } else {
                        transaction = backend.startTransaction(transaction.isMutating());
                        ret = transaction.execute(succeedingPayload);
                    }
                    if (!commitOnlyReadonly || !transaction.isMutating()) {
                        backend.commit(transaction);
                    }
                    return ret;
                }
                catch (Throwable t) {
                    Log.LOGGER.dTransactionFailed(t.getMessage());
                    backend.rollback(transaction);
                    throw t;
                }
            }
            catch (CommitFailureException e) {
                CommitFailureException lastException;
                block10: {
                    Log.LOGGER.debugf(e, "Commit attempt %d/%d failed. Will wait for %d ms before retrying. The failure message was: %s", new Object[]{++failures, maxFailures, waitTime, e.getMessage()});
                    lastException = e;
                    if (failures >= maxFailures) continue;
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException ie) {
                        Log.LOGGER.wInterruptedWhileWaitingForTransactionRetry();
                        Thread.currentThread().interrupt();
                        break block10;
                    }
                    waitTime = waitTime * 2 + rand.nextInt(waitTime / 10);
                    if (failures < maxFailures) continue;
                }
                throw new TransactionFailureException(lastException, failures);
            }
            break;
        }
    }

    public static <BE> BE getSingle(InventoryBackend<BE> backend, Query query, Class<? extends Entity<?, ?>> entityType) {
        BE result = backend.querySingle(query);
        if (result == null) {
            throw new EntityNotFoundException(entityType, Query.filters(query));
        }
        return result;
    }

    public static <BE> EntityAndPendingNotifications<Relationship> createAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, String relationship, BE target) {
        return Util.runInTransaction(context, false, t -> {
            Object source = Util.getSingle(context.backend, sourceQuery, sourceType);
            if (context.backend.hasRelationship(source, target, relationship)) {
                throw new RelationAlreadyExistsException(relationship, Query.filters(sourceQuery));
            }
            RelationshipRules.checkCreate(context.backend, source, Relationships.Direction.outgoing, relationship, target);
            Object relationshipObject = context.backend.relate(source, target, relationship, null);
            context.backend.commit(t);
            Relationship ret = context.backend.convert(relationshipObject, Relationship.class);
            return new EntityAndPendingNotifications<Relationship>(ret, new Notification<Relationship, Relationship>(ret, ret, Action.created()));
        });
    }

    public static <BE> EntityAndPendingNotifications<Relationship> createAssociationNoTransaction(TraversalContext<BE, ?> context, BE source, String relationship, BE target) {
        if (context.backend.hasRelationship(source, target, relationship)) {
            throw new RelationAlreadyExistsException(relationship, Query.filters(Query.to(context.backend.extractCanonicalPath(source))));
        }
        RelationshipRules.checkCreate(context.backend, source, Relationships.Direction.outgoing, relationship, target);
        Object relationshipObject = context.backend.relate(source, target, relationship, null);
        Relationship ret = context.backend.convert(relationshipObject, Relationship.class);
        return new EntityAndPendingNotifications<Relationship>(ret, new Notification<Relationship, Relationship>(ret, ret, Action.created()));
    }

    public static <BE> EntityAndPendingNotifications<Relationship> deleteAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, String relationship, BE target) {
        InventoryBackend backend = context.backend;
        return Util.runInTransaction(context, false, t -> {
            Object relationshipObject;
            Object source = Util.getSingle(backend, sourceQuery, sourceType);
            try {
                relationshipObject = backend.getRelationship(source, target, relationship);
            }
            catch (ElementNotFoundException e) {
                throw new RelationNotFoundException((Class<? extends Entity>)sourceType, relationship, Query.filters(sourceQuery), null, null);
            }
            RelationshipRules.checkDelete(backend, source, Relationships.Direction.outgoing, relationship, target);
            Relationship ret = backend.convert(relationshipObject, Relationship.class);
            backend.delete(relationshipObject);
            backend.commit(t);
            return new EntityAndPendingNotifications<Relationship>(ret, new Notification<Relationship, Relationship>(ret, ret, Action.deleted()));
        });
    }

    public static <BE> Relationship getAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, Query targetQuery, Class<? extends Entity<?, ?>> targetType, String rel) {
        InventoryBackend backend = context.backend;
        return Util.runInTransaction(context, true, t -> {
            Object relationship;
            Object source = Util.getSingle(backend, sourceQuery, sourceType);
            Object target = Util.getSingle(backend, targetQuery, targetType);
            try {
                relationship = backend.getRelationship(source, target, rel);
            }
            catch (ElementNotFoundException e) {
                throw new RelationNotFoundException((Class<? extends Entity>)sourceType, rel, Query.filters(sourceQuery), null, null);
            }
            return backend.convert(relationship, Relationship.class);
        });
    }

    public static Query queryTo(TraversalContext<?, ?> context, Path path) {
        if (path instanceof CanonicalPath) {
            return Query.to((CanonicalPath)path);
        }
        Query.SymmetricExtender extender = context.sourcePath.extend().path();
        extender.with(With.relativePath(null, (RelativePath)path));
        return extender.get();
    }

    public static <BE> BE find(TraversalContext<BE, ?> context, Path path) throws EntityNotFoundException {
        Object element;
        if (path.isCanonical()) {
            try {
                element = context.backend.find(path.toCanonicalPath());
            }
            catch (ElementNotFoundException e) {
                throw new EntityNotFoundException("Entity not found on path: " + path);
            }
        } else {
            Query query = Util.queryTo(context, path);
            element = Util.getSingle(context.backend, query, null);
        }
        return element;
    }

    public static Query extendTo(TraversalContext<?, ?> context, Path path) {
        if (path instanceof CanonicalPath) {
            return context.select().with(With.path((CanonicalPath)path)).get();
        }
        Marker marker = Marker.next();
        return context.sourcePath.extend().path().with(marker).with(context.selectCandidates).with(With.relativePath(marker.getLabel(), (RelativePath)path)).get();
    }

    public static <BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update> void update(TraversalContext<BE, E> context, Query entityQuery, U update, TransactionParticipant<BE, U> preUpdateCheck, BiConsumer<BE, InventoryBackend.Transaction> postUpdateCheck) {
        Object updated = Util.runInTransaction(context, false, t -> {
            Object entity = context.backend.querySingle(entityQuery);
            if (entity == null) {
                if (update instanceof Relationship.Update) {
                    throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
                }
                throw new EntityNotFoundException(context.entityClass, Query.filters(entityQuery));
            }
            if (preUpdateCheck != null) {
                preUpdateCheck.execute(entity, update, t);
            }
            context.backend.update(entity, update);
            if (postUpdateCheck != null) {
                postUpdateCheck.accept(entity, t);
            }
            context.backend.commit(t);
            return entity;
        });
        AbstractElement entity = (AbstractElement)context.backend.convert(updated, context.entityClass);
        context.notify(entity, new Action.Update<AbstractElement, U>(entity, update), Action.updated());
    }

    public static <BE, E extends AbstractElement<?, ?>> void delete(TraversalContext<BE, E> context, Query entityQuery, BiConsumer<BE, InventoryBackend.Transaction> cleanupFunction, BiConsumer<BE, InventoryBackend.Transaction> postDelete) {
        Util.runInTransaction(context, false, transaction -> {
            Object entity = context.backend.querySingle(entityQuery);
            if (entity == null) {
                if (context.entityClass.equals(Relationship.class)) {
                    throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
                }
                throw new EntityNotFoundException(context.entityClass, Query.filters(entityQuery));
            }
            if (cleanupFunction != null) {
                cleanupFunction.accept(entity, transaction);
            }
            HashSet verticesToDeleteThatDefineSomething = new HashSet();
            HashSet dataToBeDeleted = new HashSet();
            HashSet deleted = new HashSet();
            HashSet deletedRels = new HashSet();
            Consumer<Object> categorizer = e -> {
                if (context.backend.hasRelationship(e, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    verticesToDeleteThatDefineSomething.add(e);
                } else {
                    deleted.add(e);
                }
                deletedRels.addAll(context.backend.getRelationships(e, Relationships.Direction.both, new String[0]));
                context.backend.getRelationships(e, Relationships.Direction.outgoing, Relationships.WellKnown.hasData.name()).forEach(rel -> dataToBeDeleted.add(context.backend.getRelationshipTarget(rel)));
            };
            categorizer.accept(entity);
            context.backend.getTransitiveClosureOver(entity, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name()).forEachRemaining(categorizer::accept);
            Set deletedEntities = deleted.stream().filter(o -> Util.isRepresentableInAPI(context, o)).map(o -> context.backend.convert(o, context.backend.extractType(o))).collect(Collectors.toSet());
            Set deletedRelationships = deletedRels.stream().filter(o -> Util.isRepresentableInAPI(context, o)).map(o -> context.backend.convert(o, Relationship.class)).collect(Collectors.toSet());
            for (Object e2 : deleted) {
                context.backend.delete(e2);
            }
            for (Object e2 : verticesToDeleteThatDefineSomething) {
                if (context.backend.hasRelationship(e2, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    String rootId = context.backend.extractId(entity);
                    String definingId = context.backend.extractId(e2);
                    String rootType = context.entityClass.getSimpleName();
                    String definingType = context.backend.extractType(e2).getSimpleName();
                    String rootEntity = "Entity[id=" + rootId + ", type=" + rootType + "]";
                    String definingEntity = "Entity[id=" + definingId + ", type=" + definingType + "]";
                    throw new IllegalArgumentException("Could not delete entity " + rootEntity + ". The entity " + definingEntity + ", which it (indirectly) contains, acts as a definition for some " + "entities that are not deleted along with it, which would leave them without a " + "definition. This is illegal.");
                }
                context.backend.delete(e2);
            }
            dataToBeDeleted.forEach(context.backend::deleteStructuredData);
            if (postDelete != null) {
                postDelete.accept(entity, transaction);
            }
            context.backend.commit(transaction);
            for (Relationship r : deletedRelationships) {
                context.notify(r, Action.deleted());
            }
            for (Object e2 : deletedEntities) {
                context.notify(e2, Action.deleted());
            }
            return null;
        });
    }

    public static CanonicalPath canonicalize(String path, CanonicalPath canonicalPrefix, CanonicalPath relativeOrigin, Class<?> intendedFinalType) {
        Path p = Path.fromPartiallyUntypedString(path, canonicalPrefix, relativeOrigin, intendedFinalType);
        if (p instanceof RelativePath) {
            return ((RelativePath)p).applyTo(relativeOrigin);
        }
        return p.toCanonicalPath();
    }

    public static <BE> boolean isRepresentableInAPI(TraversalContext<BE, ?> context, BE entity) {
        if (context.backend.isBackendInternal(entity)) {
            return false;
        }
        return !Relationship.class.equals(context.backend.extractType(entity)) || !Relationships.WellKnown.hasData.name().equals(context.backend.extractRelationshipName(entity));
    }

    public static interface TransactionParticipant<BE, E> {
        public void execute(BE var1, E var2, InventoryBackend.Transaction var3);
    }
}

