/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;

public final class IdentityHash {
    private IdentityHash() {
    }

    public static String of(MetadataPack.Members metadata) {
        StringBuilder bld = new StringBuilder();
        for (MetricType.Blueprint mt : metadata.getMetricTypes()) {
            IdentityHash.appendStringRepresentation(mt, metadata, bld);
        }
        for (ResourceType.Blueprint rt : metadata.getResourceTypes()) {
            IdentityHash.appendStringRepresentation(rt, metadata, bld);
        }
        return IdentityHash.computeDigest(bld);
    }

    public static String of(Entity<?, ?> entity, Inventory inventory) {
        StringBuilder bld = new StringBuilder();
        IdentityHash.appendStringRepresentation(entity, inventory, bld);
        if (bld.length() == 0) {
            return null;
        }
        return IdentityHash.computeDigest(bld);
    }

    public static String of(Iterable<? extends Entity<?, ?>> entities, Inventory inventory) {
        return IdentityHash.of(entities.iterator(), inventory);
    }

    public static String of(Iterator<? extends Entity<?, ?>> entities, Inventory inventory) {
        TreeSet sortedEntities = new TreeSet((a, b) -> {
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            if (!a.getClass().equals(b.getClass())) {
                return a.getClass().getName().compareTo(b.getClass().getName());
            }
            return a.getId().compareTo(b.getId());
        });
        entities.forEachRemaining(sortedEntities::add);
        StringBuilder bld = new StringBuilder();
        sortedEntities.forEach(e -> IdentityHash.appendStringRepresentation(e, inventory, bld));
        return IdentityHash.computeDigest(bld);
    }

    private static void appendStringRepresentation(Entity<?, ?> entity, final Inventory inventory, final StringBuilder bld) {
        entity.accept(new ElementVisitor.Simple<Void, Void>(null){

            @Override
            public Void visitData(DataEntity data, Void parameter) {
                try {
                    data.getValue().writeJSON(bld);
                }
                catch (IOException e) {
                    throw new AssertionError("Exception while writing to StringBuilder. This should never happen.", e);
                }
                return null;
            }

            @Override
            public Void visitMetricType(MetricType mt, Void parameter) {
                bld.append(mt.getId()).append(mt.getType().name()).append(mt.getUnit().name());
                return null;
            }

            @Override
            public Void visitOperationType(OperationType ot, Void parameter) {
                DataEntity ret = this.fetchOrDefault((Data.Single)((Data.ReadWrite)inventory.inspect(ot).data()).get(OperationTypes.DataRole.returnType));
                DataEntity params = this.fetchOrDefault((Data.Single)((Data.ReadWrite)inventory.inspect(ot).data()).get(OperationTypes.DataRole.parameterTypes));
                bld.append(ot.getId());
                ret.accept(this, null);
                params.accept(this, null);
                return null;
            }

            @Override
            public Void visitResourceType(ResourceType rt, Void parameter) {
                Set ots = ((OperationTypes.Multiple)((OperationTypes.ReadWrite)inventory.inspect(rt).operationTypes()).getAll(new Filter[0])).entities();
                DataEntity config = this.fetchOrDefault((Data.Single)((Data.ReadWrite)inventory.inspect(rt).data()).get(ResourceTypes.DataRole.configurationSchema));
                DataEntity conn = this.fetchOrDefault((Data.Single)((Data.ReadWrite)inventory.inspect(rt).data()).get(ResourceTypes.DataRole.connectionConfigurationSchema));
                bld.append(rt.getId());
                config.accept(this, null);
                conn.accept(this, null);
                ots.stream().sorted((a, b) -> a.getId().compareTo(b.getId())).forEach(ot -> ot.accept(this, null));
                return null;
            }

            private DataEntity fetchOrDefault(Data.Single accessor) {
                try {
                    return accessor.entity();
                }
                catch (EntityNotFoundException e) {
                    return new DataEntity((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("dummy")).resourceType("dummy")).get(), ResourceTypes.DataRole.configurationSchema, StructuredData.get().undefined());
                }
            }
        }, null);
    }

    private static void appendStringRepresentation(Entity.Blueprint entity, final MetadataPack.Members members, final StringBuilder bld) {
        entity.accept(new ElementBlueprintVisitor.Simple<Void, Void>(){

            @Override
            public Void visitData(DataEntity.Blueprint<?> data, Void parameter) {
                try {
                    data.getValue().writeJSON(bld);
                }
                catch (IOException e) {
                    throw new AssertionError("Exception while writing to a StringBuilder. This should never happen.", e);
                }
                return null;
            }

            @Override
            public Void visitMetricType(MetricType.Blueprint mt, Void parameter) {
                bld.append(mt.getId()).append(mt.getType().name()).append(mt.getUnit().name());
                return null;
            }

            @Override
            public Void visitOperationType(OperationType.Blueprint operationType, Void parameter) {
                DataEntity.Blueprint<?> returnType = members.getReturnType(operationType);
                DataEntity.Blueprint<?> parameterTypes = members.getParameterTypes(operationType);
                bld.append(operationType.getId());
                returnType.accept(this, null);
                parameterTypes.accept(this, null);
                return null;
            }

            @Override
            public Void visitResourceType(ResourceType.Blueprint type, Void parameter) {
                DataEntity.Blueprint<?> configSchema = members.getConfigurationSchema(type);
                DataEntity.Blueprint<?> connSchema = members.getConnectionConfigurationSchema(type);
                List<OperationType.Blueprint> ots = members.getOperationTypes(type);
                bld.append(type.getId());
                configSchema.accept(this, null);
                connSchema.accept(this, null);
                ots.forEach(ot -> ot.accept(this, null));
                return null;
            }
        }, null);
    }

    private static String computeDigest(StringBuilder bld) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-1").digest(bld.toString().getBytes(Charset.forName("UTF-8")));
            bld.delete(0, bld.length());
            for (byte b : digest) {
                bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
            }
            return bld.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not produce and SHA-1 hash.", e);
        }
    }
}

