/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.io.IOException;
import java.util.Iterator;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;

public class SizeAwarePage<T>
extends Page<T> {
    private HasTotalSize hasTotalSize;
    private long totalSize = -1L;

    public SizeAwarePage(Iterator<T> wrapped, PageContext pageContext, HasTotalSize hasTotalSize) {
        super(wrapped, pageContext, -1L);
        if (hasTotalSize == null) {
            throw new IllegalArgumentException("hasTotalSize can't be null");
        }
        this.hasTotalSize = hasTotalSize;
    }

    @Override
    public long getTotalSize() {
        if (this.totalSize == -1L && !this.hasNext()) {
            this.totalSize = this.hasTotalSize == null ? -1L : this.hasTotalSize.getTotalSize();
        }
        return this.totalSize;
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public T next() {
        return super.next();
    }

    @Override
    public void close() throws IOException {
        this.getTotalSize();
        this.hasTotalSize = null;
        super.close();
    }

    @FunctionalInterface
    public static interface HasTotalSize {
        public static final int NOT_DEPLETED = -1;

        public long getTotalSize();
    }
}

