/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.base.FilterFragment;
import org.hawkular.inventory.base.PathFragment;
import org.hawkular.inventory.base.QueryFragment;
import org.hawkular.inventory.base.QueryOptimizer;
import org.hawkular.inventory.base.spi.NoopFilter;

public final class Query {
    private QueryFragment[] fragments;
    private List<Query> subTrees = new ArrayList<Query>();

    private static Filter[] filters(QueryFragment ... fragments) {
        Filter[] ret = new Filter[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            ret[i] = fragments[i].getFilter();
        }
        return ret;
    }

    public static Filter[][] filters(Query query) {
        ArrayList<List<Filter>> paths = new ArrayList<List<Filter>>();
        ArrayList<Filter[]> workingPath = new ArrayList<Filter[]>();
        Query.addPathsToLeaves(query, workingPath, paths);
        Filter[][] ret = new Filter[paths.size()][];
        Arrays.setAll(ret, i -> ((List)paths.get(i)).toArray(new Filter[((List)paths.get(i)).size()]));
        return ret;
    }

    private static void addPathsToLeaves(Query tree, List<Filter[]> workingPath, List<List<Filter>> results) {
        if (tree.getSubTrees().isEmpty()) {
            ArrayList pathToLeaf = new ArrayList();
            Consumer<Filter> addOps = f -> {
                if (!(f instanceof NoopFilter)) {
                    pathToLeaf.add(f);
                }
            };
            for (Filter[] fs : workingPath) {
                Arrays.asList(fs).forEach(addOps);
            }
            Arrays.asList(Query.filters(tree.getFragments())).forEach(addOps);
            results.add(pathToLeaf);
        } else {
            workingPath.add(Query.filters(tree.getFragments()));
            for (Query subTree : tree.getSubTrees()) {
                Query.addPathsToLeaves(subTree, workingPath, results);
            }
            workingPath.remove(workingPath.size() - 1);
        }
    }

    public static Query to(CanonicalPath entity) {
        return Query.path().with(With.path(entity)).get();
    }

    public static Query empty() {
        return new Builder().build();
    }

    public static SymmetricExtender filter() {
        return Query.empty().extend().filter();
    }

    public static SymmetricExtender path() {
        return Query.empty().extend().path();
    }

    private Query() {
    }

    public QueryFragment[] getFragments() {
        return this.fragments;
    }

    public List<Query> getSubTrees() {
        return this.subTrees;
    }

    public Builder asBuilder() {
        Builder b = new Builder();
        b.fragments = new ArrayList<QueryFragment>(Arrays.asList(this.fragments));
        for (Query subTree : this.subTrees) {
            Builder childBuilder = subTree.asBuilder();
            childBuilder.parent = b;
            b.children.add(childBuilder);
        }
        return b;
    }

    public SymmetricExtender extend() {
        return new SymmetricExtender(this.asBuilder());
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.addToString(bld, 0);
        return bld.toString();
    }

    private void addToString(StringBuilder bld, int indentation) {
        this.indent(bld, indentation);
        bld.append("Query[fragments=").append(Arrays.toString(this.fragments));
        if (!this.subTrees.isEmpty()) {
            bld.append("\n");
            this.subTrees.forEach(s -> {
                s.addToString(bld, indentation + 1);
                bld.append("\n");
            });
            this.indent(bld, indentation);
        }
        bld.append("]");
    }

    private void indent(StringBuilder bld, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            bld.append("  ");
        }
    }

    static /* synthetic */ QueryFragment[] access$502(Query x0, QueryFragment[] x1) {
        x0.fragments = x1;
        return x1;
    }

    public static final class SymmetricExtender {
        private Builder filters;
        private Function<Filter[], QueryFragment[]> queryFragmentSupplier;
        private Function<Filter, QueryFragment> converter;
        private Boolean isFilter;

        private SymmetricExtender(Builder filters) {
            this.filters = filters;
            this.onLeaves(filters, b -> {
                QueryFragment last;
                QueryFragment queryFragment = last = ((Builder)b).fragments.isEmpty() ? null : (QueryFragment)((Builder)b).fragments.get(((Builder)b).fragments.size() - 1);
                if (last != null) {
                    this.isFilter = last instanceof FilterFragment;
                    this.queryFragmentSupplier = this.isFilter != false ? FilterFragment::from : PathFragment::from;
                    this.converter = this.isFilter != false ? FilterFragment::new : PathFragment::new;
                }
            });
        }

        public Builder rawQueryBuilder() {
            return this.filters;
        }

        public SymmetricExtender path() {
            this.queryFragmentSupplier = PathFragment::from;
            this.converter = PathFragment::new;
            if (this.isFilter != null && this.isFilter.booleanValue() && !this.filters.fragments.isEmpty()) {
                this.with(NoopFilter.INSTANCE);
            }
            this.isFilter = false;
            return this;
        }

        public SymmetricExtender filter() {
            this.queryFragmentSupplier = FilterFragment::from;
            this.converter = FilterFragment::new;
            if (this.isFilter != null && !this.isFilter.booleanValue() && this.filters.fragments.isEmpty()) {
                this.with(NoopFilter.INSTANCE);
            }
            this.isFilter = true;
            return this;
        }

        public SymmetricExtender with(Query other) {
            this.onLeaves(this.filters, builder -> builder.with(other, this.converter));
            return this;
        }

        public SymmetricExtender withExact(Query other) {
            this.onLeaves(this.filters, builder -> builder.with(other));
            return this;
        }

        public SymmetricExtender with(Filter[][] filters) {
            this.onLeaves(this.filters, builder -> {
                for (Filter[] fs : filters) {
                    builder.branch().with(this.queryFragmentSupplier.apply(fs));
                }
            });
            return this;
        }

        public SymmetricExtender with(Filter ... filters) {
            this.onLeaves(this.filters, t -> t.with(this.queryFragmentSupplier.apply(filters)));
            return this;
        }

        public Query get() {
            return this.filters.build();
        }

        private void onLeaves(Builder root, Consumer<Builder> leafMutator) {
            if (root.children.isEmpty()) {
                leafMutator.accept(root);
            } else {
                for (Builder c : root.children) {
                    this.onLeaves(c, leafMutator);
                }
            }
        }
    }

    public static final class Builder {
        private List<QueryFragment> fragments = new ArrayList<QueryFragment>();
        private Query tree = new Query();
        private Builder parent;
        private List<Builder> children = new ArrayList<Builder>();
        private boolean done;

        public SymmetricExtender symmetricExtender() {
            return new SymmetricExtender(this);
        }

        public Builder branch() {
            Builder child = new Builder();
            child.parent = this;
            this.children.add(child);
            return child;
        }

        public Builder done() {
            if (this.done) {
                return this.parent;
            }
            Query.access$502(this.tree, this.fragments.toArray(new QueryFragment[this.fragments.size()]));
            if (this.parent != null) {
                this.parent.tree.subTrees.add(this.tree);
                this.parent.children.remove(this);
            }
            new ArrayList<Builder>(this.children).forEach(Builder::done);
            this.done = true;
            return this.parent;
        }

        public Builder with(QueryFragment ... filters) {
            QueryOptimizer.appendOptimized(this.fragments, filters);
            return this;
        }

        public Builder with(Function<Filter, QueryFragment> converter, QueryFragment ... filters) {
            QueryFragment[] converted = (QueryFragment[])Arrays.asList(filters).stream().map(QueryFragment::getFilter).map(converter).toArray(QueryFragment[]::new);
            QueryOptimizer.appendOptimized(this.fragments, converted);
            return this;
        }

        public Builder with(Query other) {
            this.with(other.fragments);
            for (Query sub : other.getSubTrees()) {
                this.branch().with(sub).done();
            }
            return this;
        }

        public Builder with(Query other, Function<Filter, QueryFragment> converter) {
            this.with(converter, other.fragments);
            for (Query sub : other.getSubTrees()) {
                this.branch().with(sub, converter).done();
            }
            return this;
        }

        public Query build() {
            Builder root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.done();
            return root.tree;
        }
    }
}

