/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import rx.Observable;

public interface Inventory
extends AutoCloseable {
    public void initialize(Configuration var1);

    public TransactionFrame newTransactionFrame();

    public Tenants.ReadWrite tenants();

    public Relationships.Read relationships();

    default public Tenants.Single inspect(Tenant tenant) throws EntityNotFoundException {
        return (Tenants.Single)this.tenants().get(tenant.getId());
    }

    default public Environments.Single inspect(Environment environment) throws EntityNotFoundException {
        return this.inspect(environment.getPath(), Environments.Single.class);
    }

    default public Feeds.Single inspect(Feed feed) throws EntityNotFoundException {
        return this.inspect(feed.getPath(), Feeds.Single.class);
    }

    default public Metrics.Single inspect(Metric metric) throws EntityNotFoundException {
        return this.inspect(metric.getPath(), Metrics.Single.class);
    }

    default public MetricTypes.Single inspect(MetricType metricType) throws EntityNotFoundException {
        return this.inspect(metricType.getPath(), MetricTypes.Single.class);
    }

    default public Resources.Single inspect(Resource resource) throws EntityNotFoundException {
        return this.inspect(resource.getPath(), Resources.Single.class);
    }

    default public ResourceTypes.Single inspect(ResourceType resourceType) throws EntityNotFoundException {
        return this.inspect(resourceType.getPath(), ResourceTypes.Single.class);
    }

    default public Data.Single inspect(DataEntity data) throws EntityNotFoundException {
        return this.inspect(data.getPath(), Data.Single.class);
    }

    default public OperationTypes.Single inspect(OperationType operationType) throws EntityNotFoundException {
        return this.inspect(operationType.getPath(), OperationTypes.Single.class);
    }

    default public MetadataPacks.Single inspect(MetadataPack metadataPack) throws EntityNotFoundException {
        return this.inspect(metadataPack.getPath(), MetadataPacks.Single.class);
    }

    default public Relationships.Single inspect(Relationship relationship) {
        return (Relationships.Single)this.relationships().get(relationship.getId());
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(E entity, final Class<Single> accessInterface) {
        return (Single)((ResolvableToSingle)entity.accept(new ElementVisitor<Single, Void>(){

            @Override
            public Single visitTenant(Tenant tenant, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(tenant));
            }

            @Override
            public Single visitEnvironment(Environment environment, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(environment));
            }

            @Override
            public Single visitFeed(Feed feed, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(feed));
            }

            @Override
            public Single visitMetric(Metric metric, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metric));
            }

            @Override
            public Single visitMetricType(MetricType definition, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(definition));
            }

            @Override
            public Single visitResource(Resource resource, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(resource));
            }

            @Override
            public Single visitResourceType(ResourceType type, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(type));
            }

            @Override
            public Single visitData(DataEntity data, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(data));
            }

            @Override
            public Single visitOperationType(OperationType operationType, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(operationType));
            }

            @Override
            public Single visitRelationship(Relationship relationship, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(relationship.getId()));
            }

            @Override
            public Single visitMetadataPack(MetadataPack metadataPack, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metadataPack));
            }

            @Override
            public Single visitUnknown(Object entity, Void parameter) {
                return null;
            }
        }, null));
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(final CanonicalPath path, final Class<Single> accessInterface) {
        final CanonicalPath.IdExtractor ids = path.ids();
        return (Single)((ResolvableToSingle)path.accept(new ElementTypeVisitor<Single, Void>(){

            @Override
            public Single visitTenant(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.tenants().get(ids.getTenantId()));
            }

            @Override
            public Single visitEnvironment(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(ids.getTenantId())).environments()).get(ids.getEnvironmentId()));
            }

            @Override
            public Single visitFeed(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Feeds.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(ids.getTenantId())).feeds()).get(ids.getFeedId()));
            }

            @Override
            public Single visitMetric(Void parameter) {
                Tenants.Single tenant = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                RelativePath resourcePath = ids.getResourcePath();
                String feedId = ids.getFeedId();
                String environmentId = ids.getEnvironmentId();
                String metricId = ids.getMetricId();
                ResolvableToSingle iface = resourcePath == null ? (feedId == null ? (ResolvableToSingle)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(environmentId)).metrics()).get(metricId) : (ResolvableToSingle)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(feedId)).metrics()).get(metricId)) : (feedId == null ? (ResolvableToSingle)((Metrics.ReadWrite)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(environmentId)).resources()).descendContained(ids.getResourcePath()).metrics()).get(metricId) : (ResolvableToSingle)((Metrics.ReadWrite)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(feedId)).resources()).descendContained(ids.getResourcePath()).metrics()).get(metricId));
                return (ResolvableToSingle)accessInterface.cast(iface);
            }

            @Override
            public Single visitMetricType(Void parameter) {
                Tenants.Single ten = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                return (ResolvableToSingle)accessInterface.cast(ids.getFeedId() == null ? ((MetricTypes.ReadWrite)ten.metricTypes()).get(ids.getMetricTypeId()) : ((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)ten.feeds()).get(ids.getFeedId())).metricTypes()).get(ids.getMetricTypeId()));
            }

            @Override
            public Single visitResource(Void parameter) {
                Tenants.Single tenant = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                Resources.Single access = ids.getFeedId() == null ? ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(ids.getEnvironmentId())).resources()).descendContained(ids.getResourcePath()) : ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(ids.getFeedId())).resources()).descendContained(ids.getResourcePath());
                return (ResolvableToSingle)accessInterface.cast(access);
            }

            @Override
            public Single visitResourceType(Void parameter) {
                Tenants.Single ten = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                return (ResolvableToSingle)accessInterface.cast(ids.getFeedId() == null ? ((ResourceTypes.ReadWrite)ten.resourceTypes()).get(ids.getResourceTypeId()) : ((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)ten.feeds()).get(ids.getFeedId())).resourceTypes()).get(ids.getResourceTypeId()));
            }

            @Override
            public Single visitRelationship(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(ids.getRelationshipId()));
            }

            @Override
            public Single visitData(Void parameter) {
                String rt = ids.getResourceTypeId();
                String ot = ids.getOperationTypeId();
                if (rt != null) {
                    ResourceTypes.Single rts = Inventory.this.inspect(path.up(), ResourceTypes.Single.class);
                    return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)rts.data()).get(ids.getDataRole()));
                }
                if (ot != null) {
                    OperationTypes.Single ots = Inventory.this.inspect(path.up(), OperationTypes.Single.class);
                    return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)ots.data()).get(ids.getDataRole()));
                }
                Resources.Single res = Inventory.this.inspect(path.up(), Resources.Single.class);
                return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)res.data()).get(ids.getDataRole()));
            }

            @Override
            public Single visitOperationType(Void parameter) {
                ResourceTypes.Single rt = Inventory.this.inspect(path.up(), ResourceTypes.Single.class);
                return (ResolvableToSingle)accessInterface.cast(((OperationTypes.ReadWrite)rt.operationTypes()).get(path.getSegment().getElementId()));
            }

            @Override
            public Single visitMetadataPack(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((MetadataPacks.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.up().getSegment().getElementId())).metadataPacks()).get(path.getSegment().getElementId()));
            }

            @Override
            public Single visitUnknown(Void parameter) {
                return null;
            }

            private CanonicalPath[] allResourceSegments(CanonicalPath path2, int leaveOutTop, int leaveOutBottom) {
                ArrayList<CanonicalPath> ret = new ArrayList<CanonicalPath>();
                Iterator<CanonicalPath> it = path2.descendingIterator();
                int leftOutTop = 0;
                while (it.hasNext()) {
                    CanonicalPath p = it.next();
                    if (!Resource.class.equals(p.getSegment().getElementType()) || leftOutTop++ < leaveOutTop) continue;
                    ret.add(p);
                }
                if (ret.size() - leaveOutBottom > 0) {
                    int len = ret.size() - leaveOutBottom;
                    return ret.subList(0, len).toArray(new CanonicalPath[len]);
                }
                return new CanonicalPath[0];
            }
        }, null));
    }

    public boolean hasObservers(Interest<?, ?> var1);

    public <C, E> Observable<C> observable(Interest<C, E> var1);

    public InputStream getGraphSON(String var1);

    public <T extends AbstractElement> T getElement(CanonicalPath var1);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath var1, Relationships.Direction var2, Class<T> var3, String ... var4);

    public Configuration getConfiguration();

    default public <T extends AbstractElement> Page<T> execute(Query query, Class<T> requestedEntity, Pager pager) {
        return null;
    }
}

