/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.AssociationInterface;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Parents;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.ReadWriteInterface;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToManyWithRelationships;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;

public final class Resources {
    private Resources() {
    }

    public static interface ReadAssociate
    extends Read,
    AssociationInterface {
        @Override
        public Relationship disassociate(Path var1) throws EntityNotFoundException, IllegalArgumentException;
    }

    public static interface ReadWrite
    extends ReadWriteInterface<Resource.Update, Resource.Blueprint, Single, Multiple, String>,
    ReadContained {
    }

    public static interface Read
    extends ReadBase<Path> {
    }

    public static interface ReadContained
    extends ReadBase<String> {
        default public Single descendContained(RelativePath resourcePath) {
            ReadContained parent = this;
            Single access = null;
            for (Path.Segment s : resourcePath.getPath()) {
                access = (Single)parent.get(s.getElementId());
                parent = (ReadContained)access.resources();
            }
            if (access == null) {
                throw new IllegalArgumentException("Empty resource path");
            }
            return access;
        }
    }

    public static interface ReadBase<Address>
    extends ReadInterface<Single, Multiple, Address> {
        default public Single descend(Address firstChild, Path ... furtherChildren) {
            if (firstChild == null) {
                throw new IllegalArgumentException("no first child");
            }
            Single access = (Single)this.get(firstChild);
            Read last = (Read)access.allResources();
            for (Path p : furtherChildren) {
                if (!Resource.class.equals(p.getSegment().getElementType())) {
                    throw new IllegalArgumentException("Descend can only traverse child resources.");
                }
                access = (Single)last.get(p);
                last = (Read)access.allResources();
            }
            return access;
        }
    }

    public static interface Multiple
    extends ResolvableToManyWithRelationships<Resource>,
    BrowserBase<Metrics.Read, Metrics.Read, Data.Read<DataRole>, ReadContained, Read> {
    }

    public static interface Single
    extends ResolvableToSingleWithRelationships<Resource, Resource.Update>,
    BrowserBase<Metrics.ReadWrite, Metrics.ReadAssociate, Data.ReadWrite<DataRole>, ReadWrite, ReadAssociate> {
        public Single parent();
    }

    private static interface BrowserBase<ContainedMetrics, AllMetrics, Data, ContainedAccess, AllAccess> {
        public ContainedMetrics metrics();

        public AllMetrics allMetrics();

        public ContainedAccess resources();

        public AllAccess allResources();

        public Read recursiveResources();

        public Read parents();

        public Data data();
    }

    public static enum MetricParents implements Parents
    {
        CONTAINING_RESOURCE,
        INCORPORATING_RESOURCE;

    }

    public static enum ResourceParents implements Parents
    {
        CONTAINING_RESOURCE,
        PARENT_RESOURCE;

    }

    public static enum DataRole implements DataEntity.Role
    {
        configuration{

            @Override
            public boolean isSchema() {
                return false;
            }

            @Override
            public Filter[] navigateToSchema() {
                return new Filter[]{Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.defines), Related.by(Relationships.WellKnown.contains), With.type(DataEntity.class), With.id(ResourceTypes.DataRole.configurationSchema.name())};
            }
        }
        ,
        connectionConfiguration{

            @Override
            public boolean isSchema() {
                return false;
            }

            @Override
            public Filter[] navigateToSchema() {
                return new Filter[]{Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.defines), Related.by(Relationships.WellKnown.contains), With.type(DataEntity.class), With.id(ResourceTypes.DataRole.connectionConfigurationSchema.name())};
            }
        };

    }
}

