/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;

public abstract class Entity<B extends org.hawkular.inventory.api.model.Blueprint, U extends Update>
extends AbstractElement<B, U> {
    private final String name;

    Entity() {
        this.name = null;
    }

    Entity(CanonicalPath path) {
        this(path, null);
    }

    Entity(CanonicalPath path, Map<String, Object> properties) {
        this(null, path, properties);
    }

    public Entity(String name, CanonicalPath path) {
        this(name, path, null);
    }

    Entity(String name, CanonicalPath path, Map<String, Object> properties) {
        super(path, properties);
        this.name = name;
        if (!this.getClass().equals(path.getSegment().getElementType())) {
            throw new IllegalArgumentException("Invalid path specified. Trying to create " + this.getClass().getSimpleName() + " but the path points to " + path.getSegment().getElementType().getSimpleName());
        }
    }

    public String getName() {
        return this.name;
    }

    protected void appendToString(StringBuilder toStringBuilder) {
    }

    public final String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[path='").append(this.getPath()).append('\'');
        this.appendToString(bld);
        bld.append(']');
        return bld.toString();
    }

    public static abstract class Update
    extends AbstractElement.Update {
        protected final String name;

        protected Update(String name, Map<String, Object> properties) {
            super(properties);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static abstract class Builder<U extends Update, This extends Builder<U, This>>
        extends AbstractElement.Update.Builder<U, This> {
            protected String name;

            public This withName(String name) {
                this.name = name;
                return (This)((Builder)this.castThis());
            }
        }
    }

    public static abstract class Blueprint
    extends AbstractElement.Blueprint {
        private final String id;
        private final String name;
        private final Map<String, Set<CanonicalPath>> outgoing;
        private final Map<String, Set<CanonicalPath>> incoming;

        protected Blueprint() {
            super(null);
            this.id = null;
            this.name = null;
            this.outgoing = null;
            this.incoming = null;
        }

        protected Blueprint(String id, Map<String, Object> properties) {
            this(id, properties, null, null);
        }

        protected Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            this(id, null, properties, outgoing, incoming);
        }

        protected Blueprint(String id, String name, Map<String, Object> properties) {
            this(id, name, properties, null, null);
        }

        protected Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(properties);
            if (id == null) {
                throw new IllegalArgumentException("id == null");
            }
            this.id = id;
            this.name = name;
            this.outgoing = outgoing == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(outgoing);
            this.incoming = incoming == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(incoming);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Set<CanonicalPath>> getOutgoingRelationships() {
            return this.outgoing == null ? Collections.emptyMap() : this.outgoing;
        }

        public Map<String, Set<CanonicalPath>> getIncomingRelationships() {
            return this.incoming == null ? Collections.emptyMap() : this.incoming;
        }

        private static Map<String, Set<CanonicalPath>> copyAsUnmodifiable(Map<String, Set<CanonicalPath>> map) {
            HashMap ret = new HashMap(map.size());
            map.forEach((k, v) -> ret.put(k, Collections.unmodifiableSet(v)));
            return Collections.unmodifiableMap(ret);
        }

        public static abstract class Builder<Blueprint, This extends Builder<Blueprint, This>>
        extends AbstractElement.Blueprint.Builder<Blueprint, This> {
            protected String id;
            protected String name;
            protected Map<String, Set<CanonicalPath>> outgoing;
            protected Map<String, Set<CanonicalPath>> incoming;

            public This withId(String id) {
                this.id = id;
                return (This)((Builder)this.castThis());
            }

            public This withName(String name) {
                this.name = name;
                return (This)((Builder)this.castThis());
            }

            public This withOutgoingRelationships(Map<String, Set<CanonicalPath>> outgoing) {
                this.outgoing = outgoing;
                return (This)((Builder)this.castThis());
            }

            public This withIncomingRelationships(Map<String, Set<CanonicalPath>> incoming) {
                this.incoming = incoming;
                return (This)((Builder)this.castThis());
            }

            public This addOutgoingRelationship(String label, CanonicalPath target) {
                this.outgoing = this.addRelationship(this.outgoing, label, target);
                return (This)((Builder)this.castThis());
            }

            public This addIncomingRelationship(String label, CanonicalPath source) {
                this.incoming = this.addRelationship(this.incoming, label, source);
                return (This)((Builder)this.castThis());
            }

            private Map<String, Set<CanonicalPath>> addRelationship(Map<String, Set<CanonicalPath>> map, String label, CanonicalPath path) {
                Set<CanonicalPath> paths;
                if (map == null) {
                    map = new HashMap<String, Set<CanonicalPath>>();
                }
                if ((paths = map.get(label)) == null) {
                    paths = new HashSet<CanonicalPath>();
                    map.put(label, paths);
                }
                paths.add(path);
                return map;
            }
        }
    }
}

