/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.Associator;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.base.spi.RecurseFilter;

public final class BaseFeeds {
    private BaseFeeds() {
    }

    private static <BE> BaseResources.Read<BE> proceedToResources(TraversalContext<BE, Feed> context, Feeds.ResourceParents ... parents) {
        return new BaseResources.Read(context.proceedWithParents(Resource.class, Feeds.ResourceParents.class, Feeds.ResourceParents.FEED, parents, (p, extender) -> {
            switch (p) {
                case FEED: {
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Resource.class));
                    break;
                }
                case RESOURCE: {
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Resource.class), RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).build());
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled type of resource parent under feed.");
                }
            }
        }));
    }

    private static <BE> BaseMetrics.Read<BE> proceedToMetrics(TraversalContext<BE, Feed> context, Feeds.MetricParents ... parents) {
        return new BaseMetrics.Read(context.proceedWithParents(Metric.class, Feeds.MetricParents.class, Feeds.MetricParents.FEED, parents, (p, extender) -> {
            switch (p) {
                case FEED: {
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Metric.class));
                    break;
                }
                case RESOURCE: {
                    extender.path().with(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Resource.class), RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).build()}});
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Metric.class));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled type of resource parent under feed.");
                }
            }
        }));
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Feed, Feed.Update>
    implements Feeds.Multiple {
        public Multiple(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Resources.ReadContained resources() {
            return new BaseResources.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Resources.Read resourcesUnder(Feeds.ResourceParents ... parents) {
            return BaseFeeds.proceedToResources(this.context, parents);
        }

        @Override
        public Metrics.ReadContained metrics() {
            return new BaseMetrics.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.Read metricsUnder(Feeds.MetricParents ... parents) {
            return BaseFeeds.proceedToMetrics(this.context, parents);
        }

        @Override
        public MetricTypes.ReadContained metricTypes() {
            return new BaseMetricTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public ResourceTypes.ReadContained resourceTypes() {
            return new BaseResourceTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Feed, Feed.Update>
    implements Feeds.Single {
        public Single(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Resources.ReadWrite resources() {
            return new BaseResources.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Resources.Read resourcesUnder(Feeds.ResourceParents ... parents) {
            return BaseFeeds.proceedToResources(this.context, parents);
        }

        @Override
        public Metrics.ReadWrite metrics() {
            return new BaseMetrics.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.Read metricsUnder(Feeds.MetricParents ... parents) {
            return BaseFeeds.proceedToMetrics(this.context, parents);
        }

        @Override
        public MetricTypes.ReadWrite metricTypes() {
            return new BaseMetricTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public ResourceTypes.ReadWrite resourceTypes() {
            return new BaseResourceTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }
    }

    public static class ReadAssociate<BE>
    extends Associator<BE, Feed>
    implements Feeds.ReadAssociate {
        public ReadAssociate(TraversalContext<BE, Feed> context) {
            super(context, Relationships.WellKnown.incorporates, Environment.class);
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(Path path) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(path));
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, Feed, Feed.Update>
    implements Feeds.Read {
        public Read(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, Feed, Feed.Update>
    implements Feeds.ReadContained {
        public ReadContained(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Feed, Feed.Blueprint, Feed.Update, String>
    implements Feeds.ReadWrite {
        public ReadWrite(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Feed.Blueprint blueprint) {
            Object tenant = this.context.backend.querySingle(this.context.sourcePath.extend().filter().with(With.type(Tenant.class)).get());
            if (tenant == null) {
                throw new EntityNotFoundException(Tenant.class, Query.filters(this.context.sourcePath));
            }
            CanonicalPath feedPath = this.context.backend.extractCanonicalPath(tenant).extend(Feed.class, blueprint.getId()).get();
            return this.context.configuration.getFeedIdStrategy().generate(this.context.inventory, new Feed(feedPath));
        }

        @Override
        protected EntityAndPendingNotifications<Feed> wireUpNewEntity(BE entity, Feed.Blueprint blueprint, CanonicalPath parentPath, BE parent, InventoryBackend.Transaction transaction) {
            return new EntityAndPendingNotifications<Feed>(new Feed(blueprint.getName(), parentPath.extend(Feed.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new Notification[0]);
        }

        @Override
        public Feeds.Single create(Feed.Blueprint blueprint) {
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint)));
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }
}

