/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.HashSet;
import java.util.Iterator;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.IdentityHash;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;

public final class BaseMetadataPacks {
    private BaseMetadataPacks() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, MetadataPack, MetadataPack.Update>
    implements MetadataPacks.Multiple {
        public Multiple(TraversalContext<BE, MetadataPack> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Read resourceTypes() {
            return new BaseResourceTypes.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, ResourceType.class).get());
        }

        @Override
        public MetricTypes.Read metricTypes() {
            return new BaseMetricTypes.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, MetadataPack, MetadataPack.Update>
    implements MetadataPacks.Single {
        public Single(TraversalContext<BE, MetadataPack> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Read resourceTypes() {
            return new BaseResourceTypes.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, ResourceType.class).get());
        }

        @Override
        public MetricTypes.Read metricTypes() {
            return new BaseMetricTypes.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }
    }

    public static class Read<BE>
    extends Traversal<BE, MetadataPack>
    implements MetadataPacks.Read {
        public Read(TraversalContext<BE, MetadataPack> context) {
            super(context);
        }

        @Override
        public MetadataPacks.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetadataPacks.Single get(Path path) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(path));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, MetadataPack>
    implements MetadataPacks.ReadContained {
        public ReadContained(TraversalContext<BE, MetadataPack> context) {
            super(context);
        }

        @Override
        public MetadataPacks.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetadataPacks.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, MetadataPack, MetadataPack.Blueprint, MetadataPack.Update, String>
    implements MetadataPacks.ReadWrite {
        public ReadWrite(TraversalContext<BE, MetadataPack> context) {
            super(context);
        }

        @Override
        protected String getProposedId(MetadataPack.Blueprint blueprint) {
            Iterator members = blueprint.getMembers().stream().map(p -> {
                Class<?> cls = p.getSegment().getElementType();
                try {
                    Object e = this.context.backend.find((CanonicalPath)p);
                    return (Entity)this.context.backend.convert(e, cls);
                }
                catch (ElementNotFoundException ex) {
                    throw new EntityNotFoundException(cls, Query.filters(Query.to(p)));
                }
            }).iterator();
            return IdentityHash.of(members, this.context.inventory);
        }

        @Override
        protected EntityAndPendingNotifications<MetadataPack> wireUpNewEntity(BE entity, MetadataPack.Blueprint blueprint, CanonicalPath parentPath, BE parent, InventoryBackend.Transaction transaction) {
            HashSet newRels = new HashSet();
            blueprint.getMembers().forEach(p -> {
                try {
                    Object member = this.context.backend.find((CanonicalPath)p);
                    Object rel = this.context.backend.relate(entity, member, Relationships.WellKnown.incorporates.name(), null);
                    Relationship r = this.context.backend.convert(rel, Relationship.class);
                    newRels.add(new Notification<Relationship, Relationship>(r, r, Action.created()));
                }
                catch (ElementNotFoundException e) {
                    throw new EntityNotFoundException(p.getSegment().getElementType(), Query.filters(Query.to(p)));
                }
            });
            MetadataPack entityObject = this.context.backend.convert(entity, MetadataPack.class);
            return new EntityAndPendingNotifications<MetadataPack>(entityObject, newRels);
        }

        @Override
        public MetadataPacks.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetadataPacks.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public MetadataPacks.Single create(MetadataPack.Blueprint blueprint) throws EntityAlreadyExistsException {
            blueprint.getMembers().forEach(p -> {
                if (p.ids().getFeedId() != null) {
                    throw new IllegalArgumentException("Only global types can be part of a metadata pack. No feed-local types are allowed but '" + p + "' encountered.");
                }
            });
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint)));
        }
    }
}

