/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.IdentityHash;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;

public final class BaseOperationTypes {
    private BaseOperationTypes() {
    }

    private static class OperationTypeDataModificationChecks<BE>
    implements BaseData.DataModificationChecks<BE> {
        private final TraversalContext<BE, ?> context;

        private OperationTypeDataModificationChecks(TraversalContext<BE, ?> context) {
            this.context = context;
        }

        @Override
        public void preCreate(DataEntity.Blueprint blueprint, InventoryBackend.Transaction transaction) {
            Object mp = this.context.backend.querySingle(this.context.select().path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                Object ot = this.context.backend.querySingle(this.context.select().get());
                throw new IllegalArgumentException("Data '" + blueprint.getId() + "' cannot be created" + " under operation type " + this.context.backend.extractCanonicalPath(ot) + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void preUpdate(BE dataEntity, DataEntity.Update update, InventoryBackend.Transaction transaction) {
            if (update.getValue() == null) {
                return;
            }
            Object mp = this.context.backend.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                CanonicalPath dataPath = this.context.backend.extractCanonicalPath(dataEntity);
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be updated" + " under operation type " + dataPath.up() + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postUpdate(BE dataEntity, InventoryBackend.Transaction transaction) {
            Object rt = this.context.backend.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.contains)).get());
            this.context.backend.updateIdentityHash(rt, IdentityHash.of(this.context.backend.convert(rt, ResourceType.class), this.context.inventory.keepTransaction(transaction)));
        }

        @Override
        public void preDelete(BE dataEntity, InventoryBackend.Transaction transaction) {
            CanonicalPath dataPath = this.context.backend.extractCanonicalPath(dataEntity);
            Object rt = null;
            try {
                rt = this.context.backend.find(dataPath.up(2));
            }
            catch (ElementNotFoundException e) {
                Fetcher.throwNotFoundException(this.context);
            }
            if (!ReadWrite.isResourceTypeInMetadataPack(this.context, rt)) {
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be deleted" + " under operation type " + dataPath.up() + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postCreate(BE dataEntity, InventoryBackend.Transaction transaction) {
            Object rte = this.context.backend.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.contains)).get());
            ResourceType rt = this.context.backend.convert(rte, ResourceType.class);
            this.context.backend.updateIdentityHash(rte, IdentityHash.of(rt, this.context.inventory.keepTransaction(transaction)));
        }

        @Override
        public void postDelete(BE dataEntity, InventoryBackend.Transaction transaction) {
            CanonicalPath cp = this.context.backend.extractCanonicalPath(dataEntity);
            try {
                Object rte = this.context.backend.find(cp.up(2));
                ResourceType rt = this.context.backend.convert(rte, ResourceType.class);
                this.context.backend.updateIdentityHash(rte, IdentityHash.of(rt, this.context.inventory.keepTransaction(transaction)));
            }
            catch (ElementNotFoundException e) {
                throw new IllegalStateException("Could not find the owning resource type of the operation type " + cp);
            }
        }
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.Multiple {
        public Multiple(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.Read<OperationTypes.DataRole> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new OperationTypeDataModificationChecks(this.context));
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.Single {
        public Single(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.ReadWrite<OperationTypes.DataRole> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new OperationTypeDataModificationChecks(this.context));
        }

        @Override
        protected void preDelete(BE deletedEntity, InventoryBackend.Transaction transaction) {
            if (ReadWrite.isResourceTypeInMetadataPack(this.context, deletedEntity)) {
                throw new IllegalArgumentException("Cannot delete an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.ReadContained {
        public ReadContained(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, OperationType, OperationType.Blueprint, OperationType.Update, String>
    implements OperationTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(OperationType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<OperationType> wireUpNewEntity(BE entity, OperationType.Blueprint blueprint, CanonicalPath parentPath, BE parent, InventoryBackend.Transaction transaction) {
            return new EntityAndPendingNotifications<OperationType>(new OperationType(blueprint.getName(), parentPath.extend(OperationType.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new Notification[0]);
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public OperationTypes.Single create(OperationType.Blueprint blueprint) throws EntityAlreadyExistsException {
            if (this.context.backend.traverseToSingle(this.getParent(), Query.path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null) {
                throw new IllegalArgumentException("Cannot create an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint)));
        }

        @Override
        protected void preDelete(String s, BE entityRepresentation, InventoryBackend.Transaction transaction) {
            if (ReadWrite.isResourceTypeInMetadataPack(this.context, entityRepresentation)) {
                throw new IllegalArgumentException("Cannot delete an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
        }

        private static <BE> boolean isResourceTypeInMetadataPack(TraversalContext<BE, ?> context, BE operationType) {
            return context.backend.traverseToSingle(operationType, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null;
        }
    }
}

