/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.ObservableContext;
import org.hawkular.inventory.base.PotentiallyCommittingPayload;
import org.hawkular.inventory.base.TransactionRecordingBackend;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.InventoryBackend;

final class BaseTransactionFrame<E>
implements TransactionFrame {
    private final InventoryBackend<E> origBackend;
    private InventoryBackend.Transaction transaction;
    private Inventory boundInventory;
    private TransactionRecordingBackend<E> recordingBackend;
    private final int maxRetries;

    BaseTransactionFrame(InventoryBackend<E> origBackend, ObservableContext observableContext, TraversalContext<?, ?> traversalContext) {
        this.origBackend = origBackend;
        this.maxRetries = traversalContext.getTransactionRetriesCount();
        this.recordingBackend = new TransactionRecordingBackend<E>(origBackend, true);
        this.boundInventory = new BaseInventory.Initialized<E>(this.recordingBackend, observableContext, traversalContext.configuration);
        this.reset();
    }

    @Override
    public void commit() throws TransactionFrame.CommitException {
        try {
            Util.commitOrRetry(this.transaction, this.origBackend, null, t -> {
                for (PotentiallyCommittingPayload<?> p : this.recordingBackend.getRecordedPayloads()) {
                    t.execute(p);
                }
                return null;
            }, this.maxRetries);
            this.origBackend.commit(this.transaction);
        }
        catch (CommitFailureException e) {
            throw new TransactionFrame.CommitException(e);
        }
        finally {
            this.recordingBackend.clearRecordedPayloads();
        }
    }

    @Override
    public void rollback() {
        this.origBackend.rollback(this.transaction);
        this.reset();
    }

    @Override
    public Inventory boundInventory() {
        return this.boundInventory;
    }

    private void reset() {
        this.transaction = this.origBackend.startTransaction(true);
    }
}

