/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.api.paging.TransformingPage;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.InventoryBackend;

abstract class Fetcher<BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update>
extends Traversal<BE, E>
implements ResolvableToSingle<E, U>,
ResolvableToMany<E> {
    private boolean useCachedEntity = true;

    public Fetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    @Override
    public E entity() throws EntityNotFoundException, RelationNotFoundException {
        if (this.useCachedEntity && this.context.getCreatedEntity() != null) {
            this.useCachedEntity = false;
            return this.context.getCreatedEntity();
        }
        return (E)this.loadEntity((b, e) -> e);
    }

    protected <T> T loadEntity(BiFunction<BE, E, T> conversion) throws EntityNotFoundException, RelationNotFoundException {
        return (T)this.readOnly(() -> {
            AbstractElement entity;
            Object result = this.context.backend.querySingle(this.context.select().get());
            if (result == null) {
                this.throwNotFoundException();
            }
            if (!this.isApplicable(entity = (AbstractElement)this.context.backend.convert(result, this.context.entityClass))) {
                this.throwNotFoundException();
            }
            return conversion.apply(result, entity);
        });
    }

    @Override
    public void delete() {
        Util.delete(this.context, this.context.select().get(), this::preDelete, this::postDelete);
    }

    @Override
    public void update(U u) throws EntityNotFoundException, RelationNotFoundException {
        Util.update(this.context, this.context.select().get(), u, this::preUpdate, this::postUpdate);
    }

    public String identityHash() {
        return this.readOnly(() -> {
            Object result = this.context.backend.querySingle(this.context.select().get());
            if (result == null) {
                this.throwNotFoundException();
            }
            return this.context.backend.extractIdentityHash(result);
        });
    }

    protected void preDelete(BE deletedEntity, InventoryBackend.Transaction transaction) {
    }

    protected void postDelete(BE deletedEntity, InventoryBackend.Transaction transaction) {
    }

    protected void preUpdate(BE updatedEntity, U update, InventoryBackend.Transaction transaction) {
    }

    protected void postUpdate(BE updatedEntity, InventoryBackend.Transaction transaction) {
    }

    @Override
    public Page<E> entities(Pager pager) {
        return this.loadEntities(pager, (b, e) -> e);
    }

    protected <T> Page<T> loadEntities(Pager pager, BiFunction<BE, E, T> conversionFunction) {
        return this.readOnly(() -> {
            Function<Object, Pair> conversion = e -> new Pair(e, this.context.backend.convert(e, this.context.entityClass));
            Function<Pair, Boolean> filter = this.context.configuration.getResultFilter() == null ? null : p -> this.context.configuration.getResultFilter().isApplicable((AbstractElement)((Pair)p).second);
            Page<Pair> intermediate = this.context.backend.query(this.context.select().get(), pager, conversion, filter);
            return new TransformingPage<Pair, Object>(intermediate, p -> conversionFunction.apply(((Pair)p).first, ((Pair)p).second));
        });
    }

    protected void throwNotFoundException() {
        Fetcher.throwNotFoundException(this.context);
    }

    static void throwNotFoundException(TraversalContext<?, ?> context) {
        if (Entity.class.isAssignableFrom(context.entityClass)) {
            throw new EntityNotFoundException(context.entityClass, Query.filters(context.select().get()));
        }
        throw new RelationNotFoundException((String)null, Query.filters(context.sourcePath));
    }

    private static final class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }
}

