/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.function.Supplier;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.ResultFilter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.base.PotentiallyCommittingPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

public abstract class Traversal<BE, E extends AbstractElement<?, ?>> {
    protected final TraversalContext<BE, E> context;

    protected Traversal(TraversalContext<BE, E> context) {
        this.context = context;
    }

    protected boolean isApplicable(AbstractElement<?, ?> result) {
        ResultFilter filter = this.context.configuration.getResultFilter();
        return filter == null || filter.isApplicable(result);
    }

    protected BE getSingle(Query query, Class<? extends Entity<?, ?>> entityType) {
        return Util.getSingle(this.context.backend, query, entityType);
    }

    protected <R> R mutating(PotentiallyCommittingPayload<R> payload) {
        return Util.runInTransaction(this.context, false, payload);
    }

    protected <R> R readOnly(Supplier<R> payload) {
        return (R)Util.runInTransaction(this.context, true, t -> payload.get());
    }
}

