/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.PotentiallyCommittingPayload;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;

public interface InventoryBackend<E>
extends AutoCloseable {
    public Transaction startTransaction(boolean var1);

    public E find(CanonicalPath var1) throws ElementNotFoundException;

    public Page<E> query(Query var1, Pager var2);

    public E querySingle(Query var1);

    public Page<E> traverse(E var1, Query var2, Pager var3);

    public E traverseToSingle(E var1, Query var2);

    public <T> Page<T> query(Query var1, Pager var2, Function<E, T> var3, Function<T, Boolean> var4);

    public Iterator<E> getTransitiveClosureOver(E var1, Relationships.Direction var2, String ... var3);

    public boolean hasRelationship(E var1, Relationships.Direction var2, String var3);

    public boolean hasRelationship(E var1, E var2, String var3);

    public Set<E> getRelationships(E var1, Relationships.Direction var2, String ... var3);

    public E getRelationship(E var1, E var2, String var3) throws ElementNotFoundException;

    public E getRelationshipSource(E var1);

    public E getRelationshipTarget(E var1);

    public String extractRelationshipName(E var1);

    public String extractId(E var1);

    public Class<?> extractType(E var1);

    public CanonicalPath extractCanonicalPath(E var1);

    public String extractIdentityHash(E var1);

    public <T> T convert(E var1, Class<T> var2);

    public E descendToData(E var1, RelativePath var2);

    public E relate(E var1, E var2, String var3, Map<String, Object> var4);

    public E persist(CanonicalPath var1, Blueprint var2);

    public E persist(StructuredData var1);

    public void update(E var1, AbstractElement.Update var2);

    public void updateIdentityHash(E var1, String var2);

    public void delete(E var1);

    public void deleteStructuredData(E var1);

    public void commit(Transaction var1) throws CommitFailureException;

    public void rollback(Transaction var1);

    public boolean isBackendInternal(E var1);

    public InputStream getGraphSON(String var1);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath var1, Relationships.Direction var2, Class<T> var3, String ... var4);

    public static class Transaction {
        private final boolean mutating;

        public Transaction(boolean mutating) {
            this.mutating = mutating;
        }

        public boolean isMutating() {
            return this.mutating;
        }

        public <R> R execute(PotentiallyCommittingPayload<R> payload) throws CommitFailureException {
            return payload.run(this);
        }
    }
}

