/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.BackendTransaction;
import org.hawkular.inventory.base.BasePreCommit;
import org.hawkular.inventory.base.BaseRelationships;
import org.hawkular.inventory.base.BaseTenants;
import org.hawkular.inventory.base.DelegatingInventoryBackend;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.ObservableContext;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionConstructor;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import rx.Observable;

public abstract class BaseInventory<E>
implements Inventory {
    public static final Configuration.Property TRANSACTION_RETRIES = Configuration.Property.builder().withPropertyNameAndSystemProperty("hawkular.inventory.transaction.retries").withEnvironmentVariables("HAWKULAR_INVENTORY_TRANSACTION_RETRIES").build();
    private InventoryBackend<E> backend;
    private final ObservableContext observableContext;
    private Configuration configuration;
    private TraversalContext<E, Tenant> tenantContext;
    private TraversalContext<E, Relationship> relationshipContext;
    private final TransactionConstructor<E> transactionConstructor;

    protected BaseInventory(BaseInventory<E> orig, InventoryBackend<E> backend, TransactionConstructor<E> transactionConstructor) {
        this.observableContext = orig.observableContext;
        this.configuration = orig.configuration;
        this.backend = backend == null ? orig.backend : backend;
        this.transactionConstructor = transactionConstructor == null ? orig.transactionConstructor : transactionConstructor;
        this.tenantContext = new TraversalContext<Tenant, Tenant>(this, Query.empty(), Query.path().with(With.type(Tenant.class)).get(), this.backend, Tenant.class, this.configuration, this.observableContext, this.transactionConstructor);
        this.relationshipContext = new TraversalContext<Relationship, Relationship>(this, Query.empty(), Query.path().get(), this.backend, Relationship.class, this.configuration, this.observableContext, this.transactionConstructor);
    }

    protected BaseInventory() {
        this.observableContext = new ObservableContext();
        this.transactionConstructor = TransactionConstructor.startInBackend();
    }

    protected BaseInventory(TransactionConstructor<E> txCtor) {
        this.observableContext = new ObservableContext();
        this.transactionConstructor = txCtor;
    }

    protected abstract BaseInventory<E> cloneWith(TransactionConstructor<E> var1);

    protected TransactionConstructor<E> adaptTransactionConstructor(TransactionConstructor<E> txCtor) {
        return txCtor;
    }

    @Override
    public final void initialize(Configuration configuration) {
        this.backend = this.doInitialize(configuration);
        this.tenantContext = new TraversalContext<Tenant, Tenant>(this, Query.empty(), Query.path().with(With.type(Tenant.class)).get(), this.backend, Tenant.class, configuration, this.observableContext, this.transactionConstructor);
        this.relationshipContext = new TraversalContext<Relationship, Relationship>(this, Query.empty(), Query.path().get(), this.backend, Relationship.class, configuration, this.observableContext, this.transactionConstructor);
        this.configuration = configuration;
    }

    @Override
    public TransactionFrame newTransactionFrame() {
        if (this.backend.isPreferringBigTransactions()) {
            return new TransactionFrame(){
                private InventoryBackend<E> activeBackend;
                private final Transaction.PreCommit.Simple<E> globalPreCommit = new Transaction.PreCommit.Simple();
                private List<TransactionPayload.Committing<?, E>> committedPayloads = new ArrayList();
                private final TransactionConstructor<E> fakeTxCtor = (b, p) -> {
                    if (this.activeBackend == null) {
                        this.activeBackend = b.startTransaction();
                    }
                    InventoryBackend realBackend = this.activeBackend;
                    NotificationsHidingPreCommit txPrecommit = new NotificationsHidingPreCommit(p);
                    Runnable onCommit = () -> p.getFinalNotifications().forEach(this.globalPreCommit::addProcessedNotifications);
                    return new BackendTransaction<E>(new TransactionIgnoringBackend(realBackend, onCommit), txPrecommit){

                        @Override
                        public void registerCommittedPayload(TransactionPayload.Committing<?, E> committedPayload) {
                            committedPayloads.add(committedPayload);
                        }
                    };
                };

                @Override
                public void commit() throws TransactionFrame.CommitException {
                    Util.onFailureRetry(p -> new BackendTransaction(new TransactionIgnoringBackend(this.activeBackend, null), p), Transaction.Committable.from(BaseInventory.this.adaptTransactionConstructor(this.fakeTxCtor).construct(this.activeBackend, new BasePreCommit())), tx -> {
                        this.activeBackend.commit();
                        this.globalPreCommit.getFinalNotifications().forEach(BaseInventory.this.tenantContext::notifyAll);
                        return null;
                    }, tx -> {
                        for (TransactionPayload.Committing p : this.committedPayloads) {
                            p.run(tx);
                        }
                        this.activeBackend.commit();
                        this.globalPreCommit.getFinalNotifications().forEach(BaseInventory.this.tenantContext::notifyAll);
                        return null;
                    }, BaseInventory.this.relationshipContext.getTransactionRetriesCount());
                }

                @Override
                public void rollback() {
                    BaseInventory.this.backend.rollback();
                }

                @Override
                public Inventory boundInventory() {
                    return BaseInventory.this.cloneWith(BaseInventory.this.adaptTransactionConstructor(this.fakeTxCtor));
                }
            };
        }
        return new TransactionFrame(){

            @Override
            public void commit() throws TransactionFrame.CommitException {
            }

            @Override
            public void rollback() {
            }

            @Override
            public Inventory boundInventory() {
                return BaseInventory.this;
            }
        };
    }

    BaseInventory<E> keepTransaction(Transaction<E> tx) {
        return this.cloneWith(this.adaptTransactionConstructor((b, p) -> {
            Runnable transferActionsAndNotifs = () -> p.getFinalNotifications().forEach(tx.getPreCommit()::addProcessedNotifications);
            return new BackendTransaction(new TransactionIgnoringBackend(tx.directAccess(), transferActionsAndNotifs), new NotificationsHidingPreCommit(p));
        }));
    }

    protected abstract InventoryBackend<E> doInitialize(Configuration var1);

    @Override
    public final void close() throws Exception {
        if (this.backend != null) {
            this.backend.close();
            this.backend = null;
        }
    }

    @Override
    public Tenants.ReadWrite tenants() {
        return new BaseTenants.ReadWrite<E>(this.tenantContext);
    }

    @Override
    public Relationships.Read relationships() {
        return new BaseRelationships.Read<E>(this.relationshipContext);
    }

    public InventoryBackend<E> getBackend() {
        return this.backend;
    }

    @Override
    public boolean hasObservers(Interest<?, ?> interest) {
        return this.observableContext.isObserved(interest);
    }

    public <C, V> Observable<C> observable(Interest<C, V> interest) {
        return this.observableContext.getObservableFor(interest);
    }

    @Override
    public InputStream getGraphSON(String tenantId) {
        return this.getBackend().getGraphSON(tenantId);
    }

    public AbstractElement getElement(CanonicalPath path) {
        try {
            return (AbstractElement)this.getBackend().find(path);
        }
        catch (ElementNotFoundException e) {
            throw new EntityNotFoundException("No element found on path: " + path.toString());
        }
    }

    @Override
    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath startingPoint, Relationships.Direction direction, Class<T> clazz, String ... relationshipNames) {
        return this.getBackend().getTransitiveClosureOver(startingPoint, direction, clazz, relationshipNames);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T extends AbstractElement> Page<T> execute(Query query, Class<T> requestedEntity, Pager pager) {
        Page<AbstractElement> page = this.backend.query(query, pager, e -> (AbstractElement)this.backend.convert(e, requestedEntity), null);
        return page;
    }

    private static final class NotificationsHidingPreCommit<E>
    implements Transaction.PreCommit<E> {
        private final Transaction.PreCommit<E> pc;

        private NotificationsHidingPreCommit(Transaction.PreCommit<E> pc) {
            this.pc = pc;
        }

        @Override
        public void addAction(Consumer<Transaction<E>> action) {
            this.pc.addAction(action);
        }

        @Override
        public void addNotifications(EntityAndPendingNotifications<E, ?> element) {
            this.pc.addNotifications(element);
        }

        @Override
        public void addProcessedNotifications(EntityAndPendingNotifications<E, ?> element) {
            this.pc.addProcessedNotifications(element);
        }

        @Override
        public List<Consumer<Transaction<E>>> getActions() {
            return this.pc.getActions();
        }

        @Override
        public List<EntityAndPendingNotifications<E, ?>> getFinalNotifications() {
            return Collections.emptyList();
        }

        @Override
        public void initialize(Inventory inventory, Transaction<E> tx) {
            this.pc.initialize(inventory, tx);
        }

        @Override
        public void reset() {
            this.pc.reset();
        }

        public List<EntityAndPendingNotifications<E, ?>> getHiddenFinalNotifications() {
            return this.pc.getFinalNotifications();
        }
    }

    private static class TransactionIgnoringBackend<E>
    extends DelegatingInventoryBackend<E> {
        private final Runnable onCommit;

        public TransactionIgnoringBackend(InventoryBackend<E> backend, Runnable onCommit) {
            super(backend);
            this.onCommit = onCommit;
        }

        @Override
        public void commit() throws CommitFailureException {
            if (this.onCommit != null) {
                this.onCommit.run();
            }
        }

        @Override
        public void rollback() {
        }

        @Override
        public InventoryBackend<E> startTransaction() {
            return this;
        }
    }
}

