/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.IdentityHash;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.Associator;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseMetricTypes {
    private BaseMetricTypes() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Multiple {
        public Multiple(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.defines, Metric.class).get());
        }

        @Override
        public MetricTypes.Read identical() {
            return new Read(this.context.proceed().hop(With.sameIdentityHash()).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Single {
        public Single(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.defines, Metric.class).get());
        }

        @Override
        public MetricTypes.Read identical() {
            return new Read(this.context.proceed().hop(With.sameIdentityHash()).get());
        }

        @Override
        protected void preDelete(BE deletedEntity, Transaction<BE> transaction) {
            ReadWrite.preDelete(deletedEntity, transaction);
        }

        @Override
        protected void preUpdate(BE updatedEntity, MetricType.Update update, Transaction<BE> transaction) {
            ReadWrite.preUpdate(this.context, updatedEntity, update, transaction);
        }

        @Override
        protected void postUpdate(BE updatedEntity, Transaction<BE> transaction) {
            ReadWrite.postUpdate(this.context, updatedEntity, transaction);
        }
    }

    public static class ReadAssociate<BE>
    extends Associator<BE, MetricType>
    implements MetricTypes.ReadAssociate {
        public ReadAssociate(TraversalContext<BE, MetricType> context) {
            super(context, Relationships.WellKnown.incorporates, ResourceType.class);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Read {
        public Read(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.ReadContained {
        public ReadContained(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, MetricType, MetricType.Blueprint, MetricType.Update, String>
    implements MetricTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Transaction<BE> tx, MetricType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<BE, MetricType> wireUpNewEntity(BE entity, MetricType.Blueprint blueprint, CanonicalPath parentPath, BE parent, Transaction<BE> tx) {
            tx.update(entity, MetricType.Update.builder().withUnit(blueprint.getUnit()).build());
            MetricType metricType = new MetricType(blueprint.getName(), parentPath.extend(MetricType.class, tx.extractId(entity)).get(), blueprint.getUnit(), blueprint.getType(), blueprint.getProperties(), blueprint.getCollectionInterval());
            tx.updateIdentityHash(entity, IdentityHash.of(metricType, this.context.inventory.keepTransaction(tx)));
            return new EntityAndPendingNotifications<BE, MetricType>(entity, metricType, Collections.emptyList());
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public MetricTypes.Single create(MetricType.Blueprint blueprint) throws EntityAlreadyExistsException {
            if (blueprint.getType() == null || blueprint.getUnit() == null || blueprint.getCollectionInterval() == null) {
                String msg = this.getErrorMessage(blueprint);
                throw new IllegalArgumentException(msg);
            }
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }

        @Override
        protected void preDelete(String s, BE entityRepresentation, Transaction<BE> transaction) {
            ReadWrite.preDelete(entityRepresentation, transaction);
        }

        @Override
        protected void preUpdate(String s, BE entityRepresentation, MetricType.Update update, Transaction<BE> transaction) {
            ReadWrite.preUpdate(this.context, entityRepresentation, update, transaction);
        }

        @Override
        protected void postUpdate(BE entityRepresentation, Transaction<BE> transaction) {
            ReadWrite.postUpdate(this.context, entityRepresentation, transaction);
        }

        private static <BE> void preDelete(BE deletedEntity, Transaction<BE> tx) {
            if (ReadWrite.isInMetadataPack(deletedEntity, tx)) {
                throw new IllegalArgumentException("Cannot delete a metric type that is a part of metadata pack.");
            }
        }

        private static <BE> void preUpdate(TraversalContext<BE, ?> context, BE entity, MetricType.Update update, Transaction<BE> tx) {
            MetricType mt = tx.convert(entity, MetricType.class);
            if (mt.getUnit() == update.getUnit()) {
                return;
            }
            if (ReadWrite.isInMetadataPack(entity, tx)) {
                throw new IllegalArgumentException("Cannot update a metric type that is a part of metadata pack.");
            }
        }

        private static <BE> void postUpdate(TraversalContext<BE, ?> context, BE entity, Transaction<BE> tx) {
            tx.updateIdentityHash(entity, IdentityHash.of(tx.convert(entity, MetricType.class), context.inventory.keepTransaction(tx)));
        }

        private static <BE> boolean isInMetadataPack(BE metricType, Transaction<BE> tx) {
            return tx.traverseToSingle(metricType, Query.path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null;
        }

        private String getErrorMessage(MetricType.Blueprint blueprint) {
            String msg = blueprint.getCollectionInterval() == null ? "Interval (\"collectionInterval\" in JSON)" : (blueprint.getType() == null ? "Data type (\"type\" in JSON)" : "Metric unit (\"unit\" in JSON)");
            return msg + " is null";
        }
    }
}

