/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Transaction;

public class BasePreCommit<BE>
implements Transaction.PreCommit<BE> {
    private final List<EntityAndPendingNotifications<BE, ?>> nonHashedChanges = new ArrayList();
    private final List<Consumer<Transaction<BE>>> explicitActions = new ArrayList<Consumer<Transaction<BE>>>();

    @Override
    public void initialize(Inventory inventory, Transaction<BE> tx) {
    }

    @Override
    public void reset() {
        this.nonHashedChanges.clear();
        this.explicitActions.clear();
    }

    @Override
    public List<EntityAndPendingNotifications<BE, ?>> getFinalNotifications() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.nonHashedChanges);
        return ret;
    }

    @Override
    public void addAction(Consumer<Transaction<BE>> action) {
        this.explicitActions.add(action);
    }

    @Override
    public List<Consumer<Transaction<BE>>> getActions() {
        return this.explicitActions;
    }

    @Override
    public void addNotifications(EntityAndPendingNotifications<BE, ?> element) {
        if (this.needsProcessing(element)) {
            this.nonHashedChanges.add(element);
        } else {
            this.nonHashedChanges.add(element);
        }
    }

    @Override
    public void addProcessedNotifications(EntityAndPendingNotifications<BE, ?> element) {
        this.nonHashedChanges.add(element);
    }

    private boolean needsProcessing(EntityAndPendingNotifications<?, ?> element) {
        return false;
    }

    private static Blueprint asBlueprint(AbstractElement<?, ?> element) {
        if (element == null) {
            return null;
        }
        return element.accept(new ElementVisitor<Blueprint, Void>(){

            @Override
            public Blueprint visitData(DataEntity data, Void parameter) {
                return this.fillBasicEntity(data, DataEntity.Blueprint.builder()).withRole(data.getRole()).withValue(data.getValue()).build();
            }

            @Override
            public Blueprint visitTenant(Tenant tenant, Void parameter) {
                return this.fillBasicEntity(tenant, Tenant.Blueprint.builder()).build();
            }

            @Override
            public Blueprint visitEnvironment(Environment environment, Void parameter) {
                return this.fillBasicEntity(environment, Environment.Blueprint.builder()).build();
            }

            @Override
            public Blueprint visitFeed(Feed feed, Void parameter) {
                return this.fillBasicEntity(feed, Feed.Blueprint.builder()).build();
            }

            @Override
            public Blueprint visitMetric(Metric metric, Void parameter) {
                return this.fillBasicEntity(metric, Metric.Blueprint.builder()).withInterval(metric.getCollectionInterval()).withMetricTypePath(metric.getType().getPath().toString()).build();
            }

            @Override
            public Blueprint visitMetricType(MetricType type, Void parameter) {
                return this.fillBasicEntity(type, MetricType.Blueprint.builder(type.getType())).withInterval(type.getCollectionInterval()).withUnit(type.getUnit()).build();
            }

            @Override
            public Blueprint visitOperationType(OperationType operationType, Void parameter) {
                return this.fillBasicEntity(operationType, OperationType.Blueprint.builder()).build();
            }

            @Override
            public Blueprint visitMetadataPack(MetadataPack metadataPack, Void parameter) {
                return ((MetadataPack.Blueprint.Builder)MetadataPack.Blueprint.builder().withName(metadataPack.getName()).withProperties(metadataPack.getProperties())).build();
            }

            @Override
            public Blueprint visitUnknown(Object entity, Void parameter) {
                throw new IllegalArgumentException("Unknown blueprint type: " + entity);
            }

            @Override
            public Blueprint visitResource(Resource resource, Void parameter) {
                return this.fillBasicEntity(resource, Resource.Blueprint.builder()).withResourceTypePath(resource.getType().getPath().toString()).build();
            }

            @Override
            public Blueprint visitResourceType(ResourceType type, Void parameter) {
                return this.fillBasicEntity(type, ResourceType.Blueprint.builder()).build();
            }

            @Override
            public Blueprint visitRelationship(Relationship relationship, Void parameter) {
                return new Relationship.Blueprint(Relationships.Direction.outgoing, relationship.getName(), relationship.getTarget(), relationship.getProperties());
            }

            private <E extends Entity<? extends Bl, ?>, Bl extends Entity.Blueprint, BB extends Entity.Blueprint.Builder<Bl, BB>> BB fillBasicEntity(E entity, BB bld) {
                return (BB)((Entity.Blueprint.Builder)((AbstractElement.Blueprint.Builder)((Entity.Blueprint.Builder)bld.withId(entity.getId())).withName(entity.getName())).withProperties(entity.getProperties()));
            }
        }, null);
    }
}

