/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.ResultFilter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

public abstract class Traversal<BE, E extends AbstractElement<?, ?>> {
    protected final TraversalContext<BE, E> context;

    protected Traversal(TraversalContext<BE, E> context) {
        this.context = context;
    }

    protected boolean isApplicable(AbstractElement<?, ?> result) {
        ResultFilter filter = this.context.configuration.getResultFilter();
        return filter == null || filter.isApplicable(result);
    }

    protected BE getSingle(Query query, Class<? extends Entity<?, ?>> entityType) {
        return (BE)this.inTx(backend -> Util.getSingle(backend, query, entityType));
    }

    protected <R> R inTx(TransactionPayload<R, BE> payload) {
        return Traversal.inTx(this.context, payload);
    }

    protected static <R, BE, E extends AbstractElement<?, ?>> R inTx(TraversalContext<BE, E> context, TransactionPayload<R, BE> payload) {
        class Ret {
            final R val;
            final Transaction.PreCommit<BE> preCommit;

            Ret(Transaction.PreCommit<BE> preCommit, R val) {
                this.preCommit = preCommit;
                this.val = val;
            }
        }
        Ret ret = Util.inTx(context, (Transaction<BE> tx) -> {
            Object v = payload.run(tx);
            Transaction.PreCommit preCommit = tx.getPreCommit();
            return new Ret(preCommit, v);
        });
        ret.preCommit.getFinalNotifications().forEach(context::notifyAll);
        return ret.val;
    }

    protected <R> R inCommittableTx(TransactionPayload.Committing<R, BE> payload) {
        return (R)Util.inCommittableTx(this.context, tx -> {
            Object v = payload.run(tx);
            tx.getPreCommit().getFinalNotifications().forEach(this.context::notifyAll);
            return v;
        });
    }
}

