/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Marker;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionFailureException;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;

final class Util {
    private static final Random rand = new Random();

    private Util() {
    }

    public static <R, BE> R inTx(TraversalContext<BE, ?> context, TransactionPayload<R, BE> payload) {
        Transaction<BE> transaction = context.startTransaction();
        Log.LOGGER.trace("Starting transaction: " + transaction);
        int maxFailures = context.getTransactionRetriesCount();
        return Util.onFailureRetry(context, transaction, payload, payload, maxFailures);
    }

    public static <R, BE> R inCommittableTx(TraversalContext<BE, ?> context, TransactionPayload.Committing<R, BE> payload) {
        Transaction.Committable<BE> tx = Transaction.Committable.from(context.startTransaction());
        Log.LOGGER.trace("Starting self-committing transaction: " + tx);
        int maxFailures = context.getTransactionRetriesCount();
        return Util.onFailureRetry(context::startTransaction, tx, payload, payload, maxFailures);
    }

    public static <R, BE> R onFailureRetry(TraversalContext<BE, ?> ctx, Transaction<BE> tx, TransactionPayload<R, BE> firstPayload, TransactionPayload<R, BE> succeedingPayload, int maxFailures) {
        return Util.onFailureRetry(ctx::startTransaction, Transaction.Committable.from(tx), TransactionPayload.Committing.committing(firstPayload), TransactionPayload.Committing.committing(succeedingPayload), maxFailures);
    }

    public static <R, BE> R onFailureRetry(Function<Transaction.PreCommit<BE>, Transaction<BE>> txCtor, Transaction.Committable<BE> tx, TransactionPayload.Committing<R, BE> firstPayload, TransactionPayload.Committing<R, BE> succeedingPayload, int maxFailures) {
        CommitFailureException lastException;
        int failures = 0;
        int waitTime = 100;
        do {
            try {
                try {
                    R ret;
                    if (failures == 0) {
                        ret = firstPayload.run(tx);
                        tx.registerCommittedPayload(firstPayload);
                    } else {
                        tx.getPreCommit().reset();
                        tx = Transaction.Committable.from(txCtor.apply(tx.getPreCommit()));
                        ret = succeedingPayload.run(tx);
                        tx.registerCommittedPayload(succeedingPayload);
                    }
                    return ret;
                }
                catch (Throwable t) {
                    Log.LOGGER.dTransactionFailed(t.getMessage());
                    tx.rollback();
                    throw t;
                }
            }
            catch (CommitFailureException e) {
                Log.LOGGER.debugf(e, "Commit attempt %d/%d failed. Will wait for %d ms before retrying. The failure message was: %s", new Object[]{++failures, maxFailures, waitTime, e.getMessage()});
                lastException = e;
                if (failures >= maxFailures) continue;
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ie) {
                    Log.LOGGER.wInterruptedWhileWaitingForTransactionRetry();
                    Thread.currentThread().interrupt();
                    break;
                }
                waitTime = waitTime * 2 + rand.nextInt(waitTime / 10);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InventoryException("Transaction payload failed.", e);
            }
        } while (failures < maxFailures);
        throw new TransactionFailureException(lastException, failures);
    }

    public static <BE> BE getSingle(Transaction<BE> backend, Query query, Class<? extends Entity<?, ?>> entityType) {
        BE result = backend.querySingle(query);
        if (result == null) {
            throw new EntityNotFoundException(entityType, Query.filters(query));
        }
        return result;
    }

    public static <BE> EntityAndPendingNotifications<BE, Relationship> createAssociation(Transaction<BE> tx, BE source, String relationship, BE target, Map<String, Object> properties) {
        if (tx.hasRelationship(source, target, relationship)) {
            throw new RelationAlreadyExistsException(relationship, Query.filters(Query.to(tx.extractCanonicalPath(source))));
        }
        RelationshipRules.checkCreate(tx, source, Relationships.Direction.outgoing, relationship, target);
        BE relationshipObject = tx.relate(source, target, relationship, properties);
        Relationship ret = tx.convert(relationshipObject, Relationship.class);
        return new EntityAndPendingNotifications<BE, Relationship>(relationshipObject, ret, new Notification<Relationship, Relationship>(ret, ret, Action.created()));
    }

    public static <BE> EntityAndPendingNotifications<BE, Relationship> deleteAssociation(Transaction<BE> tx, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, String relationship, BE target) {
        BE relationshipObject;
        BE source = Util.getSingle(tx, sourceQuery, sourceType);
        try {
            relationshipObject = tx.getRelationship(source, target, relationship);
        }
        catch (ElementNotFoundException e) {
            throw new RelationNotFoundException(sourceType, relationship, Query.filters(sourceQuery), null, null);
        }
        RelationshipRules.checkDelete(tx, source, Relationships.Direction.outgoing, relationship, target);
        Relationship ret = tx.convert(relationshipObject, Relationship.class);
        tx.delete(relationshipObject);
        return new EntityAndPendingNotifications<BE, Relationship>(relationshipObject, ret, new Notification<Relationship, Relationship>(ret, ret, Action.deleted()));
    }

    public static <BE> Relationship getAssociation(Transaction<BE> tx, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, Query targetQuery, Class<? extends Entity<?, ?>> targetType, String rel) {
        BE relationship;
        BE source = Util.getSingle(tx, sourceQuery, sourceType);
        BE target = Util.getSingle(tx, targetQuery, targetType);
        try {
            relationship = tx.getRelationship(source, target, rel);
        }
        catch (ElementNotFoundException e) {
            throw new RelationNotFoundException(sourceType, rel, Query.filters(sourceQuery), null, null);
        }
        return tx.convert(relationship, Relationship.class);
    }

    public static Query queryTo(Query sourcePath, Path path) {
        if (path instanceof CanonicalPath) {
            return Query.to((CanonicalPath)path);
        }
        Query.SymmetricExtender extender = sourcePath.extend().path();
        extender.with(With.relativePath(null, (RelativePath)path));
        return extender.get();
    }

    public static <BE> BE find(Transaction<BE> tx, Query sourcePath, Path path) throws EntityNotFoundException {
        BE element;
        if (path.isCanonical()) {
            try {
                element = tx.find(path.toCanonicalPath());
            }
            catch (ElementNotFoundException e) {
                throw new EntityNotFoundException("Entity not found on path: " + path);
            }
        } else {
            Query query = Util.queryTo(sourcePath, path);
            element = Util.getSingle(tx, query, null);
        }
        return element;
    }

    public static Query extendTo(TraversalContext<?, ?> context, Path path) {
        if (path instanceof CanonicalPath) {
            return context.select().with(With.path((CanonicalPath)path)).get();
        }
        Marker marker = Marker.next();
        return context.sourcePath.extend().path().with(marker).with(context.selectCandidates).with(With.relativePath(marker.getLabel(), (RelativePath)path)).get();
    }

    public static <BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update> void update(Class<E> entityClass, Transaction<BE> tx, Query entityQuery, U update, TransactionParticipant<BE, U> preUpdateCheck, BiConsumer<BE, Transaction<BE>> postUpdateCheck) {
        BE entity = tx.querySingle(entityQuery);
        if (entity == null) {
            if (update instanceof Relationship.Update) {
                throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
            }
            throw new EntityNotFoundException(entityClass, Query.filters(entityQuery));
        }
        if (preUpdateCheck != null) {
            preUpdateCheck.execute(entity, update, tx);
        }
        AbstractElement orig = (AbstractElement)tx.convert(entity, entityClass);
        tx.update(entity, update);
        if (postUpdateCheck != null) {
            postUpdateCheck.accept(entity, tx);
        }
        AbstractElement updated = (AbstractElement)tx.convert(entity, entityClass);
        tx.getPreCommit().addNotifications(new EntityAndPendingNotifications<BE, AbstractElement>(entity, updated, new Action.Update<AbstractElement, U>(orig, update), Action.updated()));
    }

    public static <BE, E extends AbstractElement<?, ?>> void delete(Class<E> entityClass, Transaction<BE> tx, Query entityQuery, BiConsumer<BE, Transaction<BE>> cleanupFunction, BiConsumer<BE, Transaction<BE>> postDelete) {
        BE entity = tx.querySingle(entityQuery);
        if (entity == null) {
            if (entityClass.equals(Relationship.class)) {
                throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
            }
            throw new EntityNotFoundException(entityClass, Query.filters(entityQuery));
        }
        if (cleanupFunction != null) {
            cleanupFunction.accept(entity, tx);
        }
        HashSet verticesToDeleteThatDefineSomething = new HashSet();
        HashSet dataToBeDeleted = new HashSet();
        HashSet deleted = new HashSet();
        HashSet deletedRels = new HashSet();
        Consumer<Object> categorizer = e -> {
            if (tx.hasRelationship((Object)e, (Object)((Object)Relationships.Direction.outgoing), Relationships.WellKnown.defines.name())) {
                verticesToDeleteThatDefineSomething.add(e);
            } else {
                deleted.add(e);
            }
            deletedRels.addAll(tx.getRelationships(e, Relationships.Direction.both, new String[0]));
            tx.getRelationships(e, Relationships.Direction.outgoing, Relationships.WellKnown.hasData.name()).forEach(rel -> dataToBeDeleted.add(tx.getRelationshipTarget(rel)));
        };
        categorizer.accept(entity);
        tx.getTransitiveClosureOver(entity, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name()).forEachRemaining(categorizer::accept);
        deleted.stream().filter(o -> Util.isRepresentableInAPI(tx, o)).forEach(be -> {
            AbstractElement e = (AbstractElement)tx.convert(be, tx.extractType(be));
            tx.getPreCommit().addNotifications(new EntityAndPendingNotifications<Object, AbstractElement>(be, e, Action.deleted()));
        });
        deletedRels.stream().filter(o -> Util.isRepresentableInAPI(tx, o)).forEach(be -> {
            AbstractElement e = (AbstractElement)tx.convert(be, tx.extractType(be));
            tx.getPreCommit().addNotifications(new EntityAndPendingNotifications<Object, AbstractElement>(be, e, Action.deleted()));
        });
        for (Object e2 : deleted) {
            tx.delete(e2);
        }
        for (Object e2 : verticesToDeleteThatDefineSomething) {
            if (tx.hasRelationship((BE)e2, (BE)((Object)Relationships.Direction.outgoing), Relationships.WellKnown.defines.name())) {
                String rootId = tx.extractId(entity);
                String definingId = tx.extractId(e2);
                String rootType = entityClass.getSimpleName();
                String definingType = tx.extractType(e2).getSimpleName();
                String rootEntity = "Entity[id=" + rootId + ", type=" + rootType + "]";
                String definingEntity = "Entity[id=" + definingId + ", type=" + definingType + "]";
                throw new IllegalArgumentException("Could not delete entity " + rootEntity + ". The entity " + definingEntity + ", which it (indirectly) contains, acts as a definition for some " + "entities that are not deleted along with it, which would leave them without a " + "definition. This is illegal.");
            }
            tx.delete(e2);
        }
        dataToBeDeleted.forEach(tx::deleteStructuredData);
        if (postDelete != null) {
            postDelete.accept(entity, tx);
        }
    }

    public static CanonicalPath canonicalize(String path, CanonicalPath canonicalPrefix, CanonicalPath relativeOrigin, Class<?> intendedFinalType) {
        Path p = Path.fromPartiallyUntypedString(path, canonicalPrefix, relativeOrigin, intendedFinalType);
        if (p instanceof RelativePath) {
            return ((RelativePath)p).applyTo(relativeOrigin);
        }
        return p.toCanonicalPath();
    }

    public static <BE> boolean isRepresentableInAPI(Transaction<BE> tx, BE entity) {
        if (tx.isBackendInternal(entity)) {
            return false;
        }
        return !Relationship.class.equals(tx.extractType(entity)) || !Relationships.WellKnown.hasData.name().equals(tx.extractRelationshipName(entity));
    }

    public static interface TransactionParticipant<BE, E> {
        public void execute(BE var1, E var2, Transaction<BE> var3);
    }
}

