/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import org.hawkular.inventory.api.FilterFragment;
import org.hawkular.inventory.api.PathFragment;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.QueryFragment;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.spi.NoopFilter;
import org.hawkular.inventory.base.spi.SwitchElementType;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.junit.Assert;
import org.junit.Test;

public class QueryTest {
    @Test
    public void testCanonicalPathFilterUsed() throws Exception {
        Query q = Query.to((CanonicalPath)((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("t")).environment("e")).get()));
        Assert.assertEquals((long)1L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
    }

    @Test
    public void testCanonicalPathOptimizationOnJustTenant() throws Exception {
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"id")}).get();
        Assert.assertEquals((long)1L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
        CanonicalPath[] cps = ((With.CanonicalPaths)q.getFragments()[0].getFilter()).getPaths();
        Assert.assertEquals((long)1L, (long)cps.length);
        Assert.assertEquals((Object)SegmentType.t, (Object)cps[0].getSegment().getElementType());
        Assert.assertEquals((Object)"id", (Object)cps[0].getSegment().getElementId());
    }

    @Test
    public void testCanonicalPathOnLongPath() throws Exception {
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Environment.class)}).with(new Filter[]{With.id((String)"e")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Resource.class)}).with(new Filter[]{With.id((String)"r")}).get();
        Assert.assertEquals((long)1L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
        CanonicalPath[] cps = ((With.CanonicalPaths)q.getFragments()[0].getFilter()).getPaths();
        Assert.assertEquals((long)1L, (long)cps.length);
        Assert.assertEquals((Object)((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("t")).environment("e")).resource("r")).get(), (Object)cps[0]);
    }

    @Test
    public void testCanonicalPathRobustAgainstInvalidPaths() throws Exception {
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Environment.class)}).with(new Filter[]{With.id((String)"e")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t2")}).get();
        Assert.assertEquals((long)3L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
        Assert.assertTrue((boolean)(q.getFragments()[1].getFilter() instanceof Related));
        Assert.assertTrue((boolean)(q.getFragments()[2].getFilter() instanceof With.CanonicalPaths));
    }

    @Test
    public void testQueryFragmentTypeChangeInterruptsOptimization() throws Exception {
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t")}).filter().with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Environment.class)}).with(new Filter[]{With.id((String)"e")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t2")}).get();
        Assert.assertEquals((long)6L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
        Assert.assertTrue((boolean)(q.getFragments()[1].getFilter() instanceof Related));
        Assert.assertTrue((boolean)(q.getFragments()[2].getFilter() instanceof With.Types));
        Assert.assertTrue((boolean)(q.getFragments()[3].getFilter() instanceof With.Ids));
        Assert.assertTrue((boolean)(q.getFragments()[4].getFilter() instanceof Related));
        Assert.assertTrue((boolean)(q.getFragments()[5].getFilter() instanceof With.CanonicalPaths));
        Assert.assertTrue((boolean)(q.getFragments()[0] instanceof PathFragment));
        Assert.assertTrue((boolean)(q.getFragments()[1] instanceof FilterFragment));
        Assert.assertTrue((boolean)(q.getFragments()[2] instanceof FilterFragment));
        Assert.assertTrue((boolean)(q.getFragments()[3] instanceof FilterFragment));
        Assert.assertTrue((boolean)(q.getFragments()[4] instanceof FilterFragment));
        Assert.assertTrue((boolean)(q.getFragments()[5] instanceof FilterFragment));
    }

    @Test
    public void testOptimizationRessurectsAfterNonCanonicalSection() throws Exception {
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t")}).with(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains)}).with(new Filter[]{With.type(Environment.class)}).with(new Filter[]{With.id((String)"e")}).with(new Filter[]{Related.by((String)"kachna")}).with(new Filter[]{With.type(Tenant.class)}).with(new Filter[]{With.id((String)"t2")}).get();
        Assert.assertEquals((long)3L, (long)q.getFragments().length);
        Assert.assertTrue((boolean)(q.getFragments()[0].getFilter() instanceof With.CanonicalPaths));
        Assert.assertTrue((boolean)(q.getFragments()[1].getFilter() instanceof Related));
        Assert.assertTrue((boolean)(q.getFragments()[2].getFilter() instanceof With.CanonicalPaths));
    }

    @Test
    public void testQueryBuilder() {
        CanonicalPath cp1 = CanonicalPath.fromString((String)"/t;tenant1");
        CanonicalPath cp2 = CanonicalPath.fromString((String)"/t;tenant2");
        Query qMetricsRelationships = Query.path().with(new Filter[]{With.path((CanonicalPath)cp1), SwitchElementType.incomingRelationships(), RelationWith.name((String)"name")}).get();
        Query qTypesRelationships = Query.path().with(new Filter[]{With.path((CanonicalPath)cp2), SwitchElementType.incomingRelationships(), RelationWith.name((String)"name")}).get();
        Query oldQuery = new Query.Builder().with(new QueryFragment[]{new PathFragment((Filter)new NoopFilter())}).branch().with(qMetricsRelationships).done().branch().with(qTypesRelationships).done().build();
        Query.Builder builder = new Query.Builder().branch().path().with(new Filter[]{With.path((CanonicalPath)cp1), SwitchElementType.incomingRelationships(), RelationWith.name((String)"name")}).done().branch().path().with(new Filter[]{With.path((CanonicalPath)cp2), SwitchElementType.incomingRelationships(), RelationWith.name((String)"name")}).done();
        Query newQuery = builder.build();
        Assert.assertTrue((boolean)newQuery.equals((Object)oldQuery));
    }
}

