/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.Associator;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleIdentityHashedFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.RecurseFilter;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

public final class BaseResources {
    private BaseResources() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Resource, Resource.Update>
    implements Resources.Multiple {
        public Multiple(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.Read allMetrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, Metric.class).get());
        }

        @Override
        public Resources.Read allResources() {
            return new ReadAssociate(this.context.proceed().hop(Related.by(Relationships.WellKnown.isParentOf), With.type(Resource.class)).get());
        }

        @Override
        public Resources.Read recursiveResources() {
            return new Read(this.context.proceed().hop(RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.isParentOf), With.type(Resource.class)).build()).get());
        }

        @Override
        public Resources.ReadWrite resources() {
            return new ReadWrite(this.context.proceed().hop(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).get());
        }

        @Override
        public Resources.Read parents() {
            return new Read(this.context.proceed().hop(Related.asTargetBy(Relationships.WellKnown.isParentOf), With.type(Resource.class)).get());
        }

        @Override
        public Data.Read<DataRole.Resource> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), BaseData.DataModificationChecks.none());
        }
    }

    public static class Single<BE>
    extends SingleIdentityHashedFetcher<BE, Resource, Resource.Blueprint, Resource.Update>
    implements Resources.Single {
        public Single(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        public Metrics.ReadWrite metrics() {
            return new BaseMetrics.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.ReadAssociate allMetrics() {
            return new BaseMetrics.ReadAssociate(this.context.proceedTo(Relationships.WellKnown.incorporates, Metric.class).get());
        }

        @Override
        public Resources.ReadAssociate allResources() {
            return new ReadAssociate(this.context.proceed().hop(Related.by(Relationships.WellKnown.isParentOf), With.type(Resource.class)).get());
        }

        @Override
        public Resources.ReadWrite resources() {
            return new ReadWrite(this.context.proceed().hop(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).get());
        }

        @Override
        public Resources.Read recursiveResources() {
            return new Read(this.context.proceed().hop(RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).build()).get());
        }

        @Override
        public Resources.Single parent() {
            return new Single(this.context.proceed().hop(Related.asTargetBy(Relationships.WellKnown.contains), With.type(Resource.class)).get());
        }

        @Override
        public Resources.Read parents() {
            return new Read(this.context.proceed().hop(Related.asTargetBy(Relationships.WellKnown.isParentOf), With.type(Resource.class)).get());
        }

        @Override
        public Data.ReadWrite<DataRole.Resource> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), BaseData.DataModificationChecks.none());
        }
    }

    public static class ReadAssociate<BE>
    extends Read<BE>
    implements Resources.ReadAssociate {
        public ReadAssociate(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        public Relationship associate(Path id) throws EntityNotFoundException, RelationAlreadyExistsException {
            return Associator.associate(this.context, SegmentType.r, Relationships.WellKnown.isParentOf, id);
        }

        @Override
        public Relationship disassociate(Path id) throws EntityNotFoundException, IllegalArgumentException {
            return Associator.disassociate(this.context, SegmentType.r, Relationships.WellKnown.isParentOf, id);
        }

        @Override
        public Relationship associationWith(Path path) throws RelationNotFoundException {
            return Associator.associationWith(this.context, SegmentType.r, Relationships.WellKnown.isParentOf, path);
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Resource>
    implements Resources.Read {
        public Read(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        public Resources.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Resources.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, Resource>
    implements Resources.ReadContained {
        public ReadContained(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        public Resources.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Resources.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Resource, Resource.Blueprint, Resource.Update, String>
    implements Resources.ReadWrite {
        public ReadWrite(TraversalContext<BE, Resource> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Transaction<BE> tx, Resource.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<BE, Resource> wireUpNewEntity(BE entity, Resource.Blueprint blueprint, CanonicalPath parentPath, BE parent, Transaction<BE> tx) {
            BE resourceTypeObject;
            CanonicalPath resourceTypePath = null;
            try {
                CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(parentPath.ids().getTenantId())).get();
                resourceTypePath = Util.canonicalize(blueprint.getResourceTypePath(), tenant, parentPath, ResourceType.SEGMENT_TYPE);
                resourceTypeObject = tx.find(resourceTypePath);
            }
            catch (ElementNotFoundException e) {
                throw new IllegalArgumentException("Resource type '" + blueprint.getResourceTypePath() + "' not found" + " when resolved to '" + resourceTypePath + "'.");
            }
            BE r = tx.relate(resourceTypeObject, entity, Relationships.WellKnown.defines.name(), null);
            CanonicalPath entityPath = tx.extractCanonicalPath(entity);
            resourceTypePath = tx.extractCanonicalPath(resourceTypeObject);
            ResourceType resourceType = tx.convert(resourceTypeObject, ResourceType.class);
            Resource ret = new Resource(blueprint.getName(), parentPath.extend(Resource.SEGMENT_TYPE, tx.extractId(entity)).get(), null, resourceType, blueprint.getProperties());
            Relationship definesRel = new Relationship(tx.extractId(r), Relationships.WellKnown.defines.name(), resourceTypePath, entityPath);
            ArrayList notifications = new ArrayList();
            notifications.add(new Notification<Relationship, Relationship>(definesRel, definesRel, Action.created()));
            if (tx.extractType(parent).equals(Resource.class)) {
                r = this.relate(parent, entity, Relationships.WellKnown.isParentOf.name());
                Relationship parentRel = new Relationship(tx.extractId(r), Relationships.WellKnown.isParentOf.name(), parentPath, entityPath);
                notifications.add(new Notification<Relationship, Relationship>(parentRel, parentRel, Action.created()));
            }
            return new EntityAndPendingNotifications<BE, Resource>(entity, ret, notifications);
        }

        @Override
        public Resources.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Resources.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public Resources.Single create(Resource.Blueprint blueprint, boolean cache) throws EntityAlreadyExistsException {
            if (blueprint.getResourceTypePath() == null) {
                throw new IllegalArgumentException("ResourceType path is null");
            }
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint), cache));
        }
    }
}

