/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.IdentityHashed;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.IdentityHash;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

abstract class SingleIdentityHashedFetcher<BE, E extends Entity<B, U>, B extends Entity.Blueprint, U extends Entity.Update>
extends SingleEntityFetcher<BE, E, U>
implements IdentityHashed.SingleWithRelationships<E, B, U> {
    public SingleIdentityHashedFetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    @Override
    public void synchronize(InventoryStructure newStructure) {
        this.inTx(tx -> {
            Object root = tx.querySingle(this.context.select().get());
            if (root == null) {
                throw new IllegalArgumentException("The root element must exist before its inventory structure can be synchronized.");
            }
            CanonicalPath rootPath = tx.extractCanonicalPath(root);
            IdentityHash.Tree currentTree = this.treeHash(tx);
            IdentityHash.Tree newTree = IdentityHash.treeOf(newStructure);
            this.syncTrees(tx, rootPath, root, currentTree, newTree, newStructure);
            return null;
        });
    }

    @Override
    public IdentityHash.Tree treeHash() {
        return this.inTx(this::treeHash);
    }

    private void syncTrees(Transaction<BE> tx, CanonicalPath root, BE oldElement, IdentityHash.Tree oldTree, IdentityHash.Tree newTree, InventoryStructure newStructure) {
        if (!oldTree.getHash().equals(newTree.getHash())) {
            Blueprint newState = newStructure.get(newTree.getPath());
            Entity.Update entityUpdate = this.updateFromBlueprint(newState);
            BaseInventory inv = this.context.inventory.keepTransaction(tx);
            inv.inspect(tx.extractCanonicalPath(oldElement), ResolvableToSingle.class).update(entityUpdate);
            HashSet<IdentityHash.Tree> unprocessedChildren = new HashSet<IdentityHash.Tree>(newTree.getChildren());
            HashMap<IdentityHash.Tree, IdentityHash.Tree> updates = new HashMap<IdentityHash.Tree, IdentityHash.Tree>();
            Map<InventoryStructure.EntityType, Set<IdentityHash.Tree>> childrenByType = SingleIdentityHashedFetcher.splitByType(oldTree.getChildren());
            for (InventoryStructure.EntityType type : InventoryStructure.EntityType.values()) {
                Set<IdentityHash.Tree> oldChildren = childrenByType.get((Object)type);
                if (oldChildren == null) continue;
                for (IdentityHash.Tree oldChild : oldChildren) {
                    IdentityHash.Tree newChild = newTree.getChild(oldChild.getPath().getSegment());
                    if (newChild == null) {
                        CanonicalPath childCp = oldChild.getPath().applyTo(root);
                        try {
                            inv.inspect(childCp, ResolvableToSingle.class).delete();
                        }
                        catch (EntityNotFoundException e) {
                            Log.LOGGER.debug("Failed to find a child to be deleted on canonical path " + childCp + ". Ignoring this since we were going to delete it anyway.", e);
                        }
                        continue;
                    }
                    unprocessedChildren.remove(newChild);
                    updates.put(oldChild, newChild);
                }
            }
            unprocessedChildren.forEach(c -> this.create(tx, root, (IdentityHash.Tree)c, newStructure));
            for (Map.Entry entry : updates.entrySet()) {
                IdentityHash.Tree oldChild = (IdentityHash.Tree)entry.getKey();
                IdentityHash.Tree update = (IdentityHash.Tree)entry.getValue();
                CanonicalPath childCp = update.getPath().applyTo(root);
                try {
                    BE child = tx.find(childCp);
                    this.syncTrees(tx, root, child, oldChild, update, newStructure);
                }
                catch (ElementNotFoundException ex) {
                    Log.LOGGER.debug("Failed to find entity on " + childCp + " that we thought was there. Never mind " + "though, we can just create it again.", ex);
                    this.create(tx, root, update, newStructure);
                }
            }
        }
    }

    private void create(Transaction<BE> tx, CanonicalPath root, IdentityHash.Tree tree, InventoryStructure<?> newStructure) {
        BaseInventory inv = this.context.inventory.keepTransaction(tx);
        CanonicalPath childCp = tree.getPath().applyTo(root);
        final ResolvableToSingle parentAccess = inv.inspect(childCp.up(), ResolvableToSingle.class);
        final Blueprint blueprint = newStructure.get(tree.getPath());
        if (blueprint == null) {
            return;
        }
        childCp.getSegment().accept((ElementTypeVisitor)new ElementTypeVisitor.Simple<Void, Void>(){

            public Void visitFeed(Void parameter) {
                ((Feeds.ReadWrite)((Feeds.Container)((Object)parentAccess)).feeds()).create((Feed.Blueprint)blueprint);
                return null;
            }

            public Void visitMetric(Void parameter) {
                ((Metrics.ReadWrite)((Metrics.Container)((Object)parentAccess)).metrics()).create((Metric.Blueprint)blueprint);
                return null;
            }

            public Void visitMetricType(Void parameter) {
                ((MetricTypes.ReadWrite)((MetricTypes.Container)((Object)parentAccess)).metricTypes()).create((MetricType.Blueprint)blueprint);
                return null;
            }

            public Void visitResource(Void parameter) {
                ((Resources.ReadWrite)((Resources.Container)((Object)parentAccess)).resources()).create((Resource.Blueprint)blueprint);
                return null;
            }

            public Void visitResourceType(Void parameter) {
                ((ResourceTypes.ReadWrite)((ResourceTypes.Container)((Object)parentAccess)).resourceTypes()).create((ResourceType.Blueprint)blueprint);
                return null;
            }

            public Void visitData(Void parameter) {
                ((Data.ReadWrite)((Data.Container)((Object)parentAccess)).data()).create((DataEntity.Blueprint)blueprint);
                return null;
            }

            public Void visitOperationType(Void parameter) {
                ((OperationTypes.ReadWrite)((OperationTypes.Container)((Object)parentAccess)).operationTypes()).create((OperationType.Blueprint)blueprint);
                return null;
            }
        }, null);
        for (IdentityHash.Tree child : tree.getChildren()) {
            this.create(tx, root, child, newStructure);
        }
    }

    private Entity.Update updateFromBlueprint(Blueprint blueprint) {
        return blueprint.accept(new ElementBlueprintVisitor.Simple<Entity.Update, Void>(){

            @Override
            public DataEntity.Update visitData(DataEntity.Blueprint<?> data, Void parameter) {
                return this.fillCommon(DataEntity.Update.builder(), data).withValue(data.getValue()).build();
            }

            @Override
            public Feed.Update visitFeed(Feed.Blueprint feed, Void parameter) {
                return this.fillCommon(Feed.Update.builder(), feed).build();
            }

            @Override
            public Metric.Update visitMetric(Metric.Blueprint metric, Void parameter) {
                return this.fillCommon(Metric.Update.builder(), metric).withInterval(metric.getCollectionInterval()).build();
            }

            @Override
            public MetricType.Update visitMetricType(MetricType.Blueprint type, Void parameter) {
                return this.fillCommon(MetricType.Update.builder(), type).withInterval(type.getCollectionInterval()).build();
            }

            @Override
            public OperationType.Update visitOperationType(OperationType.Blueprint operationType, Void parameter) {
                return this.fillCommon(OperationType.Update.builder(), operationType).build();
            }

            @Override
            public Resource.Update visitResource(Resource.Blueprint resource, Void parameter) {
                return this.fillCommon(Resource.Update.builder(), resource).build();
            }

            @Override
            public ResourceType.Update visitResourceType(ResourceType.Blueprint type, Void parameter) {
                return this.fillCommon(ResourceType.Update.builder(), type).build();
            }

            private <UU extends Entity.Update, Bld extends Entity.Update.Builder<UU, Bld>> Bld fillCommon(Bld bld, Entity.Blueprint bl) {
                if (bl.getProperties() != null) {
                    bld.withProperties(bl.getProperties());
                }
                return bld.withName(bl.getName());
            }
        }, null);
    }

    private IdentityHash.Tree treeHash(Transaction<BE> tx) {
        BE root = tx.querySingle(this.context.select().get());
        Iterator<BE> closure = tx.getTransitiveClosureOver(root, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name());
        IdentityHash.Tree.Builder bld = IdentityHash.Tree.builder();
        ((IdentityHash.Tree.Builder)bld.withPath(RelativePath.empty().get())).withHash(tx.extractIdentityHash(root));
        if (closure.hasNext()) {
            CanonicalPath rootPath = tx.extractCanonicalPath(root);
            ArrayList<IdentityHash.Tree.ChildBuilder> children = new ArrayList<IdentityHash.Tree.ChildBuilder>();
            this.buildChildTree(tx, rootPath, new ArrayList<IdentityHash.Tree.Builder>(Collections.singletonList(bld)), children, closure.next(), closure);
        }
        return bld.build();
    }

    private <P extends IdentityHash.Tree.AbstractBuilder<P>> void buildChildTree(Transaction<BE> tx, CanonicalPath root, List<P> possibleParents, List<IdentityHash.Tree.ChildBuilder> currentRow, BE currentElement, Iterator<BE> nextElements) {
        Consumer<Object> decider = e -> {
            CanonicalPath currentPath = tx.extractCanonicalPath(e);
            RelativePath relativeCurrentPath = currentPath.relativeTo(root);
            IdentityHash.Tree.AbstractBuilder<?> parent = this.findParent(possibleParents, relativeCurrentPath);
            if (parent == null) {
                possibleParents.forEach(p -> {
                    if (p instanceof IdentityHash.Tree.ChildBuilder) {
                        ((IdentityHash.Tree.ChildBuilder)p).endChild();
                    }
                });
                this.buildChildTree(tx, root, currentRow, new ArrayList<IdentityHash.Tree.ChildBuilder>(), e, nextElements);
            } else {
                IdentityHash.Tree.ChildBuilder<?> childBuilder = parent.startChild();
                childBuilder.withHash(tx.extractIdentityHash(e));
                childBuilder.withPath(relativeCurrentPath);
                currentRow.add(childBuilder);
            }
        };
        decider.accept(currentElement);
        while (nextElements.hasNext()) {
            decider.accept(nextElements.next());
        }
        currentRow.forEach(IdentityHash.Tree.ChildBuilder::endChild);
    }

    private IdentityHash.Tree.AbstractBuilder<?> findParent(List<? extends IdentityHash.Tree.AbstractBuilder<?>> possibleParents, RelativePath childPath) {
        return possibleParents.stream().filter(p -> p.getPath().isParentOf(childPath) && p.getPath().getDepth() == childPath.getDepth() - 1).findAny().orElse(null);
    }

    private static Map<InventoryStructure.EntityType, Set<IdentityHash.Tree>> splitByType(Collection<IdentityHash.Tree> group) {
        EnumMap<InventoryStructure.EntityType, Set<IdentityHash.Tree>> ret = new EnumMap<InventoryStructure.EntityType, Set<IdentityHash.Tree>>(InventoryStructure.EntityType.class);
        group.forEach(t -> {
            SegmentType elementType = t.getPath().getSegment().getElementType();
            InventoryStructure.EntityType entityType = InventoryStructure.EntityType.of(elementType);
            HashSet<IdentityHash.Tree> siblings = (HashSet<IdentityHash.Tree>)ret.get((Object)entityType);
            if (siblings == null) {
                siblings = new HashSet<IdentityHash.Tree>();
                ret.put(entityType, siblings);
            }
            siblings.add((IdentityHash.Tree)t);
        });
        return ret;
    }
}

