/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.TreeTraversal;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public final class IdentityHash {
    private static final Comparator<Entity<?, ?>> ENTITY_COMPARATOR = (a, b) -> {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (!a.getClass().equals(b.getClass())) {
            return a.getClass().getName().compareTo(b.getClass().getName());
        }
        return a.getId().compareTo(b.getId());
    };
    private static final Comparator<Entity.Blueprint> BLUEPRINT_COMPARATOR = (a, b) -> {
        Class bc;
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        Class ac = Blueprint.getEntityTypeOf(a);
        if (!ac.equals(bc = Blueprint.getEntityTypeOf(b))) {
            return ac.getName().compareTo(bc.getName());
        }
        return a.getId().compareTo(b.getId());
    };

    private IdentityHash() {
    }

    public static String of(MetadataPack.Members metadata) {
        HashConstructor ctor = new HashConstructor(new DigestComputingWriter(IdentityHash.newDigest()));
        HashableView metadataView = HashableView.of(metadata);
        TreeSet<Entity.Blueprint> all = new TreeSet<Entity.Blueprint>(BLUEPRINT_COMPARATOR);
        all.addAll(metadata.getMetricTypes());
        all.addAll(metadata.getResourceTypes());
        StringBuilder result = new StringBuilder();
        for (Entity.Blueprint bl : all) {
            IntermediateHashResult res = IdentityHash.computeHash(bl, metadataView, ctor, rp -> null);
            result.append(res.hash);
        }
        DigestComputingWriter digestor = ctor.getDigestor();
        digestor.reset();
        digestor.append(result);
        digestor.close();
        return digestor.digest();
    }

    public static String of(InventoryStructure<?> inventory) {
        HashConstructor ctor = new HashConstructor(new DigestComputingWriter(IdentityHash.newDigest()));
        IdentityHash.computeHash(inventory.getRoot(), HashableView.of(inventory), ctor, rp -> null);
        return ctor.getDigestor().digest();
    }

    public static String of(Entity<? extends Entity.Blueprint, ?> entity, Inventory inventory) {
        return IdentityHash.of(InventoryStructure.of(entity, inventory));
    }

    public static String of(MetadataPack mp, Inventory inventory) {
        ArrayList all = new ArrayList();
        all.addAll(((ResourceTypes.Multiple)inventory.inspect(mp).resourceTypes().getAll(new Filter[0])).entities());
        all.addAll(((MetricTypes.Multiple)inventory.inspect(mp).metricTypes().getAll(new Filter[0])).entities());
        return IdentityHash.of(all, inventory);
    }

    public static Tree treeOf(InventoryStructure<?> inventory) {
        final Tree.AbstractBuilder[] tbld = new Tree.AbstractBuilder[1];
        DigestComputingWriter wrt = new DigestComputingWriter(IdentityHash.newDigest());
        HashConstructor ctor = new HashConstructor(wrt){

            @Override
            public void startChild(IntermediateHashContext context) {
                super.startChild(context);
                tbld[0] = tbld[0] == null ? Tree.builder() : tbld[0].startChild();
            }

            @Override
            public void endChild(IntermediateHashContext ctx, IntermediateHashResult result) {
                super.endChild(ctx, result);
                if (tbld[0] instanceof Tree.ChildBuilder) {
                    ((Tree.AbstractBuilder)tbld[0].withHash(result.hash)).withPath(result.path);
                    Tree.AbstractBuilder parent = ((Tree.ChildBuilder)tbld[0]).parent;
                    parent.addChild(tbld[0].build());
                    tbld[0] = parent;
                }
            }
        };
        IntermediateHashResult res = IdentityHash.computeHash(inventory.getRoot(), HashableView.of(inventory), ctor, rp -> rp.slide(1, 0));
        ((Tree.AbstractBuilder)tbld[0].withPath(res.path)).withHash(res.hash);
        return tbld[0].build();
    }

    public static String of(Iterable<? extends Entity<? extends Entity.Blueprint, ?>> entities, Inventory inventory) {
        return IdentityHash.of(entities.iterator(), inventory);
    }

    public static String of(Iterator<? extends Entity<? extends Entity.Blueprint, ?>> entities, Inventory inventory) {
        TreeSet sortedEntities = new TreeSet(ENTITY_COMPARATOR);
        entities.forEachRemaining(sortedEntities::add);
        HashConstructor ctor = new HashConstructor(new DigestComputingWriter(IdentityHash.newDigest()));
        StringBuilder resultHash = new StringBuilder();
        sortedEntities.forEach(e -> {
            InventoryStructure structure = InventoryStructure.of(e, inventory);
            HashableView v = HashableView.of(structure);
            IntermediateHashResult res = IdentityHash.computeHash(structure.getRoot(), v, ctor, rp -> null);
            resultHash.append(res.hash);
        });
        ctor.getDigestor().reset();
        ctor.getDigestor().append(resultHash);
        ctor.getDigestor().close();
        return ctor.getDigestor().digest();
    }

    private static IntermediateHashResult computeHash(Blueprint entity, final HashableView structure, final HashConstructor bld, final Function<RelativePath, RelativePath> pathCompleter) {
        return entity.accept(new ElementBlueprintVisitor.Simple<IntermediateHashResult, IntermediateHashContext>(){

            @Override
            public IntermediateHashResult visitData(DataEntity.Blueprint<?> data, IntermediateHashContext ctx) {
                return this.wrap(data, ctx, childContext -> {
                    try {
                        childContext.content.append(data.getId());
                        data.getValue().writeJSON(childContext.content);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not write out JSON for hash computation purposes.", e);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitMetricType(MetricType.Blueprint mt, IntermediateHashContext ctx) {
                return this.wrap(mt, ctx, childContext -> {
                    this.append(mt.getId(), (IntermediateHashContext)childContext);
                    this.append(mt.getType().name(), (IntermediateHashContext)childContext);
                    this.append(mt.getUnit().name(), (IntermediateHashContext)childContext);
                });
            }

            @Override
            public IntermediateHashResult visitOperationType(OperationType.Blueprint operationType, IntermediateHashContext ctx) {
                return this.wrap(operationType, ctx, childContext -> {
                    this.append(structure.getReturnType(ctx.root, operationType), (IntermediateHashContext)childContext);
                    this.append(structure.getParameterTypes(ctx.root, operationType), (IntermediateHashContext)childContext);
                    this.append(operationType.getId(), (IntermediateHashContext)childContext);
                });
            }

            @Override
            public IntermediateHashResult visitResourceType(ResourceType.Blueprint type, IntermediateHashContext ctx) {
                return this.wrap(type, ctx, childContext -> {
                    this.append(structure.getConfigurationSchema(type), (IntermediateHashContext)childContext);
                    this.append(structure.getConnectionConfigurationSchema(type), (IntermediateHashContext)childContext);
                    structure.getOperationTypes(type).forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    this.append(type.getId(), (IntermediateHashContext)childContext);
                });
            }

            @Override
            public IntermediateHashResult visitFeed(Feed.Blueprint feed, IntermediateHashContext ctx) {
                return this.wrap(feed, ctx, childContext -> {
                    structure.getResourceTypes().forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    structure.getMetricTypes().forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    structure.getFeedResources().forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    structure.getFeedMetrics().forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    this.append(feed.getId(), (IntermediateHashContext)childContext);
                });
            }

            @Override
            public IntermediateHashResult visitMetric(Metric.Blueprint metric, IntermediateHashContext ctx) {
                return this.wrap(metric, ctx, childContext -> this.append(metric.getId(), (IntermediateHashContext)childContext));
            }

            @Override
            public IntermediateHashResult visitResource(Resource.Blueprint resource, IntermediateHashContext context) {
                return this.wrap(resource, context, childContext -> {
                    this.append(structure.getConfiguration(context.root, resource), (IntermediateHashContext)childContext);
                    this.append(structure.getConnectionConfiguration(context.root, resource), (IntermediateHashContext)childContext);
                    structure.getResources(context.root, resource).forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    structure.getResourceMetrics(context.root, resource).forEach(b -> this.append((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                    this.append(resource.getId(), (IntermediateHashContext)childContext);
                });
            }

            private void append(String data, IntermediateHashContext ctx) {
                ctx.content.append(data);
            }

            private void append(Entity.Blueprint child, IntermediateHashContext ctx) {
                ctx.content.append(child.accept(this, ctx).hash);
            }

            private IntermediateHashResult wrap(Entity.Blueprint root, IntermediateHashContext context, Consumer<IntermediateHashContext> hashComputation) {
                IntermediateHashContext childCtx = context.progress(root);
                bld.startChild(childCtx);
                hashComputation.accept(childCtx);
                DigestComputingWriter digestor = bld.getDigestor();
                digestor.reset();
                digestor.append(childCtx.content);
                digestor.close();
                IntermediateHashResult ret = pathCompleter == null ? new IntermediateHashResult(null, digestor.digest()) : new IntermediateHashResult((RelativePath)pathCompleter.apply(childCtx.root), digestor.digest());
                bld.endChild(childCtx, ret);
                return ret;
            }
        }, new IntermediateHashContext(RelativePath.empty().get()));
    }

    private static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not instantiate SHA-1 digest algorithm.", e);
        }
    }

    private static <R extends DataRole> DataEntity.Blueprint<R> dummyDataBlueprint(R role) {
        return DataEntity.Blueprint.builder().withRole(role).withValue(StructuredData.get().undefined()).build();
    }

    @ApiModel(value="IdentityHashTree")
    public static final class Tree
    implements Serializable {
        private final RelativePath path;
        private final String hash;
        private final Map<Path.Segment, Tree> children;

        private Tree(RelativePath path, String hash, Map<Path.Segment, Tree> children) {
            this.path = path;
            this.hash = hash;
            this.children = children;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Collection<Tree> getChildren() {
            return this.children.values();
        }

        public Tree getChild(Path.Segment path) {
            return this.children.get(path);
        }

        public String getHash() {
            return this.hash;
        }

        public RelativePath getPath() {
            return this.path;
        }

        public TreeTraversal<Tree> traversal() {
            return new TreeTraversal<Tree>(t -> t.children.values().iterator());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tree tree = (Tree)o;
            return this.hash.equals(tree.hash);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public String toString() {
            return "Tree[path=" + this.path + ", hash='" + this.hash + '\'' + ",children=" + this.children.values() + ']';
        }

        public static final class ChildBuilder<Parent extends AbstractBuilder<?>>
        extends AbstractBuilder<ChildBuilder<Parent>> {
            private Parent parent;

            private ChildBuilder() {
            }

            public Parent endChild() {
                Tree tree = this.build();
                ((AbstractBuilder)this.parent).addChild(tree);
                return this.parent;
            }
        }

        public static final class Builder
        extends AbstractBuilder<Builder> {
            private Builder() {
            }

            @Override
            public Tree build() {
                return super.build();
            }
        }

        public static abstract class AbstractBuilder<This extends AbstractBuilder<?>> {
            private RelativePath path;
            private String hash;
            private Map<Path.Segment, Tree> children;

            public This withPath(RelativePath path) {
                this.path = path;
                return this.castThis();
            }

            public This withHash(String hash) {
                this.hash = hash;
                return this.castThis();
            }

            public String getHash() {
                return this.hash;
            }

            public RelativePath getPath() {
                return this.path;
            }

            public boolean hasChildren() {
                return this.children != null && !this.children.isEmpty();
            }

            protected void addChild(Tree childTree) {
                this.getChildren().put(childTree.getPath().getSegment(), childTree);
            }

            public ChildBuilder<This> startChild() {
                ChildBuilder childBuilder = new ChildBuilder();
                childBuilder.parent = this.castThis();
                return childBuilder;
            }

            protected Tree build() {
                if (!(this.path != null && this.hash != null || this.children == null || this.children.isEmpty())) {
                    throw new IllegalStateException("Cannot construct and IndentityHash.Tree node without a path or hash and with children. While empty tree without a hash or path is OK, having childrenassumes the parent to be fully established.");
                }
                if (this.path != null) {
                    int myDepth = this.path.getDepth();
                    for (Tree child : this.getChildren().values()) {
                        int childDepth = child.getPath().getDepth();
                        if (this.path.isParentOf(child.getPath()) && childDepth == myDepth + 1) continue;
                        throw new IllegalStateException("When building a tree node with path " + this.path + " an attempt " + "to add a child on path " + child.getPath() + " was made. The child's path must extend the parent's path by exactly" + " one segment, which is not true in this case.");
                    }
                }
                return new Tree(this.path, this.hash, Collections.unmodifiableMap(this.getChildren()));
            }

            private Map<Path.Segment, Tree> getChildren() {
                if (this.children == null) {
                    this.children = new HashMap<Path.Segment, Tree>();
                }
                return this.children;
            }

            private This castThis() {
                return (This)this;
            }
        }
    }

    private static class DigestComputingWriter
    implements Appendable,
    Closeable {
        private final MessageDigest digester;
        private final CharsetEncoder enc = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        private final ByteBuffer buffer = ByteBuffer.allocate(512);
        private String digest;

        private DigestComputingWriter(MessageDigest digester) {
            this.digester = digester;
        }

        @Override
        public DigestComputingWriter append(CharSequence csq) {
            this.consumeBuffer(CharBuffer.wrap(csq));
            return this;
        }

        @Override
        public DigestComputingWriter append(CharSequence csq, int start, int end) {
            this.consumeBuffer(CharBuffer.wrap(csq, start, end));
            return this;
        }

        @Override
        public DigestComputingWriter append(char c) {
            this.consumeBuffer(CharBuffer.wrap(new char[]{c}));
            return this;
        }

        @Override
        public void close() {
            byte[] digest = this.digester.digest();
            StringBuilder bld = new StringBuilder();
            for (byte b : digest) {
                bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
            }
            this.digest = bld.toString();
        }

        public String digest() {
            if (this.digest == null) {
                throw new IllegalStateException("digest computing writer not closed.");
            }
            return this.digest;
        }

        public void reset() {
            this.digester.reset();
            this.digest = null;
        }

        private void consumeBuffer(CharBuffer chars) {
            CoderResult res;
            do {
                res = this.enc.encode(chars, this.buffer, true);
                this.buffer.flip();
                this.digester.update(this.buffer);
                this.buffer.clear();
            } while (res == CoderResult.OVERFLOW);
        }
    }

    private static class IntermediateHashResult {
        private final RelativePath path;
        private final String hash;

        private IntermediateHashResult(RelativePath path, String hash) {
            this.path = path;
            this.hash = hash;
        }
    }

    private static class IntermediateHashContext {
        final RelativePath root;
        final StringBuilder content = new StringBuilder();

        public IntermediateHashContext progress(Entity.Blueprint bl) {
            return new IntermediateHashContext(this.root.modified().extend(Blueprint.getSegmentTypeOf(bl), bl.getId()).get());
        }

        public IntermediateHashContext(RelativePath root) {
            this.root = root;
        }
    }

    private static class HashConstructor {
        private final DigestComputingWriter digestor;

        HashConstructor(DigestComputingWriter digestor) {
            this.digestor = digestor;
        }

        public DigestComputingWriter getDigestor() {
            return this.digestor;
        }

        public void startChild(IntermediateHashContext context) {
        }

        public void endChild(IntermediateHashContext ctx, IntermediateHashResult result) {
        }
    }

    private static interface HashableView {
        public static HashableView of(final MetadataPack.Members members) {
            return new HashableView(){

                @Override
                public List<ResourceType.Blueprint> getResourceTypes() {
                    return members.getResourceTypes();
                }

                @Override
                public List<MetricType.Blueprint> getMetricTypes() {
                    return members.getMetricTypes();
                }

                @Override
                public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint resourceType) {
                    ArrayList<OperationType.Blueprint> ret = new ArrayList<OperationType.Blueprint>(members.getOperationTypes(resourceType));
                    Collections.sort(ret, BLUEPRINT_COMPARATOR);
                    return ret;
                }

                @Override
                public DataEntity.Blueprint<?> getReturnType(RelativePath resourceType, OperationType.Blueprint operationType) {
                    return members.getReturnType(operationType);
                }

                @Override
                public DataEntity.Blueprint<?> getParameterTypes(RelativePath resourceType, OperationType.Blueprint operationType) {
                    return members.getParameterTypes(operationType);
                }

                @Override
                public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
                    return members.getConfigurationSchema(rt);
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
                    return members.getConnectionConfigurationSchema(rt);
                }
            };
        }

        public static HashableView of(final InventoryStructure<?> structure) {
            return new HashableView(){

                @Override
                public DataEntity.Blueprint<?> getConfiguration(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath resourcePath = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    return structure.getChildren(resourcePath, DataEntity.class).filter(d -> DataRole.Resource.configuration.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.Resource.configuration));
                }

                @Override
                public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    return structure.getChildren(p, DataEntity.class).filter(d -> DataRole.ResourceType.configurationSchema.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.configurationSchema));
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfiguration(RelativePath root, Resource.Blueprint parentResource) {
                    RelativePath resourcePath = root.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    return structure.getChildren(resourcePath, DataEntity.class).filter(d -> DataRole.Resource.connectionConfiguration.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.Resource.connectionConfiguration));
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    return structure.getChildren(p, DataEntity.class).filter(d -> DataRole.ResourceType.connectionConfigurationSchema.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.connectionConfigurationSchema));
                }

                @Override
                public List<Metric.Blueprint> getFeedMetrics() {
                    return structure.getChildren(RelativePath.empty().get(), Metric.class).collect(Collectors.toList());
                }

                @Override
                public List<Resource.Blueprint> getFeedResources() {
                    return structure.getChildren(RelativePath.empty().get(), Resource.class).collect(Collectors.toList());
                }

                @Override
                public List<MetricType.Blueprint> getMetricTypes() {
                    return structure.getChildren(RelativePath.empty().get(), MetricType.class).collect(Collectors.toList());
                }

                @Override
                public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    return structure.getChildren(p, OperationType.class).collect(Collectors.toList());
                }

                @Override
                public DataEntity.Blueprint<?> getParameterTypes(RelativePath rootResourceType, OperationType.Blueprint ot) {
                    RelativePath p = rootResourceType.modified().extend(SegmentType.ot, ot.getId()).get().slide(1, 0);
                    return structure.getChildren(p, DataEntity.class).filter(d -> DataRole.OperationType.parameterTypes.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.OperationType.parameterTypes));
                }

                @Override
                public List<Metric.Blueprint> getResourceMetrics(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath p = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    return structure.getChildren(p, Metric.class).collect(Collectors.toList());
                }

                @Override
                public List<Resource.Blueprint> getResources(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath p = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    return structure.getChildren(p, Resource.class).collect(Collectors.toList());
                }

                @Override
                public List<ResourceType.Blueprint> getResourceTypes() {
                    return structure.getChildren(RelativePath.empty().get(), ResourceType.class).collect(Collectors.toList());
                }

                @Override
                public DataEntity.Blueprint<?> getReturnType(RelativePath rootResourceType, OperationType.Blueprint ot) {
                    RelativePath p = rootResourceType.modified().extend(SegmentType.ot, ot.getId()).get().slide(1, 0);
                    return structure.getChildren(p, DataEntity.class).filter(d -> DataRole.OperationType.returnType.equals(d.getRole())).findFirst().orElse(IdentityHash.dummyDataBlueprint((DataRole)DataRole.OperationType.returnType));
                }
            };
        }

        default public List<ResourceType.Blueprint> getResourceTypes() {
            return Collections.emptyList();
        }

        default public List<MetricType.Blueprint> getMetricTypes() {
            return Collections.emptyList();
        }

        default public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint rt) {
            return Collections.emptyList();
        }

        default public DataEntity.Blueprint<?> getReturnType(RelativePath rootResourceType, OperationType.Blueprint ot) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.OperationType.returnType);
        }

        default public DataEntity.Blueprint<?> getParameterTypes(RelativePath rootResourceType, OperationType.Blueprint ot) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.OperationType.parameterTypes);
        }

        default public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.configurationSchema);
        }

        default public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.connectionConfigurationSchema);
        }

        default public List<Resource.Blueprint> getResources(RelativePath rootPath, Resource.Blueprint parentResource) {
            return Collections.emptyList();
        }

        default public List<Resource.Blueprint> getFeedResources() {
            return Collections.emptyList();
        }

        default public List<Metric.Blueprint> getFeedMetrics() {
            return Collections.emptyList();
        }

        default public List<Metric.Blueprint> getResourceMetrics(RelativePath rootPath, Resource.Blueprint parentResource) {
            return Collections.emptyList();
        }

        default public DataEntity.Blueprint<?> getConfiguration(RelativePath rootPath, Resource.Blueprint parentResource) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.Resource.configuration);
        }

        default public DataEntity.Blueprint<?> getConnectionConfiguration(RelativePath root, Resource.Blueprint parentResource) {
            return IdentityHash.dummyDataBlueprint((DataRole)DataRole.Resource.connectionConfiguration);
        }
    }
}

