/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;

public final class SwitchElementType
extends Filter {
    private final Relationships.Direction direction;
    private final boolean fromEdge;

    public static SwitchElementType incomingRelationships() {
        return new SwitchElementType(Relationships.Direction.incoming, false);
    }

    public static SwitchElementType outgoingRelationships() {
        return new SwitchElementType(Relationships.Direction.outgoing, false);
    }

    public static SwitchElementType sourceEntities() {
        return new SwitchElementType(Relationships.Direction.incoming, true);
    }

    public static SwitchElementType targetEntities() {
        return new SwitchElementType(Relationships.Direction.outgoing, true);
    }

    public SwitchElementType(Relationships.Direction direction, boolean fromEdge) {
        this.direction = direction;
        this.fromEdge = fromEdge;
    }

    public Relationships.Direction getDirection() {
        return this.direction;
    }

    public boolean isFromEdge() {
        return this.fromEdge;
    }

    public String toString() {
        return "Jump[" + (this.fromEdge ? "from " : "to ") + this.direction.name() + " edges]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchElementType that = (SwitchElementType)o;
        return this.fromEdge == that.fromEdge && this.direction.equals((Object)that.direction);
    }

    public int hashCode() {
        int result = this.direction != null ? this.direction.hashCode() : 0;
        result = 31 * result + (this.fromEdge ? 1 : 0);
        return result;
    }
}

