/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.IdentityHash;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.RelativePath;
import org.junit.Assert;
import org.junit.Test;

public class IdentityHashTest {
    @Test
    public void testMetricTypeHash() throws Exception {
        MetricType.Blueprint mtb = ((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mt")).withUnit(MetricUnit.NONE).build();
        InventoryStructure.Offline structure = InventoryStructure.of((Entity.Blueprint)mtb).build();
        String blueprintHash = IdentityHash.of((InventoryStructure)structure);
        String expectedHash = this.digest(mtb.getId() + mtb.getType() + mtb.getUnit());
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    @Test
    public void testResourceTypeHashWithNoAppendages() throws Exception {
        ResourceType.Blueprint rtb = ((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build();
        InventoryStructure.Offline members = InventoryStructure.of((Entity.Blueprint)rtb).build();
        String blueprintHash = IdentityHash.of((InventoryStructure)members);
        String configSchemaHash = this.digest(DataRole.ResourceType.configurationSchema + "null");
        String connSchemaHash = this.digest(DataRole.ResourceType.connectionConfigurationSchema + "null");
        String expectedHash = this.digest(configSchemaHash + connSchemaHash + rtb.getId());
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    @Test
    public void testResourceTypeHashWithAppendages() throws Exception {
        DataEntity.Blueprint configSchema = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(StructuredData.get().integral(Long.valueOf(5L))).build();
        DataEntity.Blueprint connSchema = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.connectionConfigurationSchema).withValue(((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addUndefined()).build()).build();
        OperationType.Blueprint otb = ((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("op")).build();
        DataEntity.Blueprint retType = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(StructuredData.get().integral(Long.valueOf(42L))).build();
        DataEntity.Blueprint paramTypes = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.parameterTypes).withValue(StructuredData.get().string("answer")).build();
        ResourceType.Blueprint rtb = ((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build();
        InventoryStructure.Offline structure = ((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.of((Entity.Blueprint)rtb).addChild((Entity.Blueprint)configSchema)).addChild((Entity.Blueprint)connSchema)).startChild((Entity.Blueprint)otb).addChild((Entity.Blueprint)retType)).addChild((Entity.Blueprint)paramTypes)).end()).build();
        String configSchemaHash = this.digest("" + DataRole.ResourceType.configurationSchema + configSchema.getValue().toJSON());
        String connSchemaHash = this.digest("" + DataRole.ResourceType.connectionConfigurationSchema + connSchema.getValue().toJSON());
        String returnTypeHash = this.digest("" + DataRole.OperationType.returnType + retType.getValue().toJSON());
        String parameterTypesHash = this.digest("" + DataRole.OperationType.parameterTypes + paramTypes.getValue().toJSON());
        String operationTypeHash = this.digest(returnTypeHash + parameterTypesHash + otb.getId());
        String expectedHash = this.digest(configSchemaHash + connSchemaHash + operationTypeHash + rtb.getId());
        String blueprintHash = IdentityHash.of((InventoryStructure)structure);
        Assert.assertEquals((Object)expectedHash, (Object)blueprintHash);
    }

    @Test
    public void testIdentityHashTree_ResourceTypes() throws Exception {
        DataEntity.Blueprint configSchema = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(StructuredData.get().integral(Long.valueOf(5L))).build();
        DataEntity.Blueprint connSchema = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.connectionConfigurationSchema).withValue(((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addUndefined()).build()).build();
        OperationType.Blueprint otb = ((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("op")).build();
        DataEntity.Blueprint retType = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(StructuredData.get().integral(Long.valueOf(42L))).build();
        DataEntity.Blueprint paramTypes = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.parameterTypes).withValue(StructuredData.get().string("answer")).build();
        ResourceType.Blueprint rtb = ((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build();
        InventoryStructure.Offline structure = ((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.of((Entity.Blueprint)rtb).addChild((Entity.Blueprint)configSchema)).addChild((Entity.Blueprint)connSchema)).startChild((Entity.Blueprint)otb).addChild((Entity.Blueprint)retType)).addChild((Entity.Blueprint)paramTypes)).end()).build();
        String configSchemaHash = this.digest("" + DataRole.ResourceType.configurationSchema + configSchema.getValue().toJSON());
        String connSchemaHash = this.digest("" + DataRole.ResourceType.connectionConfigurationSchema + connSchema.getValue().toJSON());
        String returnTypeHash = this.digest("" + DataRole.OperationType.returnType + retType.getValue().toJSON());
        String parameterTypesHash = this.digest("" + DataRole.OperationType.parameterTypes + paramTypes.getValue().toJSON());
        String operationTypeHash = this.digest(returnTypeHash + parameterTypesHash + otb.getId());
        String resourceTypeHash = this.digest(configSchemaHash + connSchemaHash + operationTypeHash + rtb.getId());
        IdentityHash.Tree treeHash = IdentityHash.treeOf((InventoryStructure)structure);
        Assert.assertEquals((Object)resourceTypeHash, (Object)treeHash.getHash());
        Assert.assertEquals((Object)RelativePath.empty().get(), (Object)treeHash.getPath());
        Assert.assertEquals((long)3L, (long)treeHash.getChildren().size());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().operationType("op").get()).equals((Object)c.getPath())).filter(c -> operationTypeHash.equals(c.getHash())).findFirst().isPresent());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().dataEntity((DataRole)DataRole.ResourceType.configurationSchema).get()).equals((Object)c.getPath())).filter(c -> configSchemaHash.equals(c.getHash())).findFirst().isPresent());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().dataEntity((DataRole)DataRole.ResourceType.connectionConfigurationSchema).get()).equals((Object)c.getPath())).filter(c -> connSchemaHash.equals(c.getHash())).findFirst().isPresent());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().operationType("op").get()).equals((Object)c.getPath())).flatMap(t -> t.getChildren().stream()).filter(c -> ((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().operationType("op").data(DataRole.OperationType.returnType)).get()).equals((Object)c.getPath())).filter(c -> returnTypeHash.equals(c.getHash())).findFirst().isPresent());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().operationType("op").get()).equals((Object)c.getPath())).flatMap(t -> t.getChildren().stream()).filter(c -> ((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().operationType("op").data(DataRole.OperationType.parameterTypes)).get()).equals((Object)c.getPath())).filter(c -> parameterTypesHash.equals(c.getHash())).findFirst().isPresent());
    }

    @Test
    public void testIdentityHashTree_Resources() throws Exception {
        Resource.Blueprint rb = ((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("res")).withResourceTypePath("../rt;RT").build();
        Resource.Blueprint crb = ((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childRes")).withResourceTypePath("../../rt;RT").build();
        DataEntity.Blueprint conf = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(StructuredData.get().integral(Long.valueOf(42L))).build();
        InventoryStructure.Offline structure = ((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.of((Entity.Blueprint)rb).addChild((Entity.Blueprint)conf)).addChild((Entity.Blueprint)crb)).build();
        String confHash = this.digest("" + DataRole.Resource.configuration + conf.getValue().toJSON());
        String dummyConnConfHash = this.digest("" + DataRole.Resource.connectionConfiguration + IdentityHashTest.dummyDataBlueprint(DataRole.Resource.connectionConfiguration).getValue().toJSON());
        String dummyconfHash = this.digest("" + DataRole.Resource.configuration + IdentityHashTest.dummyDataBlueprint(DataRole.Resource.configuration).getValue().toJSON());
        String childHash = this.digest(dummyconfHash + dummyConnConfHash + crb.getId());
        String resourceHash = this.digest(confHash + dummyConnConfHash + childHash + rb.getId());
        IdentityHash.Tree treeHash = IdentityHash.treeOf((InventoryStructure)structure);
        Assert.assertEquals((Object)resourceHash, (Object)treeHash.getHash());
        Assert.assertEquals((Object)RelativePath.empty().get(), (Object)treeHash.getPath());
        Assert.assertEquals((long)3L, (long)treeHash.getChildren().size());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().resource("childRes").get()).equals((Object)c.getPath())).filter(c -> childHash.equals(c.getHash())).findFirst().isPresent());
        Assert.assertTrue((boolean)treeHash.getChildren().stream().filter(c -> ((RelativePath)RelativePath.to().dataEntity((DataRole)DataRole.Resource.configuration).get()).equals((Object)c.getPath())).filter(c -> confHash.equals(c.getHash())).findFirst().isPresent());
    }

    private String digest(String content) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("SHA-1").digest(content.getBytes(Charset.forName("UTF-8")));
        StringBuilder bld = new StringBuilder();
        for (byte b : digest) {
            bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
        }
        return bld.toString();
    }

    private static <R extends DataRole> DataEntity.Blueprint<R> dummyDataBlueprint(R role) {
        return DataEntity.Blueprint.builder().withRole(role).withValue(StructuredData.get().undefined()).build();
    }
}

