/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.paging.PageContext;

public class Page<T>
implements Iterator<T>,
AutoCloseable,
Iterable<T> {
    private Iterator<T> wrapped;
    private final PageContext pageContext;
    private final long totalSize;

    public Page(Iterator<T> wrapped, PageContext pageContext, long totalSize) {
        this.wrapped = wrapped;
        this.pageContext = pageContext;
        this.totalSize = totalSize;
    }

    protected Page(PageContext pageContext, long totalSize) {
        this(null, pageContext, totalSize);
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<T> toList() {
        List ret = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false).collect(Collectors.toList());
        this.close();
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.wrapped != null && this.wrapped.hasNext();
    }

    @Override
    public T next() {
        if (this.wrapped == null) {
            throw new IllegalStateException("the iterator has been already closed");
        }
        Log.LOGGER.trace("Page: Obtaining next element from the wrapped iterator.");
        return this.wrapped.next();
    }

    @Override
    public void close() {
        try {
            if (this.wrapped instanceof Closeable) {
                ((Closeable)((Object)this.wrapped)).close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to close the wrapped result iterator.", e);
        }
        finally {
            this.wrapped = null;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

