/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleIdentityHashedFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;

public final class BaseOperationTypes {
    private BaseOperationTypes() {
    }

    private static class OperationTypeDataModificationChecks<BE>
    implements BaseData.DataModificationChecks<BE> {
        private final TraversalContext<BE, ?> context;

        private OperationTypeDataModificationChecks(TraversalContext<BE, ?> context) {
            this.context = context;
        }

        @Override
        public void preCreate(DataEntity.Blueprint blueprint, Transaction<BE> transaction) {
            BE mp = transaction.querySingle(this.context.select().path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                BE ot = transaction.querySingle(this.context.select().get());
                throw new IllegalArgumentException("Data '" + blueprint.getId() + "' cannot be created" + " under operation type " + transaction.extractCanonicalPath(ot) + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void preUpdate(BE dataEntity, DataEntity.Update update, Transaction<BE> tx) {
            if (update.getValue() == null) {
                return;
            }
            BE mp = tx.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                CanonicalPath dataPath = tx.extractCanonicalPath(dataEntity);
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be updated" + " under operation type " + dataPath.up() + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postUpdate(BE dataEntity, Transaction<BE> tx) {
        }

        @Override
        public void preDelete(BE dataEntity, Transaction<BE> tx) {
            CanonicalPath dataPath = tx.extractCanonicalPath(dataEntity);
            Object ot = null;
            try {
                ot = tx.find(dataPath.up());
            }
            catch (ElementNotFoundException e) {
                Fetcher.throwNotFoundException(this.context);
            }
            if (ReadWrite.isResourceTypeInMetadataPack(ot, tx)) {
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be deleted" + " under operation type " + dataPath.up() + ", because the owning resource type is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postCreate(BE dataEntity, Transaction<BE> tx) {
        }

        @Override
        public void postDelete(BE dataEntity, Transaction<BE> tx) {
        }
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.Multiple {
        public Multiple(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.Read<DataRole.OperationType> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new OperationTypeDataModificationChecks(this.context));
        }
    }

    public static class Single<BE>
    extends SingleIdentityHashedFetcher<BE, OperationType, OperationType.Blueprint, OperationType.Update>
    implements OperationTypes.Single {
        public Single(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.ReadWrite<DataRole.OperationType> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new OperationTypeDataModificationChecks(this.context));
        }

        @Override
        protected void preDelete(BE deletedEntity, Transaction<BE> transaction) {
            if (ReadWrite.isResourceTypeInMetadataPack(deletedEntity, transaction)) {
                throw new IllegalArgumentException("Cannot delete an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.ReadContained {
        public ReadContained(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, OperationType, OperationType.Blueprint, OperationType.Update, String>
    implements OperationTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Transaction<BE> tx, OperationType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<BE, OperationType> wireUpNewEntity(BE entity, OperationType.Blueprint blueprint, CanonicalPath parentPath, BE parent, Transaction<BE> tx) {
            return new EntityAndPendingNotifications<BE, OperationType>(entity, new OperationType(blueprint.getName(), parentPath.extend(OperationType.SEGMENT_TYPE, tx.extractId(entity)).get(), null, blueprint.getProperties()), Collections.emptyList());
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public OperationTypes.Single create(OperationType.Blueprint blueprint, boolean cache) throws EntityAlreadyExistsException {
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint), cache));
        }

        @Override
        protected void preCreate(OperationType.Blueprint blueprint, Transaction<BE> tx) {
            if (tx.traverseToSingle(this.getParent(tx), Query.path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null) {
                throw new IllegalArgumentException("Cannot create an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
        }

        @Override
        protected void preDelete(String s, BE entityRepresentation, Transaction<BE> tx) {
            if (ReadWrite.isResourceTypeInMetadataPack(entityRepresentation, tx)) {
                throw new IllegalArgumentException("Cannot delete an operation type of resource type included in a meta data pack. This would invalidate the metadata pack's identity.");
            }
        }

        private static <BE> boolean isResourceTypeInMetadataPack(BE operationType, Transaction<BE> tx) {
            return tx.traverseToSingle(operationType, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null;
        }
    }
}

