/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public interface InventoryStructure<Root extends Entity.Blueprint> {
    public static <E extends Entity<B, ?>, B extends Entity.Blueprint> InventoryStructure<B> of(final E rootEntity, final Inventory inventory) {
        return new InventoryStructure<B>(){
            B root;
            {
                this.root = (Entity.Blueprint)this.asBlueprint(rootEntity);
            }

            @Override
            public B getRoot() {
                return this.root;
            }

            @Override
            public <EE extends Entity<? extends BB, ?>, BB extends Blueprint> Stream<BB> getChildren(RelativePath parent, Class<EE> childType) {
                final CanonicalPath absoluteParent = rootEntity.getPath().modified().extend((Collection)parent.getPath()).get();
                final SegmentType parentType = absoluteParent.getSegment().getElementType();
                SegmentType childSegment = SegmentType.fromElementType(childType);
                return (Stream)ElementTypeVisitor.accept((SegmentType)childSegment, (ElementTypeVisitor)new ElementTypeVisitor<Stream<BB>, Void>(){

                    public Stream<BB> visitTenant(Void parameter) {
                        if (absoluteParent.isDefined()) {
                            return Stream.empty();
                        }
                        return this.fromRead(inventory.tenants());
                    }

                    public Stream<BB> visitEnvironment(Void parameter) {
                        return this.fromRead(Tenant.class, Tenants.Single.class, Environments.Container::environments);
                    }

                    public Stream<BB> visitFeed(Void parameter) {
                        return this.fromRead(Tenant.class, Tenants.Single.class, Feeds.Container::feeds);
                    }

                    public Stream<BB> visitMetric(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitEnvironment(Void parameter) {
                                return this.fromRead(Environment.class, Environments.Single.class, Metrics.Container::metrics);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, Metrics.Container::metrics);
                            }

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Metrics.Container::metrics);
                            }
                        }, null);
                    }

                    public Stream<BB> visitMetricType(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitTenant(Void parameter) {
                                return this.fromRead(Tenant.class, Tenants.Single.class, MetricTypes.Container::metricTypes);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, MetricTypes.Container::metricTypes);
                            }
                        }, null);
                    }

                    public Stream<BB> visitResource(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitEnvironment(Void parameter) {
                                return this.fromRead(Environment.class, Environments.Single.class, Resources.Container::resources);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, Resources.Container::resources);
                            }

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Resources.Container::resources);
                            }
                        }, null);
                    }

                    public Stream<BB> visitResourceType(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitTenant(Void parameter) {
                                return this.fromRead(Tenant.class, Tenants.Single.class, ResourceTypes.Container::resourceTypes);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, ResourceTypes.Container::resourceTypes);
                            }
                        }, null);
                    }

                    public Stream<BB> visitRelationship(Void parameter) {
                        return Stream.empty();
                    }

                    public Stream<BB> visitData(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Data.Container::data);
                            }

                            public Stream<BB> visitResourceType(Void parameter) {
                                return this.fromRead(ResourceType.class, ResourceTypes.Single.class, Data.Container::data);
                            }

                            public Stream<BB> visitOperationType(Void parameter) {
                                return this.fromRead(OperationType.class, OperationTypes.Single.class, Data.Container::data);
                            }
                        }, null);
                    }

                    public Stream<BB> visitOperationType(Void parameter) {
                        return this.fromRead(ResourceType.class, ResourceTypes.Single.class, OperationTypes.Container::operationTypes);
                    }

                    public Stream<BB> visitMetadataPack(Void parameter) {
                        return this.fromRead(Tenant.class, Tenants.Single.class, MetadataPacks.Container::metadataPacks);
                    }

                    public Stream<BB> visitUnknown(Void parameter) {
                        throw new IllegalStateException("Unhandled type of entity in inventory structure: " + parentType);
                    }

                    private <P extends Entity<?, PU>, PA extends ResolvableToSingle<P, PU>, PU extends Entity.Update, X extends Entity<XB, ?>, XB extends Blueprint> Stream<BB> fromRead(Class<P> parentType2, Class<PA> parentAccessType, Function<PA, ResolvingToMultiple<? extends ResolvableToMany<X>>> childAccessSupplier) {
                        Class<AbstractElement<?, ?>> parentSegmentType = AbstractElement.toElementClass(absoluteParent.getSegment().getElementType());
                        if (!absoluteParent.isDefined() || !parentType2.equals(parentSegmentType)) {
                            return Stream.empty();
                        }
                        PA parentAccess = inventory.inspect(absoluteParent, parentAccessType);
                        return this.fromRead(childAccessSupplier.apply(parentAccess));
                    }

                    private <X extends Entity<XB, ?>, XB extends Blueprint> Stream<BB> fromRead(ResolvingToMultiple<? extends ResolvableToMany<X>> read) {
                        Page<X> it = read.getAll(new Filter[0]).entities(Pager.none());
                        Spliterator<X> sit = Spliterators.spliterator(it, Long.MAX_VALUE, 0);
                        return StreamSupport.stream(sit, false).map(e -> this.asBlueprint(e));
                    }
                }, null);
            }

            @Override
            public Blueprint get(RelativePath path) {
                CanonicalPath pathToElement = rootEntity.getPath().modified().extend((Collection)path.getPath()).get();
                Entity entity = (Entity)inventory.inspect(pathToElement, ResolvableToSingle.class).entity();
                return this.asBlueprint(entity);
            }

            private <BB extends Blueprint> BB asBlueprint(Entity<BB, ?> entity) {
                if (entity == null) {
                    return null;
                }
                return (BB)((Blueprint)entity.accept(new ElementVisitor<BB, Void>(){

                    @Override
                    public BB visitData(DataEntity data, Void parameter) {
                        return this.fillCommon(data, new DataEntity.Blueprint.Builder()).withRole(data.getRole()).withValue(data.getValue()).build();
                    }

                    @Override
                    public BB visitTenant(Tenant tenant, Void parameter) {
                        return this.fillCommon(tenant, new Tenant.Blueprint.Builder()).build();
                    }

                    @Override
                    public BB visitEnvironment(Environment environment, Void parameter) {
                        return this.fillCommon(environment, new Environment.Blueprint.Builder()).build();
                    }

                    @Override
                    public BB visitFeed(Feed feed, Void parameter) {
                        return this.fillCommon(feed, Feed.Blueprint.builder()).build();
                    }

                    @Override
                    public BB visitMetric(Metric metric, Void parameter) {
                        RelativePath metricTypePath = metric.getType().getPath().relativeTo(metric.getPath());
                        return this.fillCommon(metric, Metric.Blueprint.builder()).withInterval(metric.getCollectionInterval()).withMetricTypePath(metricTypePath.toString()).build();
                    }

                    @Override
                    public BB visitMetricType(MetricType type, Void parameter) {
                        return this.fillCommon(type, MetricType.Blueprint.builder(type.getType())).withInterval(type.getCollectionInterval()).withUnit(type.getUnit()).build();
                    }

                    @Override
                    public BB visitOperationType(OperationType operationType, Void parameter) {
                        return this.fillCommon(operationType, OperationType.Blueprint.builder()).build();
                    }

                    @Override
                    public BB visitMetadataPack(MetadataPack metadataPack, Void parameter) {
                        MetadataPack.Blueprint.Builder bld = (MetadataPack.Blueprint.Builder)MetadataPack.Blueprint.builder().withName(metadataPack.getName()).withProperties(metadataPack.getProperties());
                        ((MetricTypes.Multiple)inventory.inspect(metadataPack).metricTypes().getAll(new Filter[0])).entities(Pager.none()).forEachRemaining(e -> bld.withMember(e.getPath()));
                        ((ResourceTypes.Multiple)inventory.inspect(metadataPack).resourceTypes().getAll(new Filter[0])).entities(Pager.none()).forEachRemaining(e -> bld.withMember(e.getPath()));
                        return bld.build();
                    }

                    @Override
                    public BB visitUnknown(Object entity, Void parameter) {
                        throw new IllegalStateException("Unhandled entity type during conversion to blueprint: " + entity.getClass());
                    }

                    @Override
                    public BB visitResource(Resource resource, Void parameter) {
                        RelativePath resourceTypePath = resource.getType().getPath().relativeTo(resource.getPath());
                        return this.fillCommon(resource, Resource.Blueprint.builder()).withResourceTypePath(resourceTypePath.toString()).build();
                    }

                    @Override
                    public BB visitResourceType(ResourceType type, Void parameter) {
                        return this.fillCommon(type, ResourceType.Blueprint.builder()).build();
                    }

                    @Override
                    public BB visitRelationship(Relationship relationship, Void parameter) {
                        throw new IllegalArgumentException("Inventory structure blueprint conversion does not handle relationships.");
                    }

                    private <X extends Entity<? extends XB, ?>, XB extends Entity.Blueprint, XBB extends Entity.Blueprint.Builder<XB, XBB>> XBB fillCommon(X entity, XBB bld) {
                        return (XBB)((Entity.Blueprint.Builder)((AbstractElement.Blueprint.Builder)((Entity.Blueprint.Builder)bld.withId(entity.getId())).withName(entity.getName())).withProperties(entity.getProperties()));
                    }
                }, null));
            }
        };
    }

    public static <B extends Entity.Blueprint> Builder<B> of(B root) {
        return Offline.of(root);
    }

    public Root getRoot();

    public <E extends Entity<? extends B, ?>, B extends Blueprint> Stream<B> getChildren(RelativePath var1, Class<E> var2);

    public Blueprint get(RelativePath var1);

    default public Stream<Entity.Blueprint> getAllChildren(RelativePath parent) {
        Stream<Entity.Blueprint> ret = Stream.empty();
        RelativePath.Extender check = RelativePath.empty().extend(Blueprint.getSegmentTypeOf(this.getRoot()), ((Entity.Blueprint)this.getRoot()).getId()).extend((Collection)parent.getPath());
        for (SegmentType st : SegmentType.values()) {
            if (st == SegmentType.rl || !st.isAllowedInCanonical() || !check.canExtendTo(st).booleanValue()) continue;
            Stream next = this.getChildren(parent, Entity.entityTypeFromSegmentType(st));
            ret = Stream.concat(ret, next);
        }
        return ret;
    }

    public static class ChildBuilder<ParentBuilder extends AbstractBuilder<?>>
    extends AbstractBuilder<ChildBuilder<ParentBuilder>> {
        protected final ParentBuilder parentBuilder;

        private ChildBuilder(ParentBuilder parentBuilder, RelativePath parent, Map<RelativePath, Entity.Blueprint> blueprints, Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children) {
            super(parent, blueprints, children);
            this.parentBuilder = parentBuilder;
        }

        public ParentBuilder end() {
            return this.parentBuilder;
        }

        public ParentBuilder remove() {
            this.removeAllChildren();
            Set<Entity.Blueprint> siblings = this.getSiblings();
            Entity.Blueprint myBlueprint = (Entity.Blueprint)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            return this.parentBuilder;
        }

        @Override
        protected void doReplace(Entity.Blueprint blueprint) {
            Set<Entity.Blueprint> siblings = this.getSiblings();
            Entity.Blueprint myBlueprint = (Entity.Blueprint)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            siblings.add(blueprint);
            this.children.remove(this.myPath);
            this.myPath = ((AbstractBuilder)this.parentBuilder).myPath.modified().extend(Blueprint.getSegmentTypeOf(blueprint), blueprint.getId()).get();
            this.blueprints.put(this.myPath, blueprint);
        }

        private Set<Entity.Blueprint> getSiblings() {
            Entity.Blueprint myBlueprint = (Entity.Blueprint)this.blueprints.get(this.myPath);
            Map siblingsByType = (Map)this.children.get(((AbstractBuilder)this.parentBuilder).myPath);
            EntityType myType = EntityType.of(Blueprint.getEntityTypeOf(myBlueprint));
            return (Set)siblingsByType.get((Object)myType);
        }

        /* synthetic */ ChildBuilder(AbstractBuilder x0, RelativePath x1, Map x2, Map x3, 1 x4) {
            this(x0, x1, (Map<RelativePath, Entity.Blueprint>)x2, x3);
        }
    }

    public static class Builder<Root extends Entity.Blueprint>
    extends AbstractBuilder<Builder<Root>> {
        private final Root root;

        private Builder(Root root, RelativePath myPath, Map<RelativePath, Entity.Blueprint> blueprints, Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children) {
            super(myPath, blueprints, children);
            this.root = root;
            this.blueprints.put(RelativePath.empty().get(), root);
        }

        public Builder(Root root) {
            this(root, RelativePath.empty().get(), new HashMap<RelativePath, Entity.Blueprint>(), new HashMap<RelativePath, Map<EntityType, Set<Entity.Blueprint>>>());
        }

        public Offline<Root> build() {
            return new Offline((Entity.Blueprint)this.root, this.blueprints, this.children, null);
        }

        @Override
        protected void doReplace(Entity.Blueprint blueprint) {
            this.blueprints.put(this.myPath, blueprint);
            this.children.remove(this.myPath);
        }

        /* synthetic */ Builder(Entity.Blueprint x0, RelativePath x1, Map x2, Map x3, 1 x4) {
            this(x0, x1, (Map<RelativePath, Entity.Blueprint>)x2, x3);
        }
    }

    public static abstract class AbstractBuilder<This extends AbstractBuilder<?>> {
        protected RelativePath myPath;
        protected final Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children;
        protected final Map<RelativePath, Entity.Blueprint> blueprints;

        private AbstractBuilder(RelativePath myPath, Map<RelativePath, Entity.Blueprint> blueprints, Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children) {
            this.myPath = myPath;
            this.children = children;
            this.blueprints = blueprints;
        }

        public ChildBuilder<This> startChild(Entity.Blueprint child) {
            RelativePath.Extender extender = this.myPath.modified();
            Class childType = Blueprint.getEntityTypeOf(child);
            SegmentType childSeg = Blueprint.getSegmentTypeOf(child);
            if (!extender.canExtendTo(childSeg).booleanValue()) {
                throw new IllegalArgumentException("Cannot extend path " + this.myPath + " with child of type " + childType);
            }
            RelativePath childPath = extender.extend(childSeg, child.getId()).get();
            Set<Entity.Blueprint> bls = this.getChildrenOfType(EntityType.of(childType));
            bls.add(child);
            this.blueprints.put(childPath, child);
            return new ChildBuilder((AbstractBuilder)this.castThis(), childPath, this.blueprints, this.children, null);
        }

        public ChildBuilder<This> getChild(Path.Segment childPath) {
            Map<EntityType, Set<Entity.Blueprint>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return null;
            }
            EntityType childType = EntityType.of(childPath.getElementType());
            Set<Entity.Blueprint> childrenOfType = myChildren.get((Object)childType);
            return childrenOfType.stream().filter(child -> child.getId().equals(childPath.getElementId())).findAny().map(child -> {
                RelativePath cp = this.myPath.modified().extend(childPath).get();
                return new ChildBuilder((AbstractBuilder)this.castThis(), cp, this.blueprints, this.children, null);
            }).orElse(null);
        }

        public This removeChild(Path.Segment childPath) {
            ChildBuilder<This> childBuilder = this.getChild(childPath);
            if (childBuilder != null) {
                childBuilder.remove();
            }
            return this.castThis();
        }

        public Set<Path.Segment> getChildrenPaths() {
            Map<EntityType, Set<Entity.Blueprint>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return Collections.emptySet();
            }
            return myChildren.values().stream().flatMap(Collection::stream).map(b -> new Path.Segment(Blueprint.getSegmentTypeOf(b), b.getId())).collect(Collectors.toSet());
        }

        public This removeAllChildren() {
            this.getChildrenPaths().forEach(this::removeChild);
            this.children.remove(this.myPath);
            return this.castThis();
        }

        public This replace(Entity.Blueprint blueprint) {
            this.removeAllChildren();
            Entity.Blueprint myBl = this.blueprints.get(this.myPath);
            if (!myBl.getClass().equals(blueprint.getClass())) {
                throw new IllegalArgumentException("Blueprint " + blueprint + " not of the same type as " + myBl);
            }
            this.doReplace(blueprint);
            return this.castThis();
        }

        protected abstract void doReplace(Entity.Blueprint var1);

        protected Set<Entity.Blueprint> getChildrenOfType(EntityType childType) {
            Set<Entity.Blueprint> bls;
            Map<EntityType, Set<Entity.Blueprint>> cs = this.children.get(this.myPath);
            if (cs == null) {
                cs = new EnumMap<EntityType, Set<Entity.Blueprint>>(EntityType.class);
                this.children.put(this.myPath, cs);
            }
            if ((bls = cs.get((Object)childType)) == null) {
                bls = new HashSet<Entity.Blueprint>();
                cs.put(childType, bls);
            }
            return bls;
        }

        public This addChild(Entity.Blueprint child) {
            this.startChild(child).end();
            return this.castThis();
        }

        protected This castThis() {
            return (This)this;
        }
    }

    @ApiModel(value="InventoryStructure")
    public static class Offline<Root extends Entity.Blueprint>
    implements InventoryStructure<Root>,
    Serializable {
        private final Root root;
        private final Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children;
        private final Map<RelativePath, Entity.Blueprint> entities;

        private Offline(Root root, Map<RelativePath, Entity.Blueprint> entities, Map<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children) {
            this.root = root;
            this.children = children;
            this.entities = entities;
        }

        public static <R extends Entity.Blueprint> Offline<R> copy(final InventoryStructure<R> other) {
            final HashMap entities = new HashMap();
            ElementTypeVisitor.Simple<Void, RelativePath.Extender> visitor = new ElementTypeVisitor.Simple<Void, RelativePath.Extender>(){

                protected Void defaultAction(SegmentType elementType, RelativePath.Extender parentPath) {
                    Class<?> childType = Entity.typeFromSegmentType(elementType);
                    this.impl(childType, parentPath);
                    return null;
                }

                private <E extends Entity<B, ?>, B extends Entity.Blueprint> void impl(Class<E> childType, RelativePath.Extender parent) {
                    SegmentType childSeg = Entity.segmentTypeFromType(childType);
                    if (parent.canExtendTo(childSeg).booleanValue()) {
                        Stream otherChildren = other.getChildren(parent.get(), childType);
                        RelativePath parentPath = parent.get();
                        EntityAndChildren parentChildren = (EntityAndChildren)entities.get(parentPath);
                        if (parentChildren == null) {
                            if (parentPath.isDefined()) {
                                throw new IllegalStateException("Could not find the tracked children of a parent " + parent + " during inventory structure copy. This is a " + "bug.");
                            }
                            parentChildren = new EntityAndChildren((Entity.Blueprint)other.getRoot());
                            entities.put(parentPath, parentChildren);
                        }
                        otherChildren.forEach(c -> {
                            RelativePath.Extender childPath = parentPath.modified().extend(childSeg, c.getId());
                            RelativePath cp = childPath.get();
                            EntityAndChildren childChildren = (EntityAndChildren)entities.get(cp);
                            if (childChildren == null) {
                                childChildren = new EntityAndChildren((Entity.Blueprint)c);
                                entities.put(cp, childChildren);
                            }
                            ElementTypeVisitor.accept((SegmentType)childSeg, (ElementTypeVisitor)this, (Object)childPath);
                        });
                    }
                }
            };
            R root = other.getRoot();
            RelativePath empty = RelativePath.empty().get();
            other.getAllChildren(empty).forEach(arg_0 -> Offline.lambda$copy$66((ElementTypeVisitor)visitor, empty, arg_0));
            HashMap<RelativePath, Map<EntityType, Set<Entity.Blueprint>>> children = new HashMap<RelativePath, Map<EntityType, Set<Entity.Blueprint>>>();
            HashMap<RelativePath, Entity.Blueprint> blueprints = new HashMap<RelativePath, Entity.Blueprint>();
            for (Map.Entry e : entities.entrySet()) {
                HashSet<Entity.Blueprint> childrenBlueprints;
                RelativePath entityPath = (RelativePath)e.getKey();
                EntityAndChildren entity = (EntityAndChildren)e.getValue();
                blueprints.put(entityPath, entity.entity);
                RelativePath parent = entityPath.up();
                EntityType entityType = EntityType.of(Blueprint.getEntityTypeOf(entity.entity));
                HashMap<EntityType, HashSet<Entity.Blueprint>> childrenByType = (HashMap<EntityType, HashSet<Entity.Blueprint>>)children.get(parent);
                if (childrenByType == null) {
                    childrenByType = new HashMap<EntityType, HashSet<Entity.Blueprint>>();
                    children.put(parent, childrenByType);
                }
                if ((childrenBlueprints = (HashSet<Entity.Blueprint>)childrenByType.get((Object)entityType)) == null) {
                    childrenBlueprints = new HashSet<Entity.Blueprint>();
                    childrenByType.put(entityType, childrenBlueprints);
                }
                childrenBlueprints.add(entity.entity);
            }
            return new Offline<R>(root, blueprints, children);
        }

        public Builder<Root> asBuilder() {
            return new Builder((Entity.Blueprint)this.root, RelativePath.empty().get(), this.entities, this.children, null);
        }

        public static <R extends Entity.Blueprint> Builder<R> of(R root) {
            return new Builder<R>(root);
        }

        @Override
        public Root getRoot() {
            return this.root;
        }

        @Override
        public <E extends Entity<? extends B, ?>, B extends Blueprint> Stream<B> getChildren(RelativePath parent, Class<E> childType) {
            return this.children.getOrDefault(parent, Collections.emptyMap()).getOrDefault((Object)EntityType.of(childType), Collections.emptySet()).stream();
        }

        @Override
        public Blueprint get(RelativePath path) {
            return this.entities.get(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offline offline = (Offline)o;
            if (!((Entity.Blueprint)this.root).equals(offline.root)) {
                return false;
            }
            if (!this.children.equals(offline.children)) {
                return false;
            }
            return this.entities.equals(offline.entities);
        }

        public int hashCode() {
            int result = ((Entity.Blueprint)this.root).hashCode();
            result = 31 * result + this.children.hashCode();
            result = 31 * result + this.entities.hashCode();
            return result;
        }

        private static /* synthetic */ void lambda$copy$66(ElementTypeVisitor elementTypeVisitor, RelativePath relativePath, Entity.Blueprint b) {
            Void cfr_ignored_0 = (Void)ElementTypeVisitor.accept((SegmentType)Blueprint.getSegmentTypeOf(b), (ElementTypeVisitor)elementTypeVisitor, (Object)relativePath.modified());
        }

        /* synthetic */ Offline(Entity.Blueprint x0, Map x1, Map x2, 1 x3) {
            this(x0, x1, x2);
        }

        private static final class EntityAndChildren {
            final Map<Class<?>, Map<String, Entity.Blueprint>> children = new HashMap();
            Entity.Blueprint entity;

            EntityAndChildren(Entity.Blueprint entity) {
                this.entity = entity;
            }
        }
    }

    public static enum EntityType {
        feed(Feed.class, Feed.Blueprint.class, SegmentType.f),
        resourceType(ResourceType.class, ResourceType.Blueprint.class, SegmentType.rt),
        metricType(MetricType.class, MetricType.Blueprint.class, SegmentType.mt),
        operationType(OperationType.class, OperationType.Blueprint.class, SegmentType.ot),
        metric(Metric.class, Metric.Blueprint.class, SegmentType.m),
        resource(Resource.class, Resource.Blueprint.class, SegmentType.r),
        dataEntity(DataEntity.class, DataEntity.Blueprint.class, SegmentType.d);

        public final Class<? extends Entity<?, ?>> elementType;
        public final Class<? extends Entity.Blueprint> blueprintType;
        public final SegmentType segmentType;

        public static EntityType of(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.elementType)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of entity: " + type);
        }

        public static EntityType of(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of path segment: " + seg);
        }

        public static boolean supports(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return true;
            }
            return false;
        }

        public static EntityType ofBlueprint(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.blueprintType)) continue;
                return t;
            }
            return null;
        }

        private EntityType(Class<? extends Entity<?, ?>> elementType, Class<? extends Entity.Blueprint> blueprintType, SegmentType segmentType) {
            this.elementType = elementType;
            this.blueprintType = blueprintType;
            this.segmentType = segmentType;
        }
    }
}

