/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.SegmentType;

public final class MetadataPack
extends Entity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.mp;

    public static boolean canIncorporate(CanonicalPath entityPath) {
        SegmentType entityType = entityPath.getSegment().getElementType();
        SegmentType parentType = entityPath.up().getSegment().getElementType();
        return SegmentType.t.equals((Object)parentType) && (SegmentType.rt.equals((Object)entityType) || SegmentType.mt.equals((Object)entityType));
    }

    private MetadataPack() {
    }

    public MetadataPack(CanonicalPath path) {
        this(path, null);
    }

    public MetadataPack(CanonicalPath path, Map<String, Object> properties) {
        this(null, path, properties);
    }

    public MetadataPack(String name, CanonicalPath path) {
        this(name, path, null);
    }

    public MetadataPack(String name, CanonicalPath path, Map<String, Object> properties) {
        super(name, path, properties);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetadataPack(this, parameter);
    }

    @Override
    public AbstractElement.Updater<Update, MetadataPack> update() {
        return new AbstractElement.Updater<Update, MetadataPack>(u -> new MetadataPack(this.getPath(), u.getProperties()));
    }

    @ApiModel(value="MetadataPackUpdate")
    public static final class Update
    extends Entity.Update {
        public static Builder builder() {
            return new Builder();
        }

        public Update(Map<String, Object> properties) {
            super(null, properties);
        }

        public Update(String name, Map<String, Object> properties) {
            super(name, properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetadataPack(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }

    @ApiModel(value="MetadataPackBlueprint")
    public static final class Blueprint
    extends AbstractElement.Blueprint {
        private final Set<CanonicalPath> members;
        private final String name;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            super(null);
            this.members = Collections.emptySet();
            this.name = null;
        }

        public Blueprint(String name, Set<CanonicalPath> members, Map<String, Object> properties) {
            super(properties);
            this.name = name;
            members.forEach(p -> {
                if (!MetadataPack.canIncorporate(p)) {
                    throw new IllegalArgumentException("Entity on path '" + p + "' cannot be part of a metadata pack.");
                }
            });
            this.members = Collections.unmodifiableSet(new HashSet<CanonicalPath>(members));
        }

        public String getName() {
            return this.name;
        }

        public Set<CanonicalPath> getMembers() {
            return this.members;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetadataPack(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private final Set<CanonicalPath> members = new HashSet<CanonicalPath>();
            private String name;

            @Override
            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            public Builder withMember(CanonicalPath path) {
                if (!MetadataPack.canIncorporate(path)) {
                    throw new IllegalArgumentException("A metadata pack cannot incorporate entity on the path: " + path);
                }
                this.members.add(path);
                return this;
            }

            public Builder withMembers(Iterable<CanonicalPath> paths) {
                paths.forEach(this::withMember);
                return this;
            }

            public Builder withMembers(CanonicalPath ... paths) {
                return this.withMembers(Arrays.asList(paths));
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.name, this.members, this.properties);
            }
        }
    }

    public static final class Members {
        private final List<ResourceType.Blueprint> resourceTypes;
        private final List<MetricType.Blueprint> metricTypes;
        private final IdentityHashMap<ResourceType.Blueprint, List<OperationType.Blueprint>> operations;
        private final IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> returnTypes;
        private final IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> parameterTypes;
        private final IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> configurationSchemas;
        private final IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> connectionConfigurationSchemas;

        public static Builder builder() {
            return new Builder();
        }

        private Members(Set<ResourceType.Blueprint> resourceTypes, Set<MetricType.Blueprint> metricTypes, IdentityHashMap<ResourceType.Blueprint, Set<OperationType.Blueprint>> operations, IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> returnTypes, IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> parameterTypes, IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> configurationSchemas, IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> connectionConfigurationSchemas) {
            this.resourceTypes = new ArrayList<ResourceType.Blueprint>(resourceTypes);
            Comparator idComp = (a, b) -> a.getId().compareTo(b.getId());
            Collections.sort(this.resourceTypes, idComp);
            this.metricTypes = new ArrayList<MetricType.Blueprint>(metricTypes);
            Collections.sort(this.metricTypes, idComp);
            this.operations = new IdentityHashMap();
            operations.forEach((k, v) -> {
                ArrayList ops = new ArrayList(v);
                Collections.sort(ops, idComp);
                this.operations.put((ResourceType.Blueprint)k, ops);
            });
            this.returnTypes = returnTypes;
            this.parameterTypes = parameterTypes;
            this.configurationSchemas = configurationSchemas;
            this.connectionConfigurationSchemas = connectionConfigurationSchemas;
        }

        public List<ResourceType.Blueprint> getResourceTypes() {
            return this.resourceTypes;
        }

        public List<MetricType.Blueprint> getMetricTypes() {
            return this.metricTypes;
        }

        public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint resourceType) {
            return this.operations.getOrDefault(resourceType, Collections.emptyList());
        }

        public DataEntity.Blueprint<?> getReturnType(OperationType.Blueprint operationType) {
            return this.thatOrEmpty(this.returnTypes.get(operationType), (DataRole)DataRole.OperationType.returnType);
        }

        public DataEntity.Blueprint<?> getParameterTypes(OperationType.Blueprint operationType) {
            return this.thatOrEmpty(this.parameterTypes.get(operationType), (DataRole)DataRole.OperationType.parameterTypes);
        }

        public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
            return this.thatOrEmpty(this.configurationSchemas.get(rt), (DataRole)DataRole.ResourceType.configurationSchema);
        }

        public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
            return this.thatOrEmpty(this.connectionConfigurationSchemas.get(rt), (DataRole)DataRole.ResourceType.connectionConfigurationSchema);
        }

        private DataEntity.Blueprint<?> thatOrEmpty(DataEntity.Blueprint<?> b, DataRole role) {
            if (b == null) {
                b = DataEntity.Blueprint.builder().withRole(role).build();
            }
            return b;
        }

        public static final class Builder {
            private final Set<ResourceType.Blueprint> resourceTypes = new HashSet<ResourceType.Blueprint>();
            private final Set<MetricType.Blueprint> metricTypes = new HashSet<MetricType.Blueprint>();
            private final IdentityHashMap<ResourceType.Blueprint, Set<OperationType.Blueprint>> resourceTypeOperationTypes = new IdentityHashMap();
            private final IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> operationTypeReturnType = new IdentityHashMap();
            private final IdentityHashMap<OperationType.Blueprint, DataEntity.Blueprint<?>> operationTypeParameterTypes = new IdentityHashMap();
            private final IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> resourceTypeConfigurationSchemas = new IdentityHashMap();
            private final IdentityHashMap<ResourceType.Blueprint, DataEntity.Blueprint<?>> resourceTypeConnectionConfigurationSchemas = new IdentityHashMap();

            public ResourceTypeBuilder with(ResourceType.Blueprint rt) {
                this.resourceTypes.add(rt);
                return new ResourceTypeBuilder(rt);
            }

            public Builder with(MetricType.Blueprint mt) {
                this.metricTypes.add(mt);
                return this;
            }

            public Members build() {
                return new Members(this.resourceTypes, this.metricTypes, this.resourceTypeOperationTypes, this.operationTypeReturnType, this.operationTypeParameterTypes, this.resourceTypeConfigurationSchemas, this.resourceTypeConnectionConfigurationSchemas);
            }

            public final class ResourceTypeBuilder {
                private final ResourceType.Blueprint rt;

                private ResourceTypeBuilder(ResourceType.Blueprint rt) {
                    this.rt = rt;
                }

                public OperationTypeBuilder with(OperationType.Blueprint ot) {
                    HashSet<OperationType.Blueprint> ots = (HashSet<OperationType.Blueprint>)Builder.this.resourceTypeOperationTypes.get(this.rt);
                    if (ots == null) {
                        ots = new HashSet<OperationType.Blueprint>();
                        Builder.this.resourceTypeOperationTypes.put(this.rt, ots);
                    }
                    ots.add(ot);
                    return new OperationTypeBuilder(ot);
                }

                public ResourceTypeBuilder with(DataEntity.Blueprint<DataRole.ResourceType> data) {
                    switch (data.getRole()) {
                        case configurationSchema: {
                            Builder.this.resourceTypeConfigurationSchemas.put(this.rt, data);
                            break;
                        }
                        case connectionConfigurationSchema: {
                            Builder.this.resourceTypeConnectionConfigurationSchemas.put(this.rt, data);
                        }
                    }
                    return this;
                }

                public Builder done() {
                    return Builder.this;
                }

                public final class OperationTypeBuilder {
                    private final OperationType.Blueprint ot;

                    private OperationTypeBuilder(OperationType.Blueprint ot) {
                        this.ot = ot;
                    }

                    public OperationTypeBuilder with(DataEntity.Blueprint<DataRole.OperationType> data) {
                        switch (data.getRole()) {
                            case returnType: {
                                Builder.this.operationTypeReturnType.put(this.ot, data);
                                break;
                            }
                            case parameterTypes: {
                                Builder.this.operationTypeParameterTypes.put(this.ot, data);
                            }
                        }
                        return this;
                    }

                    public ResourceTypeBuilder done() {
                        return ResourceTypeBuilder.this;
                    }
                }
            }
        }
    }
}

