/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.util.Arrays;
import java.util.HashSet;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InventoryStructureOfflineBuilderTest {
    private InventoryStructure.Builder<Feed.Blueprint> structure;

    @Before
    public void setup() {
        this.structure = (InventoryStructure.Builder)((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.Offline.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).addChild((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).addChild((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).startChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build()).addChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childResource")).withResourceTypePath("../resourceType").build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withInterval(Long.valueOf(0L)).withMetricTypePath("../metricType").build())).end()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("metricType").withInterval(Long.valueOf(0L)).build());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCantAddInvalidChildren() throws Exception {
        ((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)this.structure.getChild(Path.Segment.from((String)"rt;resourceType")).addChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("../resoureType").withId("asdf")).build())).end()).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCantReplaceWithInvalidBlueprint() throws Exception {
        this.structure.getChild(Path.Segment.from((String)"r;resource")).getChild(Path.Segment.from((String)"r;childResource")).replace((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("id")).build());
    }

    @Test
    public void testRecursiveChildrenRemoval() throws Exception {
        this.structure.getChild(Path.Segment.from((String)"r;resource")).remove();
        Assert.assertEquals(new HashSet<Path.Segment>(Arrays.asList(Path.Segment.from((String)"rt;resourceType"), Path.Segment.from((String)"mt;metricType"), Path.Segment.from((String)"m;metric"))), (Object)this.structure.getChildrenPaths());
    }

    @Test
    public void testAddChild() throws Exception {
        this.structure.getChild(Path.Segment.from((String)"r;resource")).addChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("cr2")).withResourceTypePath("../resourceType").build());
        InventoryStructure.Offline s = this.structure.build();
        Assert.assertEquals((long)2L, (long)s.getChildren((RelativePath)RelativePath.to().resource("resource").get(), Resource.class).count());
    }

    @Test
    public void testReplaceChild() throws Exception {
        this.structure.getChild(Path.Segment.from((String)"r;resource")).replace((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("r2")).withResourceTypePath("../resourceType").build());
        InventoryStructure.Offline s = this.structure.build();
        Blueprint b = s.get((RelativePath)RelativePath.to().resource("r2").get());
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((Object)"r2", (Object)((Resource.Blueprint)b).getId());
        b = s.get((RelativePath)RelativePath.to().resource("resource").get());
        Assert.assertNull((Object)b);
        b = s.get((RelativePath)((RelativePath.ResourceBuilder)RelativePath.to().resource("resource").resource("childResource")).get());
        Assert.assertNull((Object)b);
        b = s.get((RelativePath)((RelativePath.MetricBuilder)RelativePath.to().resource("resource").metric("metric")).get());
        Assert.assertNull((Object)b);
    }

    @Test
    public void testRemoveChild() throws Exception {
        this.structure.removeChild(Path.Segment.from((String)"r;resource"));
        InventoryStructure.Offline s = this.structure.build();
        Blueprint b = s.get((RelativePath)RelativePath.to().resource("resource").get());
        Assert.assertNull((Object)b);
        b = s.get((RelativePath)((RelativePath.ResourceBuilder)RelativePath.to().resource("resource").resource("childResource")).get());
        Assert.assertNull((Object)b);
        b = s.get((RelativePath)((RelativePath.MetricBuilder)RelativePath.to().resource("resource").metric("metric")).get());
        Assert.assertNull((Object)b);
    }
}

