/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.SegmentType;

abstract class Mutator<BE, E extends Entity<?, U>, B extends Blueprint, U extends Entity.Update, Id>
extends Traversal<BE, E> {
    protected Mutator(TraversalContext<BE, E> context) {
        super(context);
    }

    protected abstract String getProposedId(Transaction<BE> var1, B var2);

    protected final E doCreate(B blueprint) {
        Traversal.ResultWithNofifications result = this.inTxWithNotifications(tx -> {
            CanonicalPath entityPath;
            Query existenceCheck;
            Page results;
            String id = this.getProposedId(tx, blueprint);
            if (!tx.isUniqueIndexSupported() && (results = tx.query(existenceCheck = this.context.hop().filter().with(With.id(id)).get(), Pager.single())).hasNext()) {
                throw new EntityAlreadyExistsException(id, Query.filters(existenceCheck));
            }
            this.preCreate(blueprint, tx);
            BE parent = this.getParent(tx);
            CanonicalPath parentCanonicalPath = parent == null ? null : tx.extractCanonicalPath(parent);
            Object containsRel = null;
            if (parent == null) {
                if (this.context.entityClass != Tenant.class) throw new IllegalStateException("Could not find the parent of the entity to be created,yet the entity is not a tenant: " + blueprint);
                entityPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(id)).get();
            } else {
                entityPath = parentCanonicalPath.extend(AbstractElement.segmentTypeFromType(this.context.entityClass), id).get();
            }
            Object entityObject = tx.persist(entityPath, (Blueprint)blueprint);
            if (parentCanonicalPath != null) {
                containsRel = tx.relate(parent, entityObject, Relationships.WellKnown.contains.name(), Collections.emptyMap());
                Relationship rel = tx.convert(containsRel, Relationship.class);
                tx.getPreCommit().addNotifications(new EntityAndPendingNotifications<Object, Relationship>(containsRel, rel, new Notification<Relationship, Relationship>(rel, rel, Action.created())));
            }
            EntityAndPendingNotifications newEntity = this.wireUpNewEntity(entityObject, blueprint, parentCanonicalPath, parent, tx);
            if (blueprint instanceof Entity.Blueprint) {
                Entity.Blueprint b = (Entity.Blueprint)blueprint;
                this.createCustomRelationships(entityObject, Relationships.Direction.outgoing, b.getOutgoingRelationships(), tx);
                this.createCustomRelationships(entityObject, Relationships.Direction.incoming, b.getIncomingRelationships(), tx);
            }
            this.postCreate(entityObject, (Entity)newEntity.getEntity(), tx);
            ArrayList notifs = new ArrayList(newEntity.getNotifications());
            notifs.add(new Notification<E, E>(newEntity.getEntity(), newEntity.getEntity(), Action.created()));
            EntityAndPendingNotifications pending = new EntityAndPendingNotifications(newEntity.getEntityRepresentation(), newEntity.getEntity(), notifs);
            tx.getPreCommit().addNotifications(pending);
            return (Entity)newEntity.getEntity();
        });
        Entity entity = result.getResult();
        for (EntityAndPendingNotifications ns : result.getSentNotifications()) {
            Optional<Notification> createdNotification;
            if (!((AbstractElement)ns.getEntity()).getPath().equals((Object)entity.getPath()) || !(createdNotification = ns.getNotifications().stream().filter(n -> n.getAction().asEnum() == Action.Enumerated.CREATED).findAny()).isPresent()) continue;
            entity = (Entity)ns.getEntity();
            break;
        }
        return (E)entity;
    }

    public final void update(Id id, U update) throws EntityNotFoundException {
        this.inTx(tx -> {
            Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
            Util.update(this.context.entityClass, tx, q, update, (e, u, t) -> this.preUpdate(id, e, u, t), this::postUpdate);
            return null;
        });
    }

    public final void delete(Id id) throws EntityNotFoundException {
        this.inTx(tx -> {
            Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
            Util.delete(this.context.entityClass, tx, q, (e, t) -> this.preDelete(id, (BE)e, (Transaction<BE>)t), this::postDelete);
            return null;
        });
    }

    protected void preCreate(B blueprint, Transaction<BE> transaction) {
    }

    protected void postCreate(BE entityObject, E entity, Transaction<BE> transaction) {
    }

    protected void preDelete(Id id, BE entityRepresentation, Transaction<BE> transaction) {
    }

    protected void postDelete(BE entityRepresentation, Transaction<BE> transaction) {
    }

    protected void preUpdate(Id id, BE entityRepresentation, U update, Transaction<BE> transaction) {
    }

    protected void postUpdate(BE entityRepresentation, Transaction<BE> transaction) {
    }

    protected BE getParent(final Transaction<BE> tx) {
        return (BE)ElementTypeVisitor.accept((SegmentType)AbstractElement.segmentTypeFromType(this.context.entityClass), (ElementTypeVisitor)new ElementTypeVisitor.Simple<BE, Void>(){

            protected BE defaultAction(SegmentType elementType, Void parameter) {
                Object res = tx.querySingle(Mutator.this.context.sourcePath);
                if (res == null) {
                    throw new EntityNotFoundException(Mutator.this.context.previous.entityClass, Query.filters(Mutator.this.context.sourcePath));
                }
                return res;
            }

            public BE visitTenant(Void parameter) {
                return null;
            }
        }, null);
    }

    protected BE relate(BE source, BE target, String relationshipName) {
        return (BE)this.inTx(tx -> {
            RelationshipRules.checkCreate(tx, source, Relationships.Direction.outgoing, relationshipName, target);
            return tx.relate(source, target, relationshipName, null);
        });
    }

    protected abstract EntityAndPendingNotifications<BE, E> wireUpNewEntity(BE var1, B var2, CanonicalPath var3, BE var4, Transaction<BE> var5);

    private void createCustomRelationships(BE entity, Relationships.Direction direction, Map<String, Set<CanonicalPath>> otherEnds, Transaction<BE> tx) {
        otherEnds.forEach((name, ends) -> ends.forEach(end -> {
            try {
                Object endObject = tx.find((CanonicalPath)end);
                Object from = direction == Relationships.Direction.outgoing ? entity : endObject;
                Object to = direction == Relationships.Direction.outgoing ? endObject : entity;
                EntityAndPendingNotifications<Object, Relationship> res = Util.createAssociation(tx, from, name, to, null);
                tx.getPreCommit().addNotifications(res);
            }
            catch (ElementNotFoundException e) {
                throw new EntityNotFoundException(Query.filters(Query.to(end)));
            }
        }));
    }
}

