/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="The tenants partition the data in the inventory graph. No relationships between entities from 2 different tenants can exist.", parent=Entity.class)
public final class Tenant
extends Entity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.t;

    private Tenant() {
    }

    public Tenant(CanonicalPath path) {
        this(path, null);
    }

    public Tenant(String name, CanonicalPath path) {
        super(name, path);
    }

    public Tenant(CanonicalPath path, Map<String, Object> properties) {
        super(path, properties);
    }

    public Tenant(String name, CanonicalPath path, Map<String, Object> properties) {
        super(name, path, properties);
    }

    @Override
    public AbstractElement.Updater<Update, Tenant> update() {
        return new AbstractElement.Updater<Update, Tenant>(u -> new Tenant(u.getName(), this.getPath(), u.getProperties()));
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitTenant(this, parameter);
    }

    @ApiModel(value="TenantUpdate")
    public static final class Update
    extends Entity.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(null, properties);
        }

        public Update(String name, Map<String, Object> properties) {
            super(name, properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitTenant(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.name, this.properties);
            }
        }
    }

    @ApiModel(value="TenantBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
        }

        public Blueprint(String id) {
            super(id, Collections.emptyMap());
        }

        public Blueprint(String id, Map<String, Object> properties) {
            super(id, properties);
        }

        public Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
        }

        public Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitTenant(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

