/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.IdentityHashedEntity;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="Metric type defines the unit and data type of a metric. It also specifies the default  collection interval as a guideline for the feed on how often to collect the metric values.", parent=IdentityHashedEntity.class)
public final class MetricType
extends IdentityHashedEntity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.mt;
    private final MetricUnit unit;
    private final MetricDataType type;
    private final Long collectionInterval;

    private MetricType() {
        this.unit = null;
        this.type = null;
        this.collectionInterval = null;
    }

    public MetricType(CanonicalPath path, String identityHash) {
        this(path, identityHash, MetricUnit.NONE, MetricDataType.GAUGE, null, null);
    }

    public MetricType(CanonicalPath path, String identityHash, MetricUnit unit, MetricDataType type) {
        this(path, identityHash, unit, type, null, null);
    }

    public MetricType(CanonicalPath path, String identityHash, MetricUnit unit, MetricDataType type, Long collectionInterval) {
        this(path, identityHash, unit, type, null, collectionInterval);
    }

    public MetricType(String name, CanonicalPath path, String identityHash, MetricUnit unit, MetricDataType type) {
        this(name, path, identityHash, unit, type, null, null);
    }

    public MetricType(CanonicalPath path, String identityHash, MetricUnit unit, MetricDataType type, Map<String, Object> properties, Long collectionInterval) {
        super(path, identityHash, properties);
        if (type == null) {
            throw new IllegalArgumentException("metricDataType == null");
        }
        this.unit = unit;
        this.type = type;
        this.collectionInterval = collectionInterval;
    }

    public MetricType(String name, CanonicalPath path, String identityHash, MetricUnit unit, MetricDataType type, Map<String, Object> properties, Long collectionInterval) {
        super(name, path, identityHash, properties);
        this.type = type;
        this.unit = unit;
        this.collectionInterval = collectionInterval;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public MetricDataType getType() {
        return this.type;
    }

    public Long getCollectionInterval() {
        return this.collectionInterval;
    }

    @Override
    public AbstractElement.Updater<Update, MetricType> update() {
        return new AbstractElement.Updater<Update, MetricType>(u -> new MetricType(u.getName(), this.getPath(), this.getIdentityHash(), MetricType.valueOrDefault(((Update)u).unit, this.unit), this.type, u.getProperties(), MetricType.valueOrDefault(u.getCollectionInterval(), this.collectionInterval)));
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetricType(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", unit=").append((Object)this.unit);
    }

    @ApiModel(value="MetricTypeUpdate")
    public static final class Update
    extends Entity.Update {
        private final MetricUnit unit;
        private final Long collectionInterval;

        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null, null, null);
        }

        public Update(Map<String, Object> properties, MetricUnit unit, Long collectionInterval) {
            super(null, properties);
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public Update(String name, Map<String, Object> properties, MetricUnit unit, Long collectionInterval) {
            super(name, properties);
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public MetricUnit getUnit() {
            return this.unit;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetricType(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Update, Builder> {
            private MetricUnit unit;
            private Long collectionInterval;

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            public Builder withInterval(Long interval) {
                this.collectionInterval = interval;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.name, this.properties, this.unit, this.collectionInterval);
            }
        }
    }

    @ApiModel(value="MetricTypeBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        private final MetricUnit unit;
        private final MetricDataType type;
        private final Long collectionInterval;

        public static Builder builder(MetricDataType type) {
            return new Builder(type);
        }

        private Blueprint() {
            this.unit = null;
            this.type = null;
            this.collectionInterval = null;
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type, Long collectionInterval) {
            this(id, unit, type, Collections.emptyMap(), collectionInterval);
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type, Map<String, Object> properties, Long collectionInterval) {
            super(id, properties);
            this.unit = unit == null ? MetricUnit.NONE : unit;
            this.type = type;
            this.collectionInterval = collectionInterval;
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type, Long collectionInterval, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.type = type;
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public Blueprint(String id, String name, MetricUnit unit, MetricDataType type, Map<String, Object> properties, Long collectionInterval, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
            this.type = type;
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public MetricUnit getUnit() {
            if (this.unit == null) {
                throw new IllegalStateException("Unit of metric type cannot be null.");
            }
            return this.unit;
        }

        public MetricDataType getType() {
            if (this.type == null) {
                throw new IllegalStateException("Data type of metric type cannot be null.");
            }
            return this.type;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetricType(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private MetricUnit unit;
            private MetricDataType type;
            private Long collectionInterval;

            public Builder(MetricDataType type) {
                this.type = type;
            }

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            public Builder withType(MetricDataType type) {
                this.type = type;
                return this;
            }

            public Builder withInterval(Long interval) {
                this.collectionInterval = interval;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.unit, this.type, this.properties, this.collectionInterval, this.outgoing, this.incoming);
            }
        }
    }
}

