/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.Associator;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

public final class BaseMetricTypes {
    private BaseMetricTypes() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Multiple {
        public Multiple(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.defines, Metric.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Single {
        public Single(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedTo(Relationships.WellKnown.defines, Metric.class).get());
        }
    }

    public static class ReadAssociate<BE>
    extends Associator<BE, MetricType>
    implements MetricTypes.ReadAssociate {
        public ReadAssociate(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public Relationship associate(Path id) throws EntityNotFoundException, RelationAlreadyExistsException {
            Query getMetricType = Util.queryTo(this.context, id);
            Object metricType = this.getSingle(getMetricType, MetricType.class);
            return this.createAssociation(ResourceType.class, Relationships.WellKnown.incorporates, metricType);
        }

        @Override
        public Relationship disassociate(Path id) throws EntityNotFoundException {
            Query getMetricType = Util.queryTo(this.context, id);
            Object metricType = this.getSingle(getMetricType, MetricType.class);
            return this.deleteAssociation(ResourceType.class, Relationships.WellKnown.incorporates, metricType);
        }

        @Override
        public Relationship associationWith(Path path) throws RelationNotFoundException {
            return this.getAssociation(ResourceType.class, path, Relationships.WellKnown.incorporates);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.Read {
        public Read(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, MetricType, MetricType.Update>
    implements MetricTypes.ReadContained {
        public ReadContained(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, MetricType, MetricType.Blueprint, MetricType.Update>
    implements MetricTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, MetricType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(MetricType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<MetricType> wireUpNewEntity(BE entity, MetricType.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            this.context.backend.update(entity, MetricType.Update.builder().withUnit(blueprint.getUnit()).build());
            return new EntityAndPendingNotifications<MetricType>(new MetricType(parentPath.extend(MetricType.class, this.context.backend.extractId(entity)).get(), blueprint.getUnit(), blueprint.getType(), blueprint.getProperties()), new EntityAndPendingNotifications.Notification[0]);
        }

        @Override
        public MetricTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public MetricTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public MetricTypes.Single create(MetricType.Blueprint blueprint) throws EntityAlreadyExistsException {
            if (blueprint.getType() == null || blueprint.getUnit() == null) {
                String msg = (blueprint.getType() == null ? "Data type" : "Metric unit") + " is null";
                throw new IllegalArgumentException(msg);
            }
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

