/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

abstract class Mutator<BE, E extends Entity<Blueprint, Update>, Blueprint extends Entity.Blueprint, Update extends AbstractElement.Update>
extends Traversal<BE, E> {
    protected Mutator(TraversalContext<BE, E> context) {
        super(context);
    }

    protected abstract String getProposedId(Blueprint var1);

    protected final Query doCreate(Blueprint blueprint) {
        return this.mutating(transaction -> {
            CanonicalPath entityPath;
            String id = this.getProposedId(blueprint);
            Query existenceCheck = this.context.hop().filter().with(With.id(id)).get();
            Page results = this.context.backend.query(existenceCheck, Pager.single());
            if (!results.isEmpty()) {
                throw new EntityAlreadyExistsException(id, Query.filters(existenceCheck));
            }
            BE parent = this.getParent();
            CanonicalPath parentCanonicalPath = parent == null ? null : this.context.backend.extractCanonicalPath(parent);
            Object containsRel = null;
            if (parent == null) {
                if (this.context.entityClass != Tenant.class) throw new IllegalStateException("Could not find the parent of the entity to be created,yet the entity is not a tenant: " + blueprint);
                entityPath = CanonicalPath.of().tenant(id).get();
            } else {
                entityPath = parentCanonicalPath.extend(this.context.entityClass, id).get();
            }
            Object entityObject = this.context.backend.persist(entityPath, (AbstractElement.Blueprint)blueprint);
            if (parentCanonicalPath != null) {
                containsRel = this.context.backend.relate(parent, entityObject, Relationships.WellKnown.contains.name(), Collections.emptyMap());
            }
            EntityAndPendingNotifications<E> newEntity = this.wireUpNewEntity(entityObject, blueprint, parentCanonicalPath, parent);
            this.context.backend.commit(transaction);
            this.context.notify(newEntity.getEntity(), Action.created());
            if (containsRel != null) {
                this.context.notify(this.context.backend.convert(containsRel, Relationship.class), Action.created());
            }
            this.context.notifyAll(newEntity);
            return Query.to(entityPath);
        });
    }

    public final void update(String id, Update update) throws EntityNotFoundException {
        Util.update(this.context, this.context.select().with(With.id(id)).get(), update);
    }

    public final void delete(String id) throws EntityNotFoundException {
        this.mutating(transaction -> {
            BE toDelete = this.checkExists(id);
            HashSet<BE> verticesToDeleteThatDefineSomething = new HashSet<BE>();
            HashSet<BE> deleted = new HashSet<BE>();
            HashSet deletedRels = new HashSet();
            this.context.backend.getTransitiveClosureOver(toDelete, Relationships.WellKnown.contains.name(), Relationships.Direction.outgoing).forEachRemaining(e -> {
                if (this.context.backend.hasRelationship(e, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    verticesToDeleteThatDefineSomething.add(e);
                } else {
                    deleted.add(e);
                }
                deletedRels.addAll(this.context.backend.getRelationships(e, Relationships.Direction.both, new String[0]));
            });
            if (this.context.backend.hasRelationship(toDelete, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                verticesToDeleteThatDefineSomething.add(toDelete);
            } else {
                deleted.add(toDelete);
            }
            deletedRels.addAll(this.context.backend.getRelationships(toDelete, Relationships.Direction.both, new String[0]));
            Set deletedEntities = deleted.stream().map(o -> this.context.backend.convert(o, this.context.backend.extractType(o))).collect(Collectors.toSet());
            Set deletedRelationships = deletedRels.stream().map(o -> this.context.backend.convert(o, Relationship.class)).collect(Collectors.toSet());
            for (Object e2 : deleted) {
                this.context.backend.delete(e2);
            }
            for (Object e2 : verticesToDeleteThatDefineSomething) {
                if (this.context.backend.hasRelationship(e2, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    String rootId = this.context.backend.extractId(toDelete);
                    String definingId = this.context.backend.extractId(e2);
                    String rootType = this.context.entityClass.getSimpleName();
                    String definingType = this.context.backend.extractType(e2).getSimpleName();
                    String rootEntity = "Entity[id=" + rootId + ", type=" + rootType + "]";
                    String definingEntity = "Entity[id=" + definingId + ", type=" + definingType + "]";
                    throw new IllegalArgumentException("Could not delete entity " + rootEntity + ". The entity " + definingEntity + ", which it (indirectly) contains, acts as a definition for some " + "entities that are not deleted along with it, which would leave them without a " + "definition. This is illegal.");
                }
                this.context.backend.delete(e2);
            }
            this.context.backend.commit(transaction);
            for (Relationship r : deletedRelationships) {
                this.context.notify(r, Action.deleted());
            }
            for (Object e2 : deletedEntities) {
                this.context.notify(e2, Action.deleted());
            }
            return null;
        });
    }

    private BE getParent() {
        return (BE)ElementTypeVisitor.accept(this.context.entityClass, new ElementTypeVisitor.Simple<BE, Void>(){

            @Override
            protected BE defaultAction() {
                Page res = Mutator.this.context.backend.query(Mutator.this.context.sourcePath, Pager.single());
                if (res.isEmpty()) {
                    Class parentEntityClass = null;
                    if (Mutator.this.context.previous != null && Entity.class.isAssignableFrom(Mutator.this.context.previous.entityClass)) {
                        parentEntityClass = Mutator.this.context.previous.entityClass;
                    }
                    throw new EntityNotFoundException(parentEntityClass, Query.filters(Mutator.this.context.sourcePath));
                }
                return res.get(0);
            }

            @Override
            public BE visitTenant(Void parameter) {
                return null;
            }
        }, null);
    }

    protected BE relate(BE source, BE target, String relationshipName) {
        RelationshipRules.checkCreate(this.context.backend, source, Relationships.Direction.outgoing, relationshipName, target);
        return this.context.backend.relate(source, target, relationshipName, null);
    }

    protected abstract EntityAndPendingNotifications<E> wireUpNewEntity(BE var1, Blueprint var2, CanonicalPath var3, BE var4);

    private BE checkExists(String id) {
        Query query = this.context.select().with(With.id(id)).get();
        Page result = this.context.backend.query(query, Pager.single());
        if (result.isEmpty()) {
            throw new EntityNotFoundException(this.context.entityClass, Query.filters(query));
        }
        return result.get(0);
    }
}

