/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;

public final class EntityNotFoundException
extends InventoryException {
    private final Class<? extends Entity<?, ?>> entityType;
    private final Filter[][] filters;

    public EntityNotFoundException(Class<? extends Entity<?, ?>> entityClass, Filter[] filters) {
        this.entityType = entityClass;
        this.filters = new Filter[1][];
        this.filters[0] = filters;
    }

    public EntityNotFoundException(Class<? extends Entity<?, ?>> entityClass, Filter[][] filters) {
        this.entityType = entityClass;
        this.filters = filters;
    }

    public EntityNotFoundException(Class<? extends Entity<?, ?>> entityClass, Filter[] filters, Throwable cause) {
        super(cause);
        this.entityType = entityClass;
        this.filters = new Filter[1][];
        this.filters[0] = filters;
    }

    public Class<? extends Entity<?, ?>> getEntityType() {
        return this.entityType;
    }

    public Filter[][] getFilters() {
        return this.filters;
    }

    @Override
    public String getMessage() {
        return (this.entityType == null ? "Nothing" : "No " + this.entityType.getSimpleName()) + " found on any of the following paths: " + Arrays.deepToString((Object[])this.filters);
    }
}

