/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;

public abstract class Path {
    public static final char TYPE_DELIM = ';';
    public static final char PATH_DELIM = '/';
    public static final char ESCAPE_CHAR = '\\';
    protected final List<Segment> path;
    protected final int startIdx;
    protected final int endIdx;

    Path() {
        this.path = null;
        this.startIdx = 0;
        this.endIdx = 0;
    }

    Path(int startIdx, int endIdx, List<Segment> path) {
        this.startIdx = startIdx;
        this.endIdx = endIdx;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path is not valid.");
        }
        this.path = Collections.unmodifiableList(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Path fromString(String path, boolean shouldBeAbsolute, ExtenderConstructor extenderConstructor, EnhancedTypeProvider typeProvider) {
        Extender extender = extenderConstructor.create(0, new ArrayList<Segment>());
        int startPos = 0;
        try {
            if (shouldBeAbsolute) {
                if (!path.isEmpty() && path.charAt(0) == '/') {
                    startPos = 1;
                } else {
                    throw new IllegalArgumentException("Supplied path is not absolute.");
                }
            }
            ParsingProgress progress = new ParsingProgress(startPos, path);
            Decoder dec = new Decoder(typeProvider);
            while (!progress.isFinished()) {
                Segment seg = dec.decodeNext(progress);
                extender.extend(seg);
            }
            Path path2 = extender.get();
            return path2;
        }
        finally {
            if (typeProvider != null) {
                typeProvider.finished();
            }
        }
    }

    public static Path fromString(String path) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromString(path);
        }
        return RelativePath.fromString(path);
    }

    public static Path fromPartiallyUntypedString(String path, TypeProvider typeProvider) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromPartiallyUntypedString(path, typeProvider);
        }
        return RelativePath.fromPartiallyUntypedString(path, typeProvider);
    }

    public static Path fromPartiallyUntypedString(String path, CanonicalPath canonicalPathsOrigin, CanonicalPath relativePathsOrigin, Class<?> intendedFinalType) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromPartiallyUntypedString(path, canonicalPathsOrigin, intendedFinalType);
        }
        return RelativePath.fromPartiallyUntypedString(path, relativePathsOrigin, intendedFinalType);
    }

    protected abstract Path newInstance(int var1, int var2, List<Segment> var3);

    public abstract RelativePath toRelativePath();

    public abstract CanonicalPath toCanonicalPath();

    public boolean isCanonical() {
        return this instanceof CanonicalPath;
    }

    public boolean isRelative() {
        return this instanceof RelativePath;
    }

    public boolean isDefined() {
        return this.endIdx > this.startIdx && this.endIdx <= this.path.size();
    }

    public Path up() {
        return this.up(1);
    }

    public Path up(int distance) {
        return this.newInstance(this.startIdx, this.endIdx - distance, this.path);
    }

    public Path down() {
        return this.down(1);
    }

    public Path down(int distance) {
        return this.newInstance(this.startIdx, this.endIdx + distance, this.path);
    }

    public int getDepth() {
        return this.endIdx - this.startIdx - 1;
    }

    public Segment getSegment() {
        return this.isDefined() ? this.path.get(this.endIdx - 1) : null;
    }

    public List<Segment> getPath() {
        return this.isDefined() ? this.path.subList(this.startIdx, this.endIdx) : Collections.emptyList();
    }

    public Iterator<? extends Path> ascendingIterator() {
        return new Iterator<Path>(){
            int idx;
            {
                this.idx = Path.this.endIdx;
            }

            @Override
            public boolean hasNext() {
                return this.idx > Path.this.startIdx;
            }

            @Override
            public Path next() {
                if (this.idx <= Path.this.startIdx) {
                    throw new NoSuchElementException();
                }
                return Path.this.newInstance(Path.this.startIdx, this.idx--, Path.this.path);
            }
        };
    }

    public Iterator<? extends Path> descendingIterator() {
        return new Iterator<Path>(){
            int idx;
            {
                this.idx = Path.this.startIdx + 1;
            }

            @Override
            public boolean hasNext() {
                return this.idx <= Path.this.endIdx;
            }

            @Override
            public Path next() {
                if (this.idx > Path.this.endIdx) {
                    throw new NoSuchElementException();
                }
                return Path.this.newInstance(Path.this.startIdx, this.idx++, Path.this.path);
            }
        };
    }

    public int hashCode() {
        int ret = this.startIdx;
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            ret = 31 * ret + this.path.get(i).hashCode();
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Path other = (Path)o;
        if (this.endIdx != other.endIdx || this.startIdx != other.startIdx) {
            return false;
        }
        for (int i = this.endIdx - 1; i >= this.startIdx; --i) {
            if (this.path.get(i).equals(other.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString();
    }

    public static class MetricBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        MetricBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class ResourceBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        ResourceBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public ResourceBuilder<Impl> resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return this;
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class FeedBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        FeedBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public ResourceBuilder<Impl> resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return new ResourceBuilder(this.segments, this.constructor);
        }

        public MetricBuilder<Impl> metric(String id) {
            this.segments.add(new Segment(Metric.class, id));
            return new MetricBuilder(this.segments, this.constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class EnvironmentBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        EnvironmentBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public FeedBuilder<Impl> feed(String id) {
            this.segments.add(new Segment(Feed.class, id));
            return new FeedBuilder(this.segments, this.constructor);
        }

        public ResourceBuilder<Impl> resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return new ResourceBuilder(this.segments, this.constructor);
        }

        public MetricBuilder<Impl> metric(String id) {
            this.segments.add(new Segment(Metric.class, id));
            return new MetricBuilder(this.segments, this.constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class MetricTypeBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        MetricTypeBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class ResourceTypeBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        ResourceTypeBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class TenantBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        TenantBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public EnvironmentBuilder<Impl> environment(String id) {
            this.segments.add(new Segment(Environment.class, id));
            return new EnvironmentBuilder(this.segments, this.constructor);
        }

        public ResourceTypeBuilder<Impl> resourceType(String id) {
            this.segments.add(new Segment(ResourceType.class, id));
            return new ResourceTypeBuilder(this.segments, this.constructor);
        }

        public MetricTypeBuilder<Impl> metricType(String id) {
            this.segments.add(new Segment(MetricType.class, id));
            return new MetricTypeBuilder(this.segments, this.constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class RelationshipBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        RelationshipBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class Builder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        Builder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public TenantBuilder<Impl> tenant(String id) {
            this.segments.add(new Segment(Tenant.class, id));
            return new TenantBuilder(this.segments, this.constructor);
        }

        public RelationshipBuilder<Impl> relationship(String id) {
            this.segments.add(new Segment(Relationship.class, id));
            return new RelationshipBuilder(this.segments, this.constructor);
        }
    }

    protected static abstract class AbstractBuilder<Impl extends Path> {
        protected final List<Segment> segments;
        protected final Constructor<Impl> constructor;

        AbstractBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            this.segments = segments;
            this.constructor = constructor;
        }
    }

    public static class HintedTypeProvider
    implements TypeProvider {
        private final Class<?> intendedFinalType;
        private final Extender extender;

        public HintedTypeProvider(Class<?> intendedFinalType, Extender extender) {
            this.intendedFinalType = intendedFinalType;
            this.extender = extender;
        }

        @Override
        public void segmentParsed(Segment segment) {
            this.extender.extend(segment);
        }

        @Override
        public Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                return null;
            }
            CanonicalPath full = this.extender.get().toCanonicalPath();
            Class<?> nextStep = this.unambiguousPathNextStep(this.intendedFinalType, full.getSegment().getElementType(), isLast, new HashMap());
            if (nextStep != null) {
                return new Segment(nextStep, id);
            }
            return null;
        }

        @Override
        public void finished() {
        }

        private Class<?> unambiguousPathNextStep(Class<?> targetType, Class<?> currentType, boolean isLast, Map<Class<?>, Boolean> visitedTypes) {
            if (targetType.equals(currentType)) {
                return targetType;
            }
            HashSet ret = new HashSet();
            this.fillPossiblePathsToTarget(targetType, currentType, ret, visitedTypes, true);
            if (ret.size() == 0) {
                return null;
            }
            if (ret.size() == 1) {
                return (Class)ret.iterator().next();
            }
            if (isLast && ret.contains(this.intendedFinalType)) {
                return this.intendedFinalType;
            }
            throw new IllegalArgumentException("Cannot unambiguously deduce types of the untyped path segments.");
        }

        private boolean fillPossiblePathsToTarget(Class<?> targetType, Class<?> currentType, Set<Class<?>> result, Map<Class<?>, Boolean> visitedTypes, boolean isStart) {
            if (targetType.equals(currentType)) {
                if (isStart) {
                    result.add(currentType);
                }
                return true;
            }
            List<Class<?>> options = CanonicalPath.VALID_PROGRESSIONS.get(currentType);
            if (options == null || options.isEmpty()) {
                return false;
            }
            boolean matched = false;
            for (Class<?> option : options) {
                if (!visitedTypes.containsKey(option)) {
                    visitedTypes.put(option, false);
                    if (!this.fillPossiblePathsToTarget(targetType, option, result, visitedTypes, false)) continue;
                    if (isStart) {
                        result.add(option);
                    }
                    visitedTypes.put(option, true);
                    matched = true;
                    continue;
                }
                matched |= visitedTypes.get(option).booleanValue();
            }
            return matched;
        }
    }

    public static abstract class Extender {
        private final List<Segment> segments;
        private final Function<List<Segment>, List<Class<?>>> validProgressions;
        private final int from;
        private int checkIndex;

        Extender(int from, List<Segment> segments, boolean mergeWithInitial, Function<List<Segment>, List<Class<?>>> validProgressions) {
            this.from = from;
            this.segments = segments;
            this.validProgressions = validProgressions;
            this.checkIndex = mergeWithInitial ? from : -1;
        }

        protected abstract Path newPath(int var1, int var2, List<Segment> var3);

        public Extender extend(Segment segment) {
            List<Segment> currentSegs;
            List<Class<?>> progress;
            if (this.checkIndex >= 0 && this.checkIndex < this.segments.size()) {
                Segment matching = this.segments.get(this.checkIndex);
                if (matching.equals(segment)) {
                    ++this.checkIndex;
                    return this;
                }
                if (this.checkIndex == this.from) {
                    if (Relationship.class.equals(segment.getElementType())) {
                        this.segments.clear();
                    }
                    this.checkIndex = this.segments.size();
                } else {
                    throw new IllegalArgumentException("The provided segment " + segment + " does not match the" + " expected origin of the path.");
                }
            }
            if ((progress = this.validProgressions.apply(currentSegs = this.checkIndex >= 0 ? this.segments.subList(this.from, this.checkIndex) : this.segments)) == null || !progress.contains(segment.getElementType())) {
                throw new IllegalArgumentException("The provided segment " + segment + " is not valid extension" + " of the path: " + currentSegs + (progress == null ? ". There are no further extensions possible." : ". Valid extension types are: " + progress.stream().map(Class::getSimpleName).collect(Collectors.toList())));
            }
            this.segments.add(segment);
            if (this.checkIndex >= 0) {
                ++this.checkIndex;
            }
            return this;
        }

        protected void removeLastSegment() {
            if (this.segments.size() > 0) {
                this.segments.remove(this.segments.size() - 1);
                if (this.checkIndex > 0) {
                    --this.checkIndex;
                }
            }
        }

        public Extender extend(Collection<Segment> segments) {
            segments.forEach(this::extend);
            return this;
        }

        public Extender extend(Class<? extends AbstractElement<?, ?>> type, String id) {
            return this.extend(new Segment(type, id));
        }

        public Path get() {
            return this.newPath(this.from, this.segments.size(), this.segments);
        }
    }

    public static final class Segment {
        private final Class<?> elementType;
        private final String entityId;

        private Segment() {
            this(null, null);
        }

        public Segment(Class<?> elementType, String entityId) {
            this.entityId = entityId;
            this.elementType = elementType;
        }

        public <R, P> R accept(ElementTypeVisitor<R, P> visitor, P parameter) {
            if (Environment.class.equals(this.elementType)) {
                return visitor.visitEnvironment(parameter);
            }
            if (Feed.class.equals(this.elementType)) {
                return visitor.visitFeed(parameter);
            }
            if (Metric.class.equals(this.elementType)) {
                return visitor.visitMetric(parameter);
            }
            if (MetricType.class.equals(this.elementType)) {
                return visitor.visitMetricType(parameter);
            }
            if (Relationship.class.equals(this.elementType)) {
                return visitor.visitRelationship(parameter);
            }
            if (Resource.class.equals(this.elementType)) {
                return visitor.visitResource(parameter);
            }
            if (ResourceType.class.equals(this.elementType)) {
                return visitor.visitResourceType(parameter);
            }
            if (Tenant.class.equals(this.elementType)) {
                return visitor.visitTenant(parameter);
            }
            return visitor.visitUnknown(parameter);
        }

        public String getElementId() {
            return this.entityId;
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.elementType == segment.elementType && Objects.equals(this.entityId, segment.entityId);
        }

        public int hashCode() {
            int result = this.elementType.hashCode();
            result = 31 * result + this.entityId.hashCode();
            return result;
        }

        public String toString() {
            return "Segment[entityId='" + this.entityId + '\'' + ", entityType=" + this.elementType.getSimpleName() + ']';
        }
    }

    protected static class Encoder {
        private final Map<Class<?>, String> typeMap;
        private final Function<Segment, Boolean> requiresId;

        public Encoder(Map<Class<?>, String> typeMap, Function<Segment, Boolean> requiresId) {
            this.typeMap = typeMap;
            this.requiresId = requiresId;
        }

        public String encode(String prefix, Path path) {
            StringBuilder bld = new StringBuilder(prefix);
            for (Segment seg : path.getPath()) {
                String type = this.typeMap.get(seg.getElementType());
                if (type != null) {
                    bld.append(type);
                }
                if (seg.getElementId() != null && this.requiresId.apply(seg).booleanValue()) {
                    if (type != null) {
                        bld.append(';');
                    }
                    for (int j = 0; j < seg.getElementId().length(); ++j) {
                        char c = seg.getElementId().charAt(j);
                        if (c == ';' || c == '/' || c == '\\') {
                            bld.append('\\');
                        }
                        bld.append(c);
                    }
                }
                bld.append('/');
            }
            return bld.delete(bld.length() - 1, bld.length()).toString();
        }
    }

    protected static class Decoder {
        private final EnhancedTypeProvider typeProvider;

        protected Decoder(EnhancedTypeProvider typeProvider) {
            this.typeProvider = typeProvider;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Segment decodeNext(ParsingProgress progress) {
            Segment ret;
            String currentIdString;
            StringBuilder currentId = new StringBuilder();
            String currentTypeString = null;
            int state = 0;
            int stateBeforeEscapeChar = -1;
            block14: while (!progress.isFinished()) {
                char c = progress.getNextChar();
                switch (state) {
                    case 0: {
                        switch (c) {
                            case ';': {
                                if (currentId.length() == 0) {
                                    throw new IllegalArgumentException("Unspecified entity type id at pos " + progress.getPos() + " in \"" + progress.getSource() + "\".");
                                }
                                currentTypeString = currentId.toString();
                                currentId.delete(0, currentId.length());
                                state = 1;
                                break;
                            }
                            case '/': {
                                currentTypeString = currentId.toString();
                                currentId.delete(0, currentId.length());
                                break block14;
                            }
                            case '\\': {
                                state = 2;
                                stateBeforeEscapeChar = 0;
                                break;
                            }
                            default: {
                                currentId.append(c);
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '\\': {
                                state = 2;
                                stateBeforeEscapeChar = 1;
                                break;
                            }
                            case '/': {
                                if (currentId.length() != 0) break block14;
                                throw new IllegalArgumentException("Unspecified entity id at pos " + progress.getPos() + " in \"" + progress.getSource() + "\".");
                            }
                            default: {
                                currentId.append(c);
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        currentId.append(c);
                        state = stateBeforeEscapeChar;
                        stateBeforeEscapeChar = -1;
                    }
                }
            }
            if ((currentIdString = currentId.toString()).isEmpty()) {
                currentIdString = currentTypeString;
                currentTypeString = null;
            }
            if ((ret = this.typeProvider.deduceSegment(currentTypeString, currentIdString, progress.isFinished())) == null) {
                throw new IllegalArgumentException("Unrecognized entity type '" + currentTypeString + "' for segment" + " with id: '" + currentIdString + "'. The following types are recognized: " + this.typeProvider.getValidTypeName());
            }
            this.typeProvider.segmentParsed(ret);
            return ret;
        }
    }

    protected static class ParsingProgress {
        private final String source;
        private int pos;

        public ParsingProgress(int pos, String source) {
            this.pos = pos;
            this.source = source;
        }

        public int getPos() {
            return this.pos;
        }

        public char getNextChar() {
            return this.source.charAt(this.pos++);
        }

        public String getSource() {
            return this.source;
        }

        public boolean isFinished() {
            return this.pos >= this.source.length();
        }
    }

    static abstract class EnhancedTypeProvider
    implements TypeProvider {
        EnhancedTypeProvider() {
        }

        abstract Set<String> getValidTypeName();
    }

    @FunctionalInterface
    protected static interface ExtenderConstructor {
        public Extender create(int var1, List<Segment> var2);
    }

    public static interface TypeProvider {
        public void segmentParsed(Segment var1);

        public Segment deduceSegment(String var1, String var2, boolean var3);

        public void finished();
    }

    @FunctionalInterface
    static interface Constructor<Path> {
        public Path create(int var1, int var2, List<Segment> var3);
    }
}

