/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.base.BaseFeeds;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseEnvironments {
    private BaseEnvironments() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Environment, Environment.Update>
    implements Environments.Multiple {
        public Multiple(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Feeds.ReadContained feeds() {
            return new BaseFeeds.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Feed.class).get());
        }

        @Override
        public Resources.ReadContained feedlessResources() {
            return new BaseResources.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadContained feedlessMetrics() {
            return new BaseMetrics.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Resources.Read allResources() {
            return new BaseResources.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}}).getting(Resource.class));
        }

        @Override
        public Metrics.Read allMetrics() {
            return new BaseMetrics.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}}).getting(Metric.class));
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Environment, Environment.Update>
    implements Environments.Single {
        public Single(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Feeds.ReadWrite feeds() {
            return new BaseFeeds.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Feed.class).get());
        }

        @Override
        public Resources.ReadWrite feedlessResources() {
            return new BaseResources.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadWrite feedlessMetrics() {
            return new BaseMetrics.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Resources.Read allResources() {
            return new BaseResources.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}}).getting(Resource.class));
        }

        @Override
        public Metrics.Read allMetrics() {
            return new BaseMetrics.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}}).getting(Metric.class));
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Environment>
    implements Environments.Read {
        public Read(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, Environment>
    implements Environments.ReadContained {
        public ReadContained(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Environment, Environment.Blueprint, Environment.Update>
    implements Environments.ReadWrite {
        public ReadWrite(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Environment.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<Environment> wireUpNewEntity(BE entity, Environment.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            return new EntityAndPendingNotifications<Environment>(new Environment(parentPath.extend(Environment.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new EntityAndPendingNotifications.Notification[0]);
        }

        @Override
        public void copy(String sourceEnvironmentId, String targetEnvironmentId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public Environments.Single create(Environment.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

