/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hawkular.inventory.api.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationLoadingTest {
    @Test
    public void testLoadFromMap() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("a", "a");
        props.put("b", "b");
        Configuration config = Configuration.builder().withConfiguration(props).build();
        Assert.assertEquals((long)2L, (long)config.getImplementationConfiguration(Collections.emptyList()).size());
        Assert.assertEquals((Object)"a", config.getImplementationConfiguration(Collections.emptyList()).get("a"));
        Assert.assertEquals((Object)"b", config.getImplementationConfiguration(Collections.emptyList()).get("b"));
    }

    @Test
    public void testLoadFromProperties() throws Exception {
        Properties props = new Properties();
        props.put("a", "a");
        props.put("b", "b");
        Configuration config = Configuration.builder().withConfiguration(props).build();
        Assert.assertEquals((long)2L, (long)config.getImplementationConfiguration(Collections.emptyList()).size());
        Assert.assertEquals((Object)"a", config.getImplementationConfiguration(Collections.emptyList()).get("a"));
        Assert.assertEquals((Object)"b", config.getImplementationConfiguration(Collections.emptyList()).get("b"));
    }

    @Test
    public void testGetPropertyFromSysProps() throws Exception {
        System.setProperty("a", "SYS_PROP");
        Properties props = new Properties();
        props.put("a", "a");
        props.put("b", "b");
        Configuration config = Configuration.builder().withConfiguration(props).build();
        String val = config.getProperty(Configuration.Property.builder().withPropertyNameAndSystemProperty("a").build(), null);
        Assert.assertEquals((Object)"SYS_PROP", (Object)val);
        Assert.assertEquals((Object)"b", (Object)config.getProperty(Configuration.Property.builder().withPropertyName("b").build(), null));
    }

    @Test
    public void testGetPropertyFromEnvironment() throws Exception {
        Configuration config = Configuration.builder().addConfigurationProperty("HOME", "asdf").build();
        Assert.assertNotEquals((Object)"asdf", (Object)config.getProperty(Configuration.Property.builder().withPropertyName("home").withEnvironmentVariables(new String[]{"HOME"}).build(), null));
    }

    @Test
    public void testLoadImplementationConfigContainsAllInfo() throws Exception {
        Configuration empty = Configuration.builder().build();
        Map config = empty.getImplementationConfiguration(Arrays.asList(Configuration.Property.builder().withPropertyName("javaHome").withSystemProperties(new String[]{"java.home"}).build(), Configuration.Property.builder().withPropertyName("home").withEnvironmentVariables(new String[]{"HOME"}).build()));
        Assert.assertEquals((long)2L, (long)config.size());
    }
}

