/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionConstructor;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.Discriminator;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PreCommitActionsTest {
    @Test
    public void testPreCommitActionsInSingleActionTransaction() throws Exception {
        InventoryBackend backend = (InventoryBackend)Mockito.mock(InventoryBackend.class);
        int[] payloadsExecuted = new int[1];
        PrecommitTracker pct = new PrecommitTracker();
        Mockito.when((Object)backend.startTransaction()).then(a -> {
            payloadsExecuted[0] = payloadsExecuted[0] + 1;
            Assert.assertEquals((long)0L, (long)pct.actionsObtained);
            return backend;
        });
        Mockito.when((Object)backend.persist((Discriminator)Matchers.any(), (CanonicalPath)Matchers.any(), (Blueprint)Matchers.any())).thenAnswer(args -> args.getArguments()[1].toString());
        this.commonBackendMocks((InventoryBackend<String>)backend);
        ((InventoryBackend)Mockito.doAnswer(args -> {
            Assert.assertEquals((long)1L, (long)payloadsExecuted[0]);
            Assert.assertEquals((long)1L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)pct.finalNotificationsObtained);
            return null;
        }).when((Object)backend)).commit();
        TestInventory inv = new TestInventory((InventoryBackend<String>)backend, pct);
        inv.initialize(new Configuration(null, null, Collections.emptyMap()));
        inv.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf")).build());
        Assert.assertEquals((long)1L, (long)payloadsExecuted[0]);
        Assert.assertEquals((long)1L, (long)pct.actionsObtained);
        Assert.assertEquals((long)1L, (long)pct.finalNotificationsObtained);
    }

    @Test
    public void testPreCommitActionsInTransactionFrame() throws Exception {
        InventoryBackend backend = (InventoryBackend)Mockito.mock(InventoryBackend.class);
        Mockito.when((Object)backend.startTransaction()).thenReturn((Object)backend);
        int[] dataPersisted = new int[1];
        int[] notifsSent = new int[1];
        PrecommitTracker pct = new PrecommitTracker();
        TestInventory inv = new TestInventory((InventoryBackend<String>)backend, pct);
        inv.observable(Interest.in(Tenant.class).being(Action.created())).subscribe(t -> {
            notifsSent[0] = notifsSent[0] + 1;
        });
        Mockito.when((Object)backend.persist((Discriminator)Matchers.any(), (CanonicalPath)Matchers.any(), (Blueprint)Matchers.any())).thenAnswer(args -> {
            dataPersisted[0] = dataPersisted[0] + 1;
            return args.getArguments()[1].toString();
        });
        this.commonBackendMocks((InventoryBackend<String>)backend);
        ((InventoryBackend)Mockito.doAnswer(args -> {
            Assert.assertEquals((long)2L, (long)dataPersisted[0]);
            Assert.assertEquals((long)1L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            return null;
        }).when((Object)backend)).commit();
        inv.initialize(new Configuration(null, null, Collections.emptyMap()));
        TransactionFrame frame = inv.newTransactionFrame();
        Inventory inv2 = frame.boundInventory();
        inv2.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf")).build());
        inv2.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf2")).build());
        frame.commit();
        Assert.assertEquals((long)2L, (long)dataPersisted[0]);
        Assert.assertEquals((long)1L, (long)pct.actionsObtained);
        Assert.assertEquals((long)2L, (long)notifsSent[0]);
    }

    @Test
    public void testPreCommitActionsInRetriedTransaction() throws Exception {
        InventoryBackend backend = (InventoryBackend)Mockito.mock(InventoryBackend.class);
        Mockito.when((Object)backend.startTransaction()).thenReturn((Object)backend);
        int[] dataPersisted = new int[1];
        int[] notifsSent = new int[1];
        PrecommitTracker pct = new PrecommitTracker();
        TestInventory inv = new TestInventory((InventoryBackend<String>)backend, pct);
        inv.observable(Interest.in(Tenant.class).being(Action.created())).subscribe(t -> {
            notifsSent[0] = notifsSent[0] + 1;
        });
        ((InventoryBackend)Mockito.doAnswer(args -> {
            Assert.assertEquals((long)1L, (long)dataPersisted[0]);
            Assert.assertEquals((long)1L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            throw new CommitFailureException();
        }).doAnswer(args -> {
            Assert.assertEquals((long)2L, (long)dataPersisted[0]);
            Assert.assertEquals((long)2L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            throw new CommitFailureException();
        }).doAnswer(args -> {
            Assert.assertEquals((long)3L, (long)dataPersisted[0]);
            Assert.assertEquals((long)3L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            return null;
        }).when((Object)backend)).commit();
        Mockito.when((Object)backend.persist((Discriminator)Matchers.any(), (CanonicalPath)Matchers.any(), (Blueprint)Matchers.any())).thenAnswer(args -> {
            dataPersisted[0] = dataPersisted[0] + 1;
            return args.getArguments()[1].toString();
        });
        this.commonBackendMocks((InventoryBackend<String>)backend);
        inv.initialize(new Configuration(null, null, Collections.emptyMap()));
        inv.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf")).build());
        Assert.assertEquals((long)3L, (long)dataPersisted[0]);
        Assert.assertEquals((long)3L, (long)pct.actionsObtained);
        Assert.assertEquals((long)1L, (long)notifsSent[0]);
    }

    @Test
    public void testPreCommitInRetriedTransactionFrame() throws Exception {
        InventoryBackend backend = (InventoryBackend)Mockito.mock(InventoryBackend.class);
        Mockito.when((Object)backend.startTransaction()).thenReturn((Object)backend);
        int[] dataPersisted = new int[1];
        int[] notifsSent = new int[1];
        PrecommitTracker pct = new PrecommitTracker();
        TestInventory inv = new TestInventory((InventoryBackend<String>)backend, pct);
        inv.observable(Interest.in(Tenant.class).being(Action.created())).subscribe(t -> {
            notifsSent[0] = notifsSent[0] + 1;
        });
        ((InventoryBackend)Mockito.doAnswer(args -> {
            Assert.assertEquals((long)2L, (long)dataPersisted[0]);
            Assert.assertEquals((long)1L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            throw new CommitFailureException();
        }).doAnswer(args -> {
            Assert.assertEquals((long)4L, (long)dataPersisted[0]);
            Assert.assertEquals((long)2L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            throw new CommitFailureException();
        }).doAnswer(args -> {
            Assert.assertEquals((long)6L, (long)dataPersisted[0]);
            Assert.assertEquals((long)3L, (long)pct.actionsObtained);
            Assert.assertEquals((long)0L, (long)notifsSent[0]);
            return null;
        }).when((Object)backend)).commit();
        Mockito.when((Object)backend.persist((Discriminator)Matchers.any(), (CanonicalPath)Matchers.any(), (Blueprint)Matchers.any())).thenAnswer(args -> {
            dataPersisted[0] = dataPersisted[0] + 1;
            return args.getArguments()[1].toString();
        });
        this.commonBackendMocks((InventoryBackend<String>)backend);
        inv.initialize(new Configuration(null, null, Collections.emptyMap()));
        TransactionFrame frame = inv.newTransactionFrame();
        Inventory inv2 = frame.boundInventory();
        inv2.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf")).build());
        inv2.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("asdf2")).build());
        frame.commit();
        Assert.assertEquals((long)6L, (long)dataPersisted[0]);
        Assert.assertEquals((long)3L, (long)pct.actionsObtained);
        Assert.assertEquals((long)2L, (long)notifsSent[0]);
        ((InventoryBackend)Mockito.verify((Object)backend, (VerificationMode)Mockito.times((int)3))).commit();
    }

    private void commonBackendMocks(InventoryBackend<String> backend) throws Exception {
        Mockito.when((Object)backend.isUniqueIndexSupported()).thenReturn((Object)true);
        Mockito.when((Object)backend.isPreferringBigTransactions()).thenReturn((Object)true);
        Mockito.when((Object)backend.extractId(Matchers.any())).thenAnswer(args -> CanonicalPath.fromString((String)args.getArguments()[0].toString()).getSegment().getElementId());
        Mockito.when((Object)backend.extractType(Matchers.any())).thenAnswer(args -> {
            SegmentType t = CanonicalPath.fromString((String)((String)args.getArgumentAt(0, String.class))).getSegment().getElementType();
            return Inventory.types().bySegment(t).getElementType();
        });
        Mockito.when((Object)backend.find((Discriminator)Matchers.any(), (CanonicalPath)Matchers.any())).thenAnswer(args -> ((CanonicalPath)args.getArgumentAt(1, CanonicalPath.class)).toString());
        Mockito.when((Object)backend.convert((Discriminator)Matchers.any(), Matchers.any(), (Class)Matchers.any())).thenAnswer(args -> {
            Class type = (Class)args.getArgumentAt(2, Class.class);
            String path = (String)args.getArgumentAt(1, String.class);
            Constructor ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            Object entity = ctor.newInstance(new Object[0]);
            Field pathF = null;
            while (true) {
                try {
                    pathF = type.getDeclaredField("path");
                }
                catch (NoSuchFieldException e) {
                    type = type.getSuperclass();
                    continue;
                }
                break;
            }
            pathF.setAccessible(true);
            pathF.set(entity, CanonicalPath.fromString((String)path));
            return entity;
        });
    }

    private static final class TestInventory
    extends BaseInventory<String> {
        private final InventoryBackend<String> backend;
        private final PrecommitTracker tracker;

        public TestInventory(InventoryBackend<String> backend, PrecommitTracker tracker) {
            super((b, p) -> {
                Transaction.PreCommit<String> realPrecommit = tracker.apply((Transaction.PreCommit<String>)p);
                return TransactionConstructor.startInBackend().construct(b, realPrecommit);
            });
            this.backend = backend;
            this.tracker = tracker;
        }

        private TestInventory(BaseInventory<String> orig, InventoryBackend<String> backend, TransactionConstructor<String> transactionConstructor, PrecommitTracker tracker) {
            super(orig, backend, transactionConstructor);
            this.backend = backend;
            this.tracker = tracker;
        }

        protected BaseInventory<String> cloneWith(TransactionConstructor<String> transactionCtor) {
            return new TestInventory(this, this.backend, transactionCtor, this.tracker);
        }

        protected TransactionConstructor<String> adaptTransactionConstructor(TransactionConstructor<String> txCtor) {
            return (b, p) -> {
                Transaction.PreCommit<String> realPrecommit = this.tracker.apply((Transaction.PreCommit<String>)p);
                return txCtor.construct(b, realPrecommit);
            };
        }

        protected InventoryBackend<String> doInitialize(Configuration configuration) {
            return this.backend;
        }
    }

    private static final class PrecommitTracker
    implements Function<Transaction.PreCommit<String>, Transaction.PreCommit<String>> {
        int actionsObtained;
        int finalNotificationsObtained;
        int initialized;
        int reset;

        private PrecommitTracker() {
        }

        @Override
        public Transaction.PreCommit<String> apply(final Transaction.PreCommit<String> pc) {
            return new Transaction.PreCommit<String>(){

                public List<EntityAndPendingNotifications<String, ?>> getFinalNotifications() {
                    ++finalNotificationsObtained;
                    return pc.getFinalNotifications();
                }

                public void initialize(Inventory inventory, Transaction<String> tx) {
                    if (this.getClass() != pc.getClass()) {
                        ++initialized;
                    }
                    pc.initialize(inventory, tx);
                }

                public void reset() {
                    if (this.getClass() != pc.getClass()) {
                        ++reset;
                    }
                    pc.reset();
                }

                public void addAction(Consumer<Transaction<String>> action) {
                    pc.addAction(action);
                }

                public List<Consumer<Transaction<String>>> getActions() {
                    if (this.getClass() != pc.getClass()) {
                        ++actionsObtained;
                    }
                    return pc.getActions();
                }

                public void addNotifications(EntityAndPendingNotifications<String, ?> element) {
                    pc.addNotifications(element);
                }

                public void addProcessedNotifications(EntityAndPendingNotifications<String, ?> element) {
                    pc.addProcessedNotifications(element);
                }
            };
        }
    }
}

