/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hawkular.inventory.api.TreeTraversal;
import org.junit.Assert;
import org.junit.Test;

public class TreeTraversalTest {
    private final Node tree = new Node(-1);

    public TreeTraversalTest() {
        this.tree.children.add(new Node(0));
        this.tree.children.add(new Node(1));
        this.tree.children.add(new Node(2));
        this.tree.children.get((int)0).children.add(new Node(3));
        this.tree.children.get((int)0).children.add(new Node(4));
        this.tree.children.get((int)1).children.add(new Node(5));
        this.tree.children.get((int)1).children.get((int)0).children.add(new Node(6));
    }

    @Test
    public void testDfs() throws Exception {
        TreeTraversal tr = new TreeTraversal(n -> n.children.iterator());
        ArrayList order = new ArrayList();
        tr.depthFirst((Object)this.tree, n -> order.add(n.id));
        Assert.assertEquals(Arrays.asList(-1, 0, 3, 4, 1, 5, 6, 2), order);
    }

    @Test
    public void testBfs() throws Exception {
        TreeTraversal tr = new TreeTraversal(n -> n.children.iterator());
        ArrayList order = new ArrayList();
        tr.breadthFirst((Object)this.tree, n -> order.add(n.id));
        Assert.assertEquals(Arrays.asList(-1, 0, 1, 2, 3, 4, 5, 6), order);
    }

    private static final class Node {
        final int id;
        final List<Node> children = new ArrayList<Node>();

        public Node(int id) {
            this.id = id;
        }
    }
}

