/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;
import rx.Observable;

public interface Inventory
extends AutoCloseable,
Tenants.Container<Tenants.ReadWrite> {
    public Inventory at(Instant var1);

    public void initialize(Configuration var1);

    public TransactionFrame newTransactionFrame();

    @Override
    public Tenants.ReadWrite tenants();

    public Relationships.Read relationships();

    default public Tenants.Single inspect(Tenant tenant) throws EntityNotFoundException {
        return (Tenants.Single)this.tenants().get(tenant.getId());
    }

    default public Environments.Single inspect(Environment environment) throws EntityNotFoundException {
        return this.inspect(environment.getPath(), Environments.Single.class);
    }

    default public Feeds.Single inspect(Feed feed) throws EntityNotFoundException {
        return this.inspect(feed.getPath(), Feeds.Single.class);
    }

    default public Metrics.Single inspect(Metric metric) throws EntityNotFoundException {
        return this.inspect(metric.getPath(), Metrics.Single.class);
    }

    default public MetricTypes.Single inspect(MetricType metricType) throws EntityNotFoundException {
        return this.inspect(metricType.getPath(), MetricTypes.Single.class);
    }

    default public Resources.Single inspect(Resource resource) throws EntityNotFoundException {
        return this.inspect(resource.getPath(), Resources.Single.class);
    }

    default public ResourceTypes.Single inspect(ResourceType resourceType) throws EntityNotFoundException {
        return this.inspect(resourceType.getPath(), ResourceTypes.Single.class);
    }

    default public Data.Single inspect(DataEntity data) throws EntityNotFoundException {
        return this.inspect(data.getPath(), Data.Single.class);
    }

    default public OperationTypes.Single inspect(OperationType operationType) throws EntityNotFoundException {
        return this.inspect(operationType.getPath(), OperationTypes.Single.class);
    }

    default public MetadataPacks.Single inspect(MetadataPack metadataPack) throws EntityNotFoundException {
        return this.inspect(metadataPack.getPath(), MetadataPacks.Single.class);
    }

    default public Relationships.Single inspect(Relationship relationship) {
        return (Relationships.Single)this.relationships().get(relationship.getId());
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(E entity, final Class<Single> accessInterface) {
        return (Single)((ResolvableToSingle)entity.accept(new ElementVisitor<Single, Void>(){

            @Override
            public Single visitTenant(Tenant tenant, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(tenant));
            }

            @Override
            public Single visitEnvironment(Environment environment, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(environment));
            }

            @Override
            public Single visitFeed(Feed feed, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(feed));
            }

            @Override
            public Single visitMetric(Metric metric, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metric));
            }

            @Override
            public Single visitMetricType(MetricType definition, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(definition));
            }

            @Override
            public Single visitResource(Resource resource, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(resource));
            }

            @Override
            public Single visitResourceType(ResourceType type, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(type));
            }

            @Override
            public Single visitData(DataEntity data, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(data));
            }

            @Override
            public Single visitOperationType(OperationType operationType, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(operationType));
            }

            @Override
            public Single visitRelationship(Relationship relationship, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(relationship.getId()));
            }

            @Override
            public Single visitMetadataPack(MetadataPack metadataPack, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metadataPack));
            }

            @Override
            public Single visitUnknown(Object entity, Void parameter) {
                return null;
            }
        }, null));
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(final CanonicalPath path, final Class<Single> accessInterface) {
        final CanonicalPath.IdExtractor ids = path.ids();
        return (Single)((ResolvableToSingle)path.accept(new ElementTypeVisitor<Single, Void>(){

            public Single visitTenant(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.tenants().get(ids.getTenantId()));
            }

            public Single visitEnvironment(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(ids.getTenantId())).environments()).get(ids.getEnvironmentId()));
            }

            public Single visitFeed(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Feeds.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(ids.getTenantId())).feeds()).get(ids.getFeedId()));
            }

            public Single visitMetric(Void parameter) {
                Tenants.Single tenant = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                RelativePath resourcePath = ids.getResourcePath();
                String feedId = ids.getFeedId();
                String environmentId = ids.getEnvironmentId();
                String metricId = ids.getMetricId();
                ResolvableToSingle iface = resourcePath == null ? (feedId == null ? (ResolvableToSingle)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(environmentId)).metrics()).get(metricId) : (ResolvableToSingle)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(feedId)).metrics()).get(metricId)) : (feedId == null ? (ResolvableToSingle)((Metrics.ReadWrite)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(environmentId)).resources()).descendContained(ids.getResourcePath()).metrics()).get(metricId) : (ResolvableToSingle)((Metrics.ReadWrite)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(feedId)).resources()).descendContained(ids.getResourcePath()).metrics()).get(metricId));
                return (ResolvableToSingle)accessInterface.cast(iface);
            }

            public Single visitMetricType(Void parameter) {
                Tenants.Single ten = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                return (ResolvableToSingle)accessInterface.cast(ids.getFeedId() == null ? ((MetricTypes.ReadWrite)ten.metricTypes()).get(ids.getMetricTypeId()) : ((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)ten.feeds()).get(ids.getFeedId())).metricTypes()).get(ids.getMetricTypeId()));
            }

            public Single visitResource(Void parameter) {
                Tenants.Single tenant = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                Resources.Single access = ids.getFeedId() == null ? ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)tenant.environments()).get(ids.getEnvironmentId())).resources()).descendContained(ids.getResourcePath()) : ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get(ids.getFeedId())).resources()).descendContained(ids.getResourcePath());
                return (ResolvableToSingle)accessInterface.cast(access);
            }

            public Single visitResourceType(Void parameter) {
                Tenants.Single ten = (Tenants.Single)Inventory.this.tenants().get(ids.getTenantId());
                return (ResolvableToSingle)accessInterface.cast(ids.getFeedId() == null ? ((ResourceTypes.ReadWrite)ten.resourceTypes()).get(ids.getResourceTypeId()) : ((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)ten.feeds()).get(ids.getFeedId())).resourceTypes()).get(ids.getResourceTypeId()));
            }

            public Single visitRelationship(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(ids.getRelationshipId()));
            }

            public Single visitData(Void parameter) {
                String rt = ids.getResourceTypeId();
                String ot = ids.getOperationTypeId();
                if (rt != null && ot == null) {
                    ResourceTypes.Single rts = Inventory.this.inspect(path.up(), ResourceTypes.Single.class);
                    DataRole.ResourceType role = DataRole.ResourceType.valueOf((String)ids.getDataRole());
                    return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)rts.data()).get(role));
                }
                if (ot != null) {
                    OperationTypes.Single ots = Inventory.this.inspect(path.up(), OperationTypes.Single.class);
                    DataRole.OperationType role = DataRole.OperationType.valueOf((String)ids.getDataRole());
                    return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)ots.data()).get(role));
                }
                Resources.Single res = Inventory.this.inspect(path.up(), Resources.Single.class);
                DataRole.Resource role = DataRole.Resource.valueOf((String)ids.getDataRole());
                return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)res.data()).get(role));
            }

            public Single visitOperationType(Void parameter) {
                ResourceTypes.Single rt = Inventory.this.inspect(path.up(), ResourceTypes.Single.class);
                return (ResolvableToSingle)accessInterface.cast(((OperationTypes.ReadWrite)rt.operationTypes()).get(path.getSegment().getElementId()));
            }

            public Single visitMetadataPack(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((MetadataPacks.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.up().getSegment().getElementId())).metadataPacks()).get(path.getSegment().getElementId()));
            }

            public Single visitUnknown(Void parameter) {
                return null;
            }
        }, null));
    }

    public boolean hasObservers(Interest<?, ?> var1);

    public <C, E> Observable<C> observable(Interest<C, E> var1);

    public InputStream getGraphSON(String var1);

    public <T extends AbstractElement<?, ?>> T getElement(CanonicalPath var1);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath var1, Relationships.Direction var2, Class<T> var3, String ... var4);

    public Configuration getConfiguration();

    default public <T extends AbstractElement> Page<T> execute(Query query, Class<T> requestedEntity, Pager pager) {
        return new Page(Collections.emptyIterator(), new PageContext(0, 0, Order.unspecified()), 0L);
    }

    public static <B extends Blueprint> B asBlueprint(Entity<B, ?> entity) {
        if (entity == null) {
            return null;
        }
        return (B)((Blueprint)entity.accept(new ElementVisitor<B, Void>(){

            @Override
            public B visitData(DataEntity data, Void parameter) {
                return this.fillCommon(data, new DataEntity.Blueprint.Builder()).withRole(data.getRole()).withValue(data.getValue()).build();
            }

            @Override
            public B visitTenant(Tenant tenant, Void parameter) {
                return this.fillCommon(tenant, new Tenant.Blueprint.Builder()).build();
            }

            @Override
            public B visitEnvironment(Environment environment, Void parameter) {
                return this.fillCommon(environment, new Environment.Blueprint.Builder()).build();
            }

            @Override
            public B visitFeed(Feed feed, Void parameter) {
                return this.fillCommon(feed, Feed.Blueprint.builder()).build();
            }

            @Override
            public B visitMetric(Metric metric, Void parameter) {
                RelativePath metricTypePath = metric.getType().getPath().relativeTo(metric.getPath());
                return this.fillCommon(metric, Metric.Blueprint.builder()).withInterval(metric.getCollectionInterval()).withMetricTypePath(metricTypePath.toString()).build();
            }

            @Override
            public B visitMetricType(MetricType type, Void parameter) {
                return this.fillCommon(type, MetricType.Blueprint.builder(type.getMetricDataType())).withInterval(type.getCollectionInterval()).withUnit(type.getUnit()).build();
            }

            @Override
            public B visitOperationType(OperationType operationType, Void parameter) {
                return this.fillCommon(operationType, OperationType.Blueprint.builder()).build();
            }

            @Override
            public B visitMetadataPack(MetadataPack metadataPack, Void parameter) {
                throw new IllegalStateException("Computing a blueprint of a metadatapack is not supported.");
            }

            @Override
            public B visitUnknown(Object entity1, Void parameter) {
                throw new IllegalStateException("Unhandled entity type during conversion to blueprint: " + entity1.getClass());
            }

            @Override
            public B visitResource(Resource resource, Void parameter) {
                RelativePath resourceTypePath = resource.getType().getPath().relativeTo(resource.getPath());
                return this.fillCommon(resource, Resource.Blueprint.builder()).withResourceTypePath(resourceTypePath.toString()).build();
            }

            @Override
            public B visitResourceType(ResourceType type, Void parameter) {
                return this.fillCommon(type, ResourceType.Blueprint.builder()).build();
            }

            @Override
            public B visitRelationship(Relationship relationship, Void parameter) {
                throw new IllegalArgumentException("Inventory structure blueprint conversion does not handle relationships.");
            }

            private <X extends Entity<? extends XB, ?>, XB extends Entity.Blueprint, XBB extends Entity.Blueprint.Builder<XB, XBB>> XBB fillCommon(X e, XBB bld) {
                return (XBB)((Entity.Blueprint.Builder)((AbstractElement.Blueprint.Builder)((Entity.Blueprint.Builder)bld.withId(e.getId())).withName(e.getName())).withProperties(e.getProperties()));
            }
        }, null));
    }

    public static Types types() {
        return Types.INSTANCE;
    }

    public static final class ElementTypes<E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> {
        private final Class<? extends ResolvableToSingle<E, U>> singleAccessorType;
        private final Class<? extends ResolvableToMany<E>> manyAccessorType;
        private final Class<B> blueprintType;
        private final Class<U> updateType;
        private final Class<E> elementType;
        private final SegmentType segmentType;

        private ElementTypes(Class<? extends ResolvableToSingle<E, U>> singleAccessorType, Class<? extends ResolvableToMany<E>> manyAccessorType, Class<B> blueprintType, Class<U> updateType, Class<E> elementType, SegmentType segmentType) {
            this.singleAccessorType = singleAccessorType;
            this.manyAccessorType = manyAccessorType;
            this.blueprintType = blueprintType;
            this.updateType = updateType;
            this.elementType = elementType;
            this.segmentType = segmentType;
        }

        public Class<B> getBlueprintType() {
            return this.blueprintType;
        }

        public Class<E> getElementType() {
            return this.elementType;
        }

        public SegmentType getSegmentType() {
            return this.segmentType;
        }

        public Class<U> getUpdateType() {
            return this.updateType;
        }

        public Class<? extends ResolvableToMany<E>> getMultipleAccessorType() {
            return this.manyAccessorType;
        }

        public Class<? extends ResolvableToSingle<E, U>> getSingleAccessorType() {
            return this.singleAccessorType;
        }
    }

    public static final class Types {
        private static final Types INSTANCE = new Types();
        private static final EnumMap<SegmentType, ElementTypes<?, ?, ?>> elementTypes = new EnumMap(SegmentType.class);

        private Types() {
        }

        public Set<ElementTypes<? extends Entity<?, ?>, ?, ?>> entityTypes() {
            return elementTypes.entrySet().stream().filter(e -> {
                SegmentType st = (SegmentType)e.getKey();
                return st != SegmentType.rl;
            }).map(e -> (ElementTypes)e.getValue()).collect(Collectors.toSet());
        }

        public ElementTypes<?, ?, ?> byPath(Path path) {
            return this.bySegment(path.getSegment().getElementType());
        }

        public ElementTypes<?, ?, ?> bySegment(SegmentType segmentType) {
            ElementTypes<?, ?, ?> ret = elementTypes.get(segmentType);
            if (ret == null) {
                throw new IllegalArgumentException("Unsupported segment type: " + segmentType);
            }
            return ret;
        }

        public <B extends Blueprint> ElementTypes<? extends AbstractElement<B, ?>, B, ?> byBlueprint(Class<B> blueprintType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?, ?> ret = elementTypes.get(st);
                if (!ret.getBlueprintType().equals(blueprintType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown blueprint type: " + blueprintType);
        }

        public <U extends AbstractElement.Update> ElementTypes<?, ?, U> byUpdate(Class<U> updateType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?, ?> ret = elementTypes.get(st);
                if (!ret.getUpdateType().equals(updateType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown update type: " + updateType);
        }

        public <E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> ElementTypes<E, B, U> byElement(Class<E> elementType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?, ?> ret = elementTypes.get(st);
                if (!ret.getElementType().equals(elementType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown element type: " + elementType);
        }

        public <E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> ElementTypes<E, B, U> bySingle(Class<? extends ResolvableToSingle<E, U>> singleAccessorType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?, ?> ret = elementTypes.get(st);
                if (!ret.getSingleAccessorType().equals(singleAccessorType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown single accessor type: " + singleAccessorType);
        }

        public <E extends AbstractElement<B, U>, B extends Blueprint, U extends AbstractElement.Update> ElementTypes<E, B, U> byMultiple(Class<? extends ResolvableToMany<E>> multipleAccessorType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?, ?> ret = elementTypes.get(st);
                if (!ret.getMultipleAccessorType().equals(multipleAccessorType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown multiple accessor type: " + multipleAccessorType);
        }

        static {
            elementTypes.put(SegmentType.d, new ElementTypes(Data.Single.class, Data.Multiple.class, DataEntity.Blueprint.class, DataEntity.Update.class, DataEntity.class, SegmentType.d));
            elementTypes.put(SegmentType.e, new ElementTypes(Environments.Single.class, Environments.Multiple.class, Environment.Blueprint.class, Environment.Update.class, Environment.class, SegmentType.e));
            elementTypes.put(SegmentType.f, new ElementTypes(Feeds.Single.class, Feeds.Multiple.class, Feed.Blueprint.class, Feed.Update.class, Feed.class, SegmentType.f));
            elementTypes.put(SegmentType.m, new ElementTypes(Metrics.Single.class, Metrics.Multiple.class, Metric.Blueprint.class, Metric.Update.class, Metric.class, SegmentType.m));
            elementTypes.put(SegmentType.mp, new ElementTypes(MetadataPacks.Single.class, MetadataPacks.Multiple.class, MetadataPack.Blueprint.class, MetadataPack.Update.class, MetadataPack.class, SegmentType.mp));
            elementTypes.put(SegmentType.mt, new ElementTypes(MetricTypes.Single.class, MetricTypes.Multiple.class, MetricType.Blueprint.class, MetricType.Update.class, MetricType.class, SegmentType.mt));
            elementTypes.put(SegmentType.ot, new ElementTypes(OperationTypes.Single.class, OperationTypes.Multiple.class, OperationType.Blueprint.class, OperationType.Update.class, OperationType.class, SegmentType.ot));
            elementTypes.put(SegmentType.r, new ElementTypes(Resources.Single.class, Resources.Multiple.class, Resource.Blueprint.class, Resource.Update.class, Resource.class, SegmentType.r));
            elementTypes.put(SegmentType.rl, new ElementTypes(Relationships.Single.class, Relationships.Multiple.class, Relationship.Blueprint.class, Relationship.Update.class, Relationship.class, SegmentType.rl));
            elementTypes.put(SegmentType.rt, new ElementTypes(ResourceTypes.Single.class, ResourceTypes.Multiple.class, ResourceType.Blueprint.class, ResourceType.Update.class, ResourceType.class, SegmentType.rt));
            elementTypes.put(SegmentType.t, new ElementTypes(Tenants.Single.class, Tenants.Multiple.class, Tenant.Blueprint.class, Tenant.Update.class, Tenant.class, SegmentType.t));
        }
    }
}

