/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.time.Instant;
import java.util.Objects;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;

public final class Change<Element extends Entity<?, ?>>
implements Comparable<Change<?>> {
    private final Instant time;
    private final Action<?, Element> action;
    private final Object actionContext;

    public <C> Change(Instant time, Action<C, Element> action, C actionContext) {
        time = Objects.requireNonNull(time, "time == null");
        action = Objects.requireNonNull(action, "action == null");
        actionContext = Objects.requireNonNull(actionContext, "actionContext == null");
        this.time = time;
        this.action = action;
        this.actionContext = actionContext;
    }

    public Instant getTime() {
        return this.time;
    }

    public Action<?, Element> getAction() {
        return this.action;
    }

    public Object getActionContext() {
        return this.actionContext;
    }

    public Element getElement() {
        if (this.action.asEnum() == Action.updated().asEnum()) {
            return (Element)((Entity)((Action.Update)this.actionContext).getOriginalEntity());
        }
        return (Element)((Entity)this.actionContext);
    }

    @Override
    public int compareTo(Change<?> o) {
        int diff = this.time.compareTo(o.time);
        if (diff != 0) {
            return diff;
        }
        diff = this.action.asEnum().ordinal() - o.action.asEnum().ordinal();
        if (diff != 0) {
            return diff;
        }
        return ((AbstractElement)this.getElement()).getPath().toString().compareTo(((AbstractElement)o.getElement()).getPath().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        return this.time.equals(change.time) && this.action.equals(change.action) && ((AbstractElement)this.getElement()).equals(change.getElement());
    }

    public int hashCode() {
        int result = this.time.hashCode();
        result = 31 * result + this.action.hashCode();
        result = 31 * result + this.actionContext.hashCode();
        return result;
    }
}

